

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexTagList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexTagList.sp,v $ $Id: AppGetIndexTagList.sp,v 1.1.44.1 2018/03/22 01:31:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetIndexTagList <<<'

IF EXISTS (select * from sysobjects where name='AppGetIndexTagList')
	drop procedure AppGetIndexTagList
IF EXISTS (select * from GxQscripts where name='AppGetIndexTagList')
	delete from GxQscripts where name = 'AppGetIndexTagList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexTagList')
	delete from GXDBVersions where aliasname = 'AppGetIndexTagList'
GO
print '... Creating Procedure: AppGetIndexTagList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexTagList
  @i_userId INT,
  @i_tagid VARCHAR(36)='',
  @o_xmlText XML	OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode			 INT=0
DECLARE @errorString		 NVARCHAR(MAX)=N''
DECLARE @indexingCommonGuiId VARCHAR(36)
IF EXISTS (SELECT TOP(1) containerGuid FROM DM2Container WHERE containerName='Indexing Tags')
	set @indexingCommonGuiId = ISNULL((SELECT TOP(1) containerGuid FROM DM2Container WHERE containerName='Indexing Tags'), '')
IF (@i_tagid ='')
	SET @o_xmlText  =
		(
					SELECT
						TagID			AS '@idxTagGUID',
						containerGuid	AS '@containerGuid',
						TagValue		AS '@tagValue',
						TagDesc			AS '@tagDesc',
						ownerUserId		AS '@ownerUserId',
						CreatedBy		AS '@createdBy'
					FROM   DM2DocTags
							WHERE  ownerUserId = @i_userId AND
								containerGuid = @indexingCommonGuiId
				FOR XML PATH('tag'), ROOT('App_GetIndexingTagRes')
		)
ELSE
	SET @o_xmlText  =
		(
					SELECT
						TagID			AS '@idxTagGUID',
						containerGuid	AS '@containerGuid',
						TagValue		AS '@tagValue',
						TagDesc			AS '@tagDesc',
						ownerUserId		AS '@ownerUserId',
						CreatedBy		AS '@createdBy'
					FROM   DM2DocTags
							WHERE	ownerUserId		= @i_userId AND
									containerGuid	= @indexingCommonGuiId AND
									TagID			= @i_tagid
				FOR XML PATH('tag'), ROOT('App_GetIndexingTagRes')
		)
	IF @o_xmlText IS null
		SET @o_xmlText = '<App_GetIndexingTagRes/>'
	IF @@ERROR > 0
	BEGIN
		SET @errorCode = @@ERROR
		SET @errorString = 'Failed to get the tag values.'
		GOTO ERROR_EXIT
	END
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText  =
		(	SELECT
				(   SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
					FOR XML PATH('error'),TYPE
				)
			FOR XML PATH ('App_GetIndexingTagRes'), TYPE
		)
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexTagList')
	delete from GxQscripts where name = 'AppGetIndexTagList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexTagList')
	delete from GXDBVersions where aliasname = 'AppGetIndexTagList'
GO

insert into GXDBVersions values(2, 'AppGetIndexTagList',  '00010001004400010000', 'AppGetIndexTagList', '00010001004400010000')
GO

