

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexServersforNFSObjectStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexServersforNFSObjectStore.sp,v $ $Id: AppGetIndexServersforNFSObjectStore.sp,v 1.1.2.2 2020/08/24 16:58:14 alakra Exp $";
--	+=================================================================================================+
--	| AppGetIndexServersforNFSObjectStore - Get Index Server List for NFS Object Store
--	+=================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexServersforNFSObjectStore')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexServersforNFSObjectStore <<<'
	drop procedure AppGetIndexServersforNFSObjectStore
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexServersforNFSObjectStore')
	delete from GxQscripts where name = 'AppGetIndexServersforNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServersforNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetIndexServersforNFSObjectStore'
GO
print '... Creating Procedure: AppGetIndexServersforNFSObjectStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexServersforNFSObjectStore
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML ,
  @o_xmlResp NVARCHAR(MAX) OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	BEGIN TRY
	 DECLARE @i_userId INTEGER=0
     SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlString.nodes('App_NFSIndexServerRequest/processinginstructioninfo/user') R ( ref )),0)
		IF OBJECT_ID('tempdb.dbo.#NFSIndexServerTbl') IS NOT NULL DROP TABLE #NFSIndexServerTbl
			CREATE TABLE #NFSIndexServerTbl
											(
												maClientId INT,
												maClientName NVARCHAR(256),
												nfsCacheLocation NVARCHAR(1024),
												indexServerClientId INT,
												indexServerClientName NVARCHAR(512),
												cacheLocation NVARCHAR(1024),
												cloudId INT,
												cloudName NVARCHAR(256)
											)
		IF OBJECT_ID('tempdb.dbo.#MAsWithManageCapability') IS NOT NULL DROP TABLE #MAsWithManageCapability
			CREATE TABLE #MAsWithManageCapability (entityID INT)
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
										(     serverURL NVARCHAR(512),
												clientId INT,
												clientName NVARCHAR(256),
												cloudId INT,
												hostName NVARCHAR(256),
												basePort INT,
												engineName  NVARCHAR(256),
												serverType INT,
												indexServerClientId INT,
												internalCloudName NVARCHAR(256)
										)
		IF OBJECT_ID('tempdb.dbo.#nfsCacheLocations') IS NOT NULL     DROP TABLE #nfsCacheLocations
		CREATE TABLE #nfsCacheLocations
										(
											cloudId INT,
											propertyName NVARCHAR(512) ,
											propertyValue NVARCHAR(1024)
										)
EXEC sec_getNonIdaObjectsForThisUser @i_userId,11,10,'#MAsWithManageCapability'
		-- Get All both flavor Media Agent
		INSERT INTO #NFSIndexServerTbl (maClientId, maClientName, nfsCacheLocation)
		SELECT DISTINCT AC.id, AC.displayName, IDX.nfsCachePath FROM MMHost MM
		INNER JOIN simInstalledPackages SIM
			ON SIM.ClientId=MM.ClientId
		INNER JOIN #MAsWithManageCapability MAC
			ON MAC.entityID=MM.ClientId
		INNER JOIN APP_Client AC
			ON AC.id=MM.ClientId
		LEFT OUTER JOIN
						(SELECT IDXA.ClientId AS clientId, IDXA.Path AS nfsCachePath
								FROM IdxCache IDXC
									INNER JOIN IdxAccessPath IDXA ON IDXC.IdxCacheId = IDXA.IdxCacheId where IDXC.IdxCacheType=3) IDX
			ON IDX.ClientId=MM.ClientId
		--Get All index server with NFS Index Role
		-- Will poppulate data in #getIndexServers
		EXEC DM2GetIndexServers 'NFS Index', 0/*i_indexServerClientId*/, 0 /*i_cloudId*/, 0 /*i_nodeClientId*/, 1 /*i_status*/
		UPDATE NFSTbl
			SET NFSTbl.indexServerClientId=Idx.indexServerClientId,
				NFSTbl.indexServerClientName = AC.displayName,
				NFSTbl.cloudId=Idx.cloudId,
				NFSTbl.cloudName=IDx.internalCloudName
		FROM #NFSIndexServerTbl NFSTbl
		INNER JOIN #getIndexServers Idx
			ON Idx.clientId=NFSTbl.maClientId
		INNER JOIN APP_Client AC ON
			AC.ID=IDX.indexServerClientId
		UPDATE NFSTbl
			SET NFSTbl.cacheLocation=Cache.nfsCacheLocation
		FROM #NFSIndexServerTbl NFSTbl
		INNER JOIN (SELECT dm.cloudId AS cloudId,ref.value('@value', 'NVARCHAR(1024)') AS nfsCacheLocation
						FROM DM2Cloud DM
						CROSS APPLY (select CAST(DM.CloudProps AS xml)) as T(X)
						CROSS APPLY T.X.nodes('/CloudMetaProp/cloudMetaInfos') as R(ref)
						WHERE ref.value('@name', 'NVARCHAR(1024)')='INDEXLOCATION') Cache
			ON Cache.cloudId=NFSTbl.cloudId
			SET @o_xmlResp =
								(SELECT
									(SELECT nfsCacheLocation '@nfsCacheLocation',
										( SELECT maClientId '@mediaAgentId', maClientName '@mediaAgentName', 3 '@_type_' FOR XML PATH('mediaAgent'), TYPE ),
										( SELECT cacheLocation '@cacheLocation',
												( SELECT indexServerClientId '@clientId', indexServerClientName '@clientName', 3 '@_type_' FOR XML PATH('indexServer'), TYPE),
												( SELECT cloudId '@cloudId', cloudName '@cloudDisplayName', 3 '@_type_'FOR XML PATH('cloudEntity'), TYPE)
											FOR XML PATH('indexServerDetails'), TYPE
										),
										( SELECT S.id AS '@osId', S.Type AS '@Type', S.SubType AS '@SubType',
											( SELECT CO.osName AS '@OSName',  dbo.GetClientHardwareName(maClientId, NULL) AS '@ProcessorType'
												FOR XML PATH('OsDisplayInfo'), TYPE
                                            )
											FROM simOperatingSystem AS S
												INNER JOIN APP_Client AC
													ON AC.id=maClientId AND S.id=AC.simOperatingSystemId
											LEFT OUTER JOIN ClientOSNameView CO
													ON CO.clientId=maClientId
											FOR XML PATH('osInfo'),TYPE
										)
									FROM #NFSIndexServerTbl cl FOR XML PATH('nfsServers'), TYPE
									),
									( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'FOR XML PATH('genericError'), TYPE)
								FOR XML PATH('App_NFSIndexServerResponse'))
			IF OBJECT_ID('tempdb.dbo.#MAsWithManageCapability') IS NOT NULL		DROP TABLE #MAsWithManageCapability
			IF OBJECT_ID('tempdb.dbo.#NFSIndexServerTbl') IS NOT NULL			DROP TABLE #NFSIndexServerTbl
			IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL				DROP TABLE #getIndexServers
			IF OBJECT_ID('tempdb.dbo.#nfsCacheLocations') IS NOT NULL			DROP TABLE #nfsCacheLocations
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
			SET @o_xmlResp =
								(SELECT
									( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'FOR XML PATH('genericError'), TYPE)
								FOR XML PATH('App_NFSIndexServerResponse'))
	END CATCH
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexServersforNFSObjectStore')
	delete from GxQscripts where name = 'AppGetIndexServersforNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServersforNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetIndexServersforNFSObjectStore'
GO

insert into GXDBVersions values(2, 'AppGetIndexServersforNFSObjectStore',  '00010001000200020000', 'AppGetIndexServersforNFSObjectStore', '00010001000200020000')
GO

