

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexServerList.sp,v $ $Id: AppGetIndexServerList.sp,v 1.1.2.4 2019/02/22 22:03:20 pankajkumar Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexServerList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexServerList <<<'
	drop procedure AppGetIndexServerList
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexServerList')
	delete from GxQscripts where name = 'AppGetIndexServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerList')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerList'
GO
print '... Creating Procedure: AppGetIndexServerList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexServerList
  @i_idxClusterType INT=0,
  @i_roleType INT=0,
  @i_cloudType INT=0
AS
  DECLARE @o_xmlOut XML =''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @IndexServerListTbl 	TABLE(
				clusterType integer NOT NULL DEFAULT 0,
				Id	integer,
				Name  nvarchar(1024)	)
--filter based on cloudtype, roletype
INSERT INTO @IndexServerListTbl
SELECT IP.attrVal, C.id,  C.Name
FROM APP_Client C
JOIN APP_Application S ON C.Id = S.clientId
JOIN APP_InstanceProp IP ON S.instance = IP.componentNameId
JOIN DM2Cloud DC ON DC.pseudoClientId = C.Id
JOIN DM2CloudCoreRole R ON DC.CloudId = R.cloudId
WHERE  IP.attrname  = 'Distributed Cluster Type' AND ( @i_idxClusterType = 0 OR attrVal = @i_idxClusterType)
AND (@i_roleType = 0 OR R.roleId = @i_roleType)
AND (@i_cloudType = 0 OR DC.cloudType = @i_cloudType)
--select * from @IndexServerListTbl
--sample output
/*<App_IndexServerListResp>
    <indexServers clusterType="6">
        <clients clientId="21" clientName="client1"/>
    </indexServers>
    <indexServers clusterType="6">
        <clients clientId="22" clientName="test1"/>
    </indexServers>
</App_IndexServerListResp>
*/
--output
SET @o_xmlOut = ISNULL(( 	SELECT
							(
							SELECT
							T.clusterType AS '@clusterType',
							(
							SELECT
								T.Id AS '@clientId',
								T.Name AS '@clientName'
								FOR XML PATH('clients'), TYPE
								)
								FROM @IndexServerListTbl T
								FOR XML PATH('indexServers'), TYPE
					 ) FOR XML PATH('App_IndexServerListResp')
					 ),'<App_IndexServerListResp/>')
SELECT @o_xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexServerList')
	delete from GxQscripts where name = 'AppGetIndexServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerList')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerList'
GO

insert into GXDBVersions values(2, 'AppGetIndexServerList',  '00010001000200040000', 'AppGetIndexServerList', '00010001000200040000')
GO

