

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexServerGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexServerGroup.sp,v $ $Id: AppGetIndexServerGroup.sp,v 1.1.2.10 2020/01/10 19:44:53 pankajkumar Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexServerGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexServerGroup <<<'
	drop procedure AppGetIndexServerGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexServerGroup')
	delete from GxQscripts where name = 'AppGetIndexServerGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerGroup')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerGroup'
GO
print '... Creating Procedure: AppGetIndexServerGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexServerGroup
  @i_idxClusterType INT=0
AS
  DECLARE @o_xmlOut XML =''
--usage: get index server pools details during index server creation
--get all node lists for given input cluster type
DECLARE @clientGroupName nvarchar(1024)
DECLARE @IndexServerGroupTbl 	TABLE(
				t_ClusterType	integer,
				t_clientGroupName  nvarchar(1024),
				t_clientGroupId	int,
				t_clientId	integer,
				t_clientName  nvarchar(1024)	)
INSERT INTO @IndexServerGroupTbl (t_ClusterType, t_clientId, t_clientName)
SELECT IP.attrVal, C.id,  C.Name
FROM APP_Client C WITH (NOLOCK)
JOIN APP_Application S WITH (NOLOCK) ON C.Id = S.clientId
JOIN APP_InstanceProp IP WITH (NOLOCK) ON S.instance = IP.componentNameId
WHERE  IP.attrname  = 'Distributed Cluster Type' AND ( @i_idxClusterType = 0 OR IP.attrVal = @i_idxClusterType)
--update client group name for index server & content analyzer
IF @i_idxClusterType IN (6,10)
BEGIN
	IF EXISTS (SELECT 1 FROM @IndexServerGroupTbl)
		UPDATE @IndexServerGroupTbl
		SET t_clientGroupName = CG.name ,
		t_clientGroupId = CG.id
		FROM APP_ClientGroup CG (NOLOCK)
		inner join APP_ClientGroupAssoc CGA (nolock) on CG.id = CGA.clientGroupId
		WHERE t_clientId = CGA.clientId
ELSE IF @i_idxClusterType = 6
		INSERT INTO @IndexServerGroupTbl (t_ClusterType, t_clientGroupName, t_clientGroupId)
		SELECT @i_idxClusterType, Name, CLG.id
		FROM APP_ClientGroup CLG (nolock)
		INNER JOIN APP_ClientGroupProp CLP ON CLG.ID =CLP.componentNameId
WHERE CLP.attrName = 'Client Group Unique Id'
AND CLP.attrVal = 8
				AND CLP.modified = 0
ELSE IF @i_idxClusterType = 10
		INSERT INTO @IndexServerGroupTbl (t_ClusterType, t_clientGroupName, t_clientGroupId)
		SELECT @i_idxClusterType, Name, CLG.id
		FROM APP_ClientGroup CLG (nolock)
		INNER JOIN APP_ClientGroupProp CLP ON CLG.ID =CLP.componentNameId
WHERE CLP.attrName = 'Client Group Unique Id'
AND CLP.attrVal = 9
				AND CLP.modified = 0
END--select * from @IndexServerListTbl
--sample output
/*<App_IndexServerGroupResp>
  <cgEntity clusterType="6">
    <clientGroup clientGroupName="Index Server Clients"  clientGroupId="2"/>
    <clients clientId="3056" clientName="solr01" />
    <clients clientId="3057" clientName="solr02" />
  </cgEntity>
</App_IndexServerGroupResp>
*/
--output
SET @o_xmlOut = ISNULL((SELECT
							(SELECT
							T.t_ClusterType AS '@clusterType',
								(SELECT
								T.t_clientGroupName AS '@clientGroupName',
								T.t_clientGroupId AS '@clientGroupId'
								FOR XML PATH('clientGroup'), TYPE
								),
								(SELECT
								T1.t_clientId AS '@clientId',
								T1.t_clientName AS '@clientName'
								FROM @IndexServerGroupTbl T1
								WHERE T1.t_ClusterType = T.t_ClusterType
								FOR XML PATH('clients'), TYPE
								)
								FROM @IndexServerGroupTbl T
								GROUP BY t_clientGroupId,t_clientGroupName, t_ClusterType
								FOR XML PATH('cgEntity'), TYPE
					 ) FOR XML PATH('App_IndexServerGroupResp')
					 ),'<App_IndexServerGroupResp/>')
SELECT @o_xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexServerGroup')
	delete from GxQscripts where name = 'AppGetIndexServerGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerGroup')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerGroup'
GO

insert into GXDBVersions values(2, 'AppGetIndexServerGroup',  '00010001000200100000', 'AppGetIndexServerGroup', '00010001000200100000')
GO

