

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexServerForArchGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexServerForArchGroup.sp,v $ $Id: AppGetIndexServerForArchGroup.sp,v 1.1.2.9 2020/07/24 15:33:22 pankajkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: AppGetIndexServerForArchGroup                              |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexServerForArchGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexServerForArchGroup <<<'
	drop procedure AppGetIndexServerForArchGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexServerForArchGroup')
	delete from GxQscripts where name = 'AppGetIndexServerForArchGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerForArchGroup')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerForArchGroup'
GO
print '... Creating Procedure: AppGetIndexServerForArchGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexServerForArchGroup
  @o_xmlText XML OUTPUT
AS
DECLARE @i_localeId     		INTEGER
DECLARE @i_storagePolicyId		INTEGER
DECLARE @i_roleName				NVARCHAR(64)
DECLARE	@maClientId			   	integer =0
DECLARE	@indexServerClientId    integer = 0
DECLARE	@isRoleConfigured		integer = 0
DECLARE	@indexServerCloudId     integer = 0
DECLARE @roleId 				integer = 0
DECLARE @isReqPackagesInstalled integer =0
DECLARE	@errorCode			    integer =0
DECLARE	@errorStr			    NVARCHAR(256)
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/*
For a given storage policy, fetch any MA where
1.	Cvsolr/standalone server with VSA role exists
2.	Cvsolr/Standalone server configured without VSA role
3.	Empty/fresh machine exists without any indexserver configuration, then configure cvsolr.
	a)try to get Media Agent which have all the required packages installed.
	b)If no such media agent with required packages are found, try to figure out any Media agent which is not infrastructure client (CS, webconsole or webserver).
			1.	If such MA is found, then return only this MA (one or all that are identified with above criteria).
4.	Cloud mode server with VSA role exists
5.	Else throw an error that no server exists.
*/
BEGIN TRY
	SET @i_localeId			=	ISNULL (( SELECT ref.value('@localeId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequestEx/processinginstructioninfo/locale') R(ref)), 0)
	SET @i_storagePolicyId	=	ISNULL (( SELECT ref.value('@storagePolicyId', 'INT')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequestEx/storagePolicy') R(ref)), 0)
	SET @i_roleName			=	ISNULL (( SELECT ref.value('@roleName', 'NVARCHAR(64)')
									FROM @o_xmlText.nodes ('App_AdvancedIndexingPreProcessRequestEx') R(ref)), N'')
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)  WHERE messageId = (4391 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
--input Validation
IF @i_storagePolicyId = 0 OR NOT EXISTS (SELECT TOP 1 1 FROM ArchGroup WHERE ID = @i_storagePolicyId AND id > 1)
BEGIN
	SET @errorCode = 12738 --INVALID_STORAGE_POLICY
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4389 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO proc_exit
END
IF @i_roleName = N''
BEGIN
	SET @errorCode = 12751 --ROLE_ID_INVALID
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4388 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO proc_exit
END
SELECT TOP 1 @roleId = roleId FROM DM2CloudRoleMaster WHERE roleTypeName = @i_roleName
IF ISNULL(@roleId,0)=0
BEGIN
	SET @errorCode = 12751 --ROLE_ID_INVALID
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4388 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO proc_exit
END
--
--get information from MMEntityProp cache table
SET @indexServerClientId = ISNULL((SELECT intVal FROM MMEntityProp WHERE EntityId = @i_storagePolicyId AND EntityType = 17  AND propertyName = 'StoragePolicyIndexServerMap' AND modified =0),0)
IF @indexServerClientId != 0
BEGIN
	--found existing index server information from MMEntityProp table
    --Get index server cloudId
	SET @indexServerCloudId = (SELECT TOP 1 cloudId FROM DM2Cloud WHERE pseudoClientId = @indexServerClientId)
	IF ISNULL(@indexServerCloudId,0) = 0
	BEGIN
		SET @errorCode = 12712 --CLOUD_PSEUDOCLIENT_INVALID
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4387 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
		GOTO proc_exit
	END
	--check if input role exists in the indexServerClientId
	IF EXISTS(SELECT TOP 1 1 FROM DM2CloudCoreRole WHERE cloudId = @indexServerCloudId AND roleId = @roleId AND status = 1)
	BEGIN
		SET @isRoleConfigured = 1
		GOTO proc_exit
	END
END
--required packages lists
DECLARE @packageIdsTbl TABLE (t_simPackageId INT)
INSERT INTO @packageIdsTbl VALUES	(55),
(1306),
(263),
(1156)
--get all media agents for given storage policy for primary copy.
DECLARE @maClientsTbl	TABLE (t_clientId INT, t_allPackagesInstalled INT DEFAULT 0, t_isInfrastructureClient INT DEFAULT 0)
INSERT INTO @maClientsTbl (t_clientId)
SELECT DISTINCT  DPool.ClientId
FROM    ArchGroup AG
JOIN    MMDataPath DPath ON AG.defaultCopy = DPath.CopyId
JOIN    MMDrivePool DPool ON DPath.DrivePoolId = DPool.DrivePoolId
WHERE   AG.id = @i_storagePolicyId
--check if any MA found
IF NOT EXISTS (SELECT TOP 1 1 FROM @maClientsTbl)
BEGIN
	SET @errorCode = 3013 --NO_ASSOCIATED_CLIENTS
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4390 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO proc_exit
END
--Delete MA which are offline
DELETE T
FROM @maClientsTbl T
	INNER JOIN MMHost MH ON T.t_clientId = MH.clientId
	LEFT OUTER JOIN APP_ClientProp ACP
ON ACP.componentNameId=T.t_clientId AND ACP.attrName='Automatic Advanced Indexing Install Callback' AND ACP.attrval='1' AND ACP.modified=0
WHERE (MH.MmHostSoftState = 0 OR MH.MmHostEnabled = 0 OR Attribute & 16 != 0) AND ACP.id IS NULL
--check if all MA are offline or not available
IF NOT EXISTS (SELECT TOP 1 1 FROM @maClientsTbl)
BEGIN
	SET @errorCode = 12850 --MEDIAAGENT_OFFLINE
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs WHERE messageId = (4396 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO proc_exit
END
--get cvsolr/standalone index servers which are configured on any mediaagents
	DECLARE @MAtoIndexServerClientTbl TABLE (t_maId INT, t_indexServerClientId INT, t_cloudId INT)
	INSERT INTO @MAtoIndexServerClientTbl (t_maId, t_indexServerClientId, t_cloudId)
	SELECT S.clientId, C.pseudoClientId, C.cloudId
	FROM DM2Cloud C
		JOIN DM2SearchServerCoreInfo S ON C.cloudId = S.cloudId
		JOIN @maClientsTbl T ON S.clientId = t_clientId
WHERE S.cloudType = 1 AND C.status = 1
--get mediaagent clientId & index server for which VSA role is configured
IF EXISTS (SELECT TOP 1 1 FROM @MAtoIndexServerClientTbl)
BEGIN
	--Pick index server with input role
	 SELECT TOP 1 @maClientId = t_maId, @indexServerClientId = t_indexServerClientId, @isRoleConfigured = 1, @indexServerCloudId = t_cloudId
	 FROM @MAtoIndexServerClientTbl T
			JOIN DM2CloudCoreRole R ON T.t_cloudId = R.cloudId
			WHERE R.roleId = @roleId AND R.status = 1
	--otherwise, pick any index server
	IF ISNULL(@indexServerClientId,0) = 0
		SELECT TOP 1 @maClientId = t_maId, @indexServerClientId = t_indexServerClientId, @indexServerCloudId = t_cloudId
		FROM @MAtoIndexServerClientTbl
END
ELSE
BEGIN
	--pick any empty maclientId which has all required packages installed and index server is not configured
	IF ISNULL(@maClientId,0) = 0
	BEGIN
			UPDATE @maClientsTbl
			SET t_allPackagesInstalled = CASE WHEN  packageCount= 2 THEN 1 ELSE 0 END
			FROM
				(SELECT COUNT(simPackageID) packageCount, ClientId
				FROM simInstalledPackages SIM (NOLOCK) JOIN @maClientsTbl T ON clientId = T.t_clientId
				JOIN @packageIdsTbl P ON SIM.simPackageID = P.t_simPackageId
				GROUP BY clientId) tmp
			WHERE tmp.ClientId = t_clientId
		SELECT TOP 1 @maClientId = t_clientId, @isReqPackagesInstalled = 1
		FROM @maClientsTbl
LEFT JOIN DM2SearchServerCoreInfo S ON t_clientId = S.clientId AND S.cloudtype = 9
		WHERE t_allPackagesInstalled = 1 AND S.clientId IS NULL
	END
	--pick any empty Media agent which is not infrastructure client (CS, webconsole or webserver).
	IF ISNULL(@maClientId,0) = 0
	BEGIN
		UPDATE @maClientsTbl
		SET t_isInfrastructureClient = 1
		FROM simInstalledPackages S
WHERE S.ClientId = t_clientId AND  simPackageID IN (20,
252,
726,
1135,
1174,
1020)
		--pick any empty Media agent with missing packages.
		SELECT TOP 1 @maClientId = t_clientId
		FROM @maClientsTbl
LEFT JOIN DM2SearchServerCoreInfo S ON t_clientId = S.clientId AND S.cloudtype = 9
		WHERE S.clientId IS NULL
		ORDER BY t_isInfrastructureClient
	END
	--pick maclientId with cloud mode & VSA role
	IF ISNULL(@maClientId,0) = 0
	BEGIN
		--pick index server with input role
		 SELECT TOP 1 @maClientId = T.t_clientId, @indexServerClientId = C.pseudoClientId, @isRoleConfigured = 1, @indexServerCloudId = C.cloudId
		 FROM @maClientsTbl T
				JOIN DM2SearchServerCoreInfo S ON t_clientId = S.clientId
				JOIN DM2Cloud C ON C.cloudId = S.cloudId
				JOIN DM2CloudCoreRole R ON S.CloudId = R.cloudId
WHERE R.roleId = @roleId AND R.status = 1 AND S.cloudType = 5
	END
	--lastly, if could not found any mediaagent
	IF ISNULL(@maClientId,0) = 0
	BEGIN
		SET @errorCode = 12740 --NO_MEDIAAGENT_FOUND
SET @errorStr = (SELECT [Message] FROM EvLocaleMsgs  WHERE messageId = (4390 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
		GOTO proc_exit
	END
END
--output
proc_exit:
SET @o_xmlText =(SELECT
						@indexServerCloudId AS '@indexServerCloudId',
						@isRoleConfigured AS '@isRoleConfigured',
						@isReqPackagesInstalled AS '@isReqPackagesInstalled',
						(
							SELECT  @indexServerClientId AS '@clientId'
								FOR  XML PATH('indexServerClient'), TYPE
						),
						(
							SELECT  @maClientId AS '@clientId'
								FOR  XML PATH('mediaAgentInfo'), TYPE
						),
						(
							SELECT @errorCode  AS '@errorCode', @errorStr AS '@errorMessage'
								FOR    XML PATH('genericError'), TYPE
						)
				FOR XML PATH('App_AdvancedIndexingPreProcessResponseEx'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText =(SELECT
						(
							SELECT @errorCode  AS '@errorCode', @errorStr AS '@errorMessage'
								FOR    XML PATH('genericError'), TYPE
							)
						FOR XML PATH('App_AdvancedIndexingPreProcessResponseEx'),TYPE)
END CATCH
--output
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexServerForArchGroup')
	delete from GxQscripts where name = 'AppGetIndexServerForArchGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexServerForArchGroup')
	delete from GXDBVersions where aliasname = 'AppGetIndexServerForArchGroup'
GO

insert into GXDBVersions values(2, 'AppGetIndexServerForArchGroup',  '00010001000200090000', 'AppGetIndexServerForArchGroup', '00010001000200090000')
GO

