

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexPoolDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexPoolDetails.sp,v $ $Id: AppGetIndexPoolDetails.sp,v 1.1.2.5 2020/05/19 18:45:14 pankajkumar Exp $";
--     +-----------------------------------------------------------------------+
--     |                       PROCEDURE: "AppGetIndexPoolDetails"             |
--     +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexPoolDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexPoolDetails <<<'
	drop procedure AppGetIndexPoolDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexPoolDetails')
	delete from GxQscripts where name = 'AppGetIndexPoolDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexPoolDetails')
	delete from GXDBVersions where aliasname = 'AppGetIndexPoolDetails'
GO
print '... Creating Procedure: AppGetIndexPoolDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexPoolDetails
  @i_ClientId INT = 0,
  @i_includeOnlyConfigured INT = 0
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(512)
  DECLARE @o_hostName NVARCHAR(512)
  DECLARE @o_clientType INT
  DECLARE @o_isEnabled INT 
  DECLARE @o_jvmMax VARCHAR(32)
  DECLARE @o_PortNo VARCHAR(32)
  DECLARE @o_URL VARCHAR(255)
  DECLARE @o_isWebserver VARCHAR(32)
  DECLARE @o_clientDisplayName NVARCHAR(512)
DECLARE @solrCloudInfoTbl TABLE (t_clientId INT,
							t_clientName NVARCHAR(512),
							t_hostName NVARCHAR(512),
							t_clientType INT,
							t_isEnabled INT DEFAULT 0,
							t_jvmMax VARCHAR(32) DEFAULT '4096',
							t_PortNo VARCHAR(32) DEFAULT '0' ,
							t_URL VARCHAR(255) DEFAULT '',
							t_isWebserver VARCHAR(32) DEFAULT 'false',
							t_clientDisplayName NVARCHAR(512) DEFAULT ''
							)
BEGIN
	IF @i_includeOnlyConfigured > 0 AND @i_ClientId > 0
	BEGIN
		DECLARE @nodePropertiesXML TABLE (t_clientId INT , t_nodeProps XML)
		INSERT INTO @nodePropertiesXML (t_clientId, t_nodeProps)
		SELECT ClientId, NodeProps
		FROM  DM2SearchServerCoreInfo S (nolock)
		JOIN DM2Cloud DC (NOLOCK) ON dC.cloudId = S.cloudId
		WHERE  S.cloudType = 9 AND DC.pseudoClientId = @i_ClientId
		--get node properties
		DECLARE @nodeNameValueMap TABLE (t_clientId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @nodeNameValueMap
		SELECT t_clientId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
		FROM  @nodePropertiesXML N
			CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)
        INSERT INTO @solrCloudInfoTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_PortNo, t_jvmMax, t_isEnabled, t_clientType)
		SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, s.Portno, ISNULL(t_value,'4096'), 0, 1 --analytics
		FROM DM2Cloud DC (NOLOCK)
		JOIN DM2SearchServerCoreInfo S(NOLOCK) ON dC.cloudId = S.cloudId AND S.CloudType IN (9)
		JOIN APP_Client C (NOLOCK) ON S.ClientId = C.id
		LEFT JOIN @nodeNameValueMap M ON t_clientId = S.clientId AND t_name = 'JVMMAXMEMORY'
		WHERE DC.pseudoClientId = @i_ClientId
		 --is webserver package installed on node client
		UPDATE @solrCloudInfoTbl
		SET t_isWebserver = 'true'
		FROM simInstalledPackages P (nolock)
		INNER JOIN @solrCloudInfoTbl T ON  T.t_clientId = P.clientId
WHERE P.simPackageID IN (252, 263, 1156, 1174)
		AND t_clientType = 1
	END
	ELSE
	BEGIN
		--DO NOT INCLUDE existing analytics engine
        INSERT INTO @solrCloudInfoTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_clientType)
        SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, 1 --analytics
		FROM APP_CLIENT C (NOLOCK)
		JOIN simInstalledPackages P (NOLOCK) ON C.id = P.ClientId
		LEFT JOIN DM2SearchServerCoreInfo S(NOLOCK) ON P.ClientId = S.clientId AND S.CloudType IN (1,4,5,9)
WHERE P.simPackageID IN ( 55, 1306) AND S.clientId IS NULL
		--port no should be same as instance no
		UPDATE @solrCloudInfoTbl
		SET t_PortNo = (CASE WHEN  attrVal = 'Instance001' THEN '20000' ELSE ('2000'+ SUBSTRING (attrVal, LEN(ATTRVAL), LEN(ATTRVAL))) END)
		FROM APP_ClientProp CP (NOLOCK)
		INNER JOIN @solrCloudInfoTbl T ON  T.t_clientId = CP.componentNameId AND attrName = 'Galaxy Instance name'
		WHERE t_PortNo = '0'
		 --zookeeper cloud
        INSERT INTO @solrCloudInfoTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_clientType)
        SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, 2 --zookeeper
		FROM APP_Client C (NOLOCK)
		INNER JOIN APP_ClientProp CP (NOLOCK) ON   c.id = cp.componentnameId
		WHERE  cp.attrname = 'Index Server Type' AND cp.attrval = '12' AND cp.modified =0
	END
END
--OUTPUT
SELECT * FROM @solrCloudInfoTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexPoolDetails')
	delete from GxQscripts where name = 'AppGetIndexPoolDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexPoolDetails')
	delete from GXDBVersions where aliasname = 'AppGetIndexPoolDetails'
GO

insert into GXDBVersions values(2, 'AppGetIndexPoolDetails',  '00010001000200050000', 'AppGetIndexPoolDetails', '00010001000200050000')
GO

