

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexDetails.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexDetails.sp,v $ $Id: AppGetIndexDetails.sp,v 1.1.2.13 2018/12/17 23:07:59 mmohan Exp $";
-- =========================================================
-- Author: Ganesh Kumar Subramanian
-- Description: Get the index details for the given client/job
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIndexDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexDetails <<<'
	drop procedure AppGetIndexDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexDetails')
	delete from GxQscripts where name = 'AppGetIndexDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexDetails')
	delete from GXDBVersions where aliasname = 'AppGetIndexDetails'
GO
print '... Creating Procedure: AppGetIndexDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIndexDetails
  @xmlText XML
AS
  DECLARE @response XML
--
SET NOCOUNT ON;
--
BEGIN TRY
	--
	DECLARE @tempV2Set TABLE (backupSet int, applicationId int, clientId int, commCellId int);
	DECLARE @tempV1Set TABLE (returnOrder int, id INT, commCellId INT, appId INT,archGroupId INT, fileType INT, cTime INT, jobId INT, maId int, maVersion varchar(4), idxCacheSoftState int, archFileFlag int, isRunningjob int, isAged int, VMGUID VARCHAR(2048));
	--
	DECLARE @inputJobId int = (SELECT TOP(1) @xmlText.value('(/Indexing_GetIndexDetailsReq/@jobId)[1]', 'int'));
	DECLARE @inputClientId int = (SELECT TOP(1) @xmlText.value('(/Indexing_GetIndexDetailsReq/@clientId)[1]', 'int'));
	--
	IF OBJECT_ID('tempdb.dbo.#tempResSet') IS NOT NULL DROP TABLE #tempResSet
	CREATE TABLE #tempResSet (returnOrder int, id INT, commCellId INT, appId INT,archGroupId INT, fileType INT, cTime INT, jobId INT, maId int, maVersion varchar(4), idxCacheSoftState int, archFileFlag int, isRunningjob int, isAged int, VMGUID VARCHAR(2048));
	IF @inputJobId IS NOT NULL
	BEGIN
		INSERT INTO @tempV2Set
		SELECT DISTINCT A.backupSet AS '@backupSet', A.appTypeId AS '@applicationId', A.clientId AS '@clientId', J.commCellId AS '@commCellId'
		FROM JMBkpStats J WITH (NOLOCK)
		INNER JOIN APP_Application A WITH (NOLOCK) ON J.appId = A.id
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON A.clientId = CP.componentNameId
		INNER JOIN App_IndexDBInfo DBI WITH (NOLOCK) ON A.backupSet = DBI.backupSetId
		WHERE CP.attrName = dbo.GetIndexingV2PropNameByAppType(A.appTypeId) AND CP.attrVal = '1' AND CP.modified = 0 -- indexing-v2 should be enabled on the backup client
		AND J.servStartDate >= CP.created AND J.jobId = @inputJobId;
		IF NOT EXISTS (select top 1 1 from @tempV2Set)
		BEGIN
			DECLARE @inputParamXml VARCHAR(1024) = '<InputParam><JobList><Job id="'+CAST(@inputJobId as VARCHAR)+'" commcellId="2"/></JobList></InputParam>'
			EXEC ArchFileByTimeSuperBrowse 0, 0, 0, 0, 0, 2147483647, 0, 1, 0, 0, @inputParamXml;
			INSERT INTO @tempV1Set SELECT * FROM #tempResSet;
		END
	END
	ELSE IF @inputClientId IS NOT NULL
	BEGIN
		EXEC ArchFileByTimeSuperBrowse 0, @inputClientId, 0, 0, 0, 2147483647, 0, 1, 0, 0, '';
		INSERT INTO @tempV2Set SELECT DISTINCT A.backupSet AS '@backupSet', A.appTypeId AS '@applicationId', A.clientId AS '@clientId', TS.commCellId AS '@commCellId' FROM #tempResSet TS
		INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = TS.appId
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = @inputClientId
		INNER JOIN App_IndexDBInfo DBI WITH (NOLOCK) ON DBI.backupSetId = A.backupSet
		WHERE TS.cTime >= CP.created AND CP.attrName = dbo.GetIndexingV2PropNameByAppType(A.appTypeId) AND CP.attrVal = '1' AND CP.modified = 0 ;
		INSERT INTO @tempV1Set SELECT DISTINCT TS.* FROM #tempResSet TS
		INNER JOIN APP_Application A WITH (NOLOCK) ON TS.appId = A.id
		WHERE A.backupSet NOT IN (SELECT T.backupSet FROM @tempV2Set T);
	END
	ELSE
		RAISERROR('Error fetching the client/job information.', 16, 1);
	--
	IF OBJECT_ID('tempdb.dbo.#tempResSet') IS NOT NULL DROP TABLE #tempResSet
	-- return the xml response
	IF EXISTS (SELECT TOP 1 1 FROM @tempV1Set) AND EXISTS (SELECT TOP 1 1 FROM @tempV2Set)
	BEGIN
		SET @xmlText= (SELECT (SELECT TOP 1 TS.clientId from @tempV2Set TS) AS '@clientId',
			(SELECT (
				SELECT TR1.id as '@afileId',TR1.returnOrder as '@returnOrder', TR1.commCellId as '@commCellId', TR1.appId as '@appId', TR1.archGroupId as '@archGroupId',TR1.fileType as '@fileType',TR1.cTime as '@cTime',TR1.jobId as '@jobId',TR1.maId as '@maId' ,TR1.maVersion as '@maVersion',TR1.idxCacheSoftState as '@idxCacheSoftState' FROM @tempV1Set TR1
				FOR XML PATH ('subClient'),TYPE)
			FOR XML PATH ('IndexingV1'),TYPE) ,
			(SELECT (
				SELECT TR2.backupSet AS '@backupsetId',TR2.applicationId AS '@applicationId', TR2.commCellId as '@commCellId'
				FROM @tempV2Set TR2 FOR XML PATH ('backupSet'),TYPE)
			FOR XML PATH ('IndexingV2'),TYPE)
		FOR XML PATH ('GetIndexDetails'),TYPE);
	END
	ELSE IF EXISTS (SELECT TOP 1 1 FROM @tempV1Set) OR EXISTS (SELECT TOP 1 1 FROM @tempV2Set)
	BEGIN
		IF EXISTS (SELECT TOP 1 1 FROM @tempV1Set)
		SET @xmlText= (SELECT (SELECT TOP 1 TS.clientId from @tempV2Set TS) AS '@clientId',
			(SELECT (
				SELECT TR1.id as '@afileId',TR1.returnOrder as '@returnOrder', TR1.commCellId as '@commCellId', TR1.appId as '@appId', TR1.archGroupId as '@archGroupId',TR1.fileType as '@fileType',TR1.cTime as '@cTime',TR1.jobId as '@jobId',TR1.maId as '@maId' ,TR1.maVersion as '@maVersion',TR1.idxCacheSoftState as '@idxCacheSoftState' FROM @tempV1Set TR1
				FOR XML PATH ('subClient'),TYPE)
			FOR XML PATH ('IndexingV1'),TYPE)
		FOR XML PATH ('GetIndexDetails'),TYPE);
		IF EXISTS (SELECT TOP 1 1 FROM @tempV2Set)
		SET @xmlText= (SELECT (SELECT TOP 1 TS.clientId from @tempV2Set TS) AS '@clientId',
			(SELECT (
				SELECT TR2.backupSet AS '@backupsetId',TR2.applicationId AS '@applicationId', TR2.commCellId as '@commCellId'
				FROM @tempV2Set TR2 FOR XML PATH ('backupSet'),TYPE)
			FOR XML PATH ('IndexingV2'),TYPE)
		FOR XML PATH ('GetIndexDetails'),TYPE);
	END
	ELSE
		RAISERROR('No Qualified Index is present.', 16, 1);
	--
	SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexDetails')
	delete from GxQscripts where name = 'AppGetIndexDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexDetails')
	delete from GXDBVersions where aliasname = 'AppGetIndexDetails'
GO

insert into GXDBVersions values(2, 'AppGetIndexDetails',  '00010001000200130000', 'AppGetIndexDetails', '00010001000200130000')
GO

