

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexDBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--   [AppGetIndexDBInfo   - Add content in the AppGetIndexDBInfo
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIndexDBInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexDBInfo <<<'
	drop procedure AppGetIndexDBInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexDBInfo')
	delete from GxQscripts where name = 'AppGetIndexDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexDBInfo')
	delete from GXDBVersions where aliasname = 'AppGetIndexDBInfo'
GO
print '... Creating Procedure: AppGetIndexDBInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIndexDBInfo
  @inXML xml
AS
  DECLARE @outXML xml
SET NOCOUNT OFF
declare @presentCSTime int = dbo.GetUnixTime(GetUTCDate())
--tables
CREATE TABLE #TempBackupSetTable (dbName varchar(128), backupSetGUID uniqueidentifier, currentIdxServerName varchar(max), dbEngineType int, subclientInfoXml xml, skipConsistencyCheck INT, committedTransactionId INT,
MaServicePack INT, copyTransactionFromBackupset INT, lastValidCheckpointTimeForDb INT)
CREATE TABLE #TempSubclientTable (appGUID varchar(128), appId int, backupSetGUID varchar(128), PRIMARY KEY (appGUID))
CREATE TABLE #TempDataAgingDisabledClients (clientId int, PRIMARY KEY (clientId))
--xml
DECLARE @subclientsOutXML XML,
		@tempSPExecOutXml XML,
		@tempSPExecInXml XML
--temp variables
DECLARE @backupSetGUID varchar(128),
		@dbName varchar(128),
		@l_cursor_AppId INT = 0,
		@l_cursor_AppGUID varchar(128),
		@l_cursor_BackupSetGUID varchar(128),
@numSecsBeforeHonouringRetentionRoutine INT = ISNULL((select 86400*value from GXGlobalParam where name = 'NumDaysBeforeHonouringRetentionRoutine'), 172800) --2 days in secs
--input xml attributes
DECLARE @inDbName nvarchar(max) = @inXML.value('(/App_GetIndexDBInfo/indexDbInfoList/@dbName)[1]', 'nvarchar(max)')
DECLARE @inBackupSetGUID nvarchar(max) = @inXML.value('(/App_GetIndexDBInfo/indexDbInfoList/@backupSetGUID)[1]', 'nvarchar(max)')
DECLARE @inCurrentIdxServerName nvarchar(max) = @inXML.value('(/App_GetIndexDBInfo/indexDbInfoList/@currentIdxServer)[1]', 'nvarchar(max)')
DECLARE @inFetchRetentionDetails int = @inXML.value('(/App_GetIndexDBInfo/@fetchRetentionDetails)[1]','integer')
--argument error check
IF ((@inDbName='' or @inDbName is null) and (@inBackupSetGUID='' or @inBackupSetGUID is null) and (@inCurrentIdxServerName is null or @inCurrentIdxServerName=''))
BEGIN
	GOTO CX_EXIT
END
--create TempBackupSetTable table based on arguments
IF ((@inBackupSetGUID='' or @inBackupSetGUID is null) and (@inCurrentIdxServerName is not null))
BEGIN
	DECLARE @clientID INT = 0
	DECLARE @currentIdxServerName varchar(max) = ''
	SELECT @clientID = CL.id, @currentIdxServerName = CL.name FROM App_Client CL WHERE CL.name = @inCurrentIdxServerName
	--if input arguments : backupsetGUID is absent and currentIdxServer is present, add all backupsets for that current index server to temp table
	INSERT INTO #TempBackupSetTable (dbName , backupSetGUID, currentIdxServerName, dbEngineType, MaServicePack, lastValidCheckpointTimeForDb)
	SELECT dbName, backupSetGUID, @currentIdxServerName, IDB.idxDbEngineType, 0,
	MAX(CASE WHEN AF.cTime IS NOT NULL AND AFC.archFileId IS NOT NULL THEN AF.cTime ELSE 0 END)
	FROM App_IndexDBInfo AS IDB
	LEFT JOIN archFile AF WITH(NOLOCK) ON AF.name = 'IdxCheckPoint_' + CAST(IDB.backupSetGUID AS NVARCHAR(36)) + ':' + CAST(IDB.dbName AS NVARCHAR(36))
	AND AF.cs_afname = CHECKSUM('IdxCheckPoint_' + CAST(IDB.backupSetGUID AS NVARCHAR(36)) + ':' + CAST(IDB.dbName AS NVARCHAR(36))) AND AF.isValid = 1
	LEFT JOIN archFileCopy AFC WITH(NOLOCK) ON AFC.archFileId = AF.id AND AFC.isValid = 1 AND (AFC.flags & 256) = 0
	GROUP BY dbName, backupSetGUID, IDB.idxDbEngineType
	DECLARE @highestSP INT = ISNULL((select max(HighestSP) from simInstalledPackages WITH(NOLOCK) where ClientId = @clientID),0)
	--Check for clustered client
	IF @highestSP = 0
	BEGIN
		SELECT @highestSP = MAX(SIM.HighestSP) from simInstalledPackages SIM WITH(NOLOCK)
		JOIN APP_VMToPMMap VMTOPM WITH(NOLOCK) ON VMTOPM.PMClientId = SIM.ClientId
		JOIN APP_ClientProp Prop WITH(NOLOCK) ON attrName = 'Virtual Client' and attrVal = '1' and componentnameid = VMTOPM.VMClientId
		WHERE VMTOPM.VMClientId = @clientID
	END
	--If service pack is still 0. we should not preform index backup and check root cause.
	IF @highestSP = 0
	BEGIN
		DELETE FROM #TempBackupSetTable
		GOTO CX_EXIT
	END
	UPDATE tmp SET MaServicePack = @highestSP
	FROM #TempBackupSetTable tmp
	--Set transactionId = backupset transactionId by default
	Update tmp SET tmp.committedTransactionId = T.committedTransactionId
	FROM #TempBackupSetTable tmp
	JOIN (SELECT info.backupSetGUID, info.idxDbEngineType, info.committedTransactionId FROM
	App_IndexDBInfo info WITH(NOLOCK), #TempBackupSetTable tmp1 WHERE info.backupSetGUID = tmp1.dbname AND info.idxDbEngineType = tmp1.dbEngineType) T on T.backupSetGUID = tmp.backupsetguid AND T.idxDbEngineType = tmp.dbEngineType
	--Adjust transactionId of subclient Index
	Update tmp
	SET committedTransactionId = CASE
									  WHEN MaServicePack >= 22
									  THEN
CASE WHEN flags & 4 = 0 THEN 0 ELSE info.committedTransactionId END
									  ELSE
										tmp.committedTransactionId
								 END
	FROM #TempBackupSetTable tmp
	JOIN App_IndexDBInfo info WITH(NOLOCK)ON info.backupSetGUID = tmp.backupsetGUID AND info.dbName = tmp.dbName AND info.idxDbEngineType = tmp.dbEngineType
	WHERE info.backupSetGUID <> info.dbName
END
ELSE
BEGIN
	--if input arguments : one or more backupsetGUIDs are present and currentIdxServer is absent, add all backupsets to temp table
    INSERT INTO #TempBackupSetTable (dbName , backupSetGUID, currentIdxServerName, dbEngineType, copyTransactionFromBackupset, lastValidCheckpointTimeForDb)
    SELECT req.value('@dbName','varchar(128)'), req.value('@backupSetGUID','uniqueidentifier'), req.value('@currentIdxServer','varchar(max)'), 1, 0, 0
    FROM @inXML.nodes('App_GetIndexDBInfo/indexDbInfoList') AS T(req)
	--update backupset index transactionId
	UPDATE tmp SET tmp.committedTransactionId = info.committedTransactionId
	FROM #TempBackupSetTable tmp
	JOIN App_IndexDBInfo info WITH(NOLOCK) ON info.backupSetGUID = tmp.backupsetGUID AND info.dbName = tmp.backupsetGUID AND info.idxDbEngineType = tmp.dbEngineType
	--Before SP22 MA sends only backupsetGUID:backupsetGUID.
	--Starting SP22 we get backupSetGUID:subclientGuid
	IF EXISTS(SELECT 1 FROM #TempBackupSetTable WHERE backupsetGUID <> dbName)
	BEGIN
		Update tmp
SET committedTransactionId = CASE WHEN flags & 4 > 0 THEN info.committedTransactionId ELSE tmp.committedTransactionId END,
copyTransactionFromBackupset = CASE WHEN flags & 4 = 0 THEN 1 ELSE 0 END
		FROM #TempBackupSetTable tmp
		JOIN App_IndexDBInfo info WITH(NOLOCK)ON info.backupSetGUID = tmp.backupsetGUID AND info.dbName = tmp.dbName AND info.idxDbEngineType = tmp.dbEngineType
		WHERE info.backupSetGUID <> info.dbName
	END
END
-- If data aging is disabled at Commserve level, disable fetching retention routine settings.
IF dbo.JMIsOpTypeEnabled(10 /* Data Aging */, 1 /* COMMCELL_ENTITY */, default, default) = 0 -- commcell level
BEGIN
SET @inFetchRetentionDetails = 0
END
DECLARE @dbNameList NVARCHAR(MAX) = ''
SELECT @dbNameList = ISNULL(value,'') FROM GXGlobalParam WITH (NOLOCK) WHERE name='IDX_SKIP_CONSISTENCY_CHECK' and modified=0
IF LEN(@dbNameList) > 0
BEGIN
	IF @dbNameList = '*'
	BEGIN
		UPDATE #TempBackupSetTable SET skipConsistencyCheck = 1
	END
	ELSE
	BEGIN
		UPDATE #TempBackupSetTable SET skipConsistencyCheck = 1
		FROM dbo.SplitString(@dbNameList,';') T
		WHERE T.Data = #TempBackupSetTable.dbName
	END
END
ELSE
	UPDATE #TempBackupSetTable SET skipConsistencyCheck = 0
--skip retention details fetching if not needed
IF @inFetchRetentionDetails = 0
BEGIN
GOTO CX_CREATE_XML
END
--------------------------------------------------
------BEGIN FETCH RETENTION DETAILS---------------
--------------------------------------------------
--List all data aging disabled clients into the Exclude list
INSERT INTO #TempDataAgingDisabledClients
SELECT clientId FROM JMJobAction
WHERE opType = 10 -- Data Aging
AND clientId != 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0  -- Commcell level
AND action = 1 -- Disabled
UNION
SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId IN(
SELECT clientGroupId
FROM JMJobAction
WHERE opType = 10 -- Data Aging
AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId != 0  -- Commcell level
AND action = 1 -- Disabled
)
-- fetch retention parameters only for valid subclients belonging to backupsets in TempBackupSetTable
-- filterSubclientStatus = ((CV_STATUS_DELETED) | (CV_STATUS_DUMMY) | (CV_STATUS_HIDDEN) | (CV_STATUS_EDC_DISCOVERED) | (CV_STATUS_NEEDS_MORE_CONFIG) | (CV_STATUS_MINING) | (CV_STATUS_DUMMY_FOR_FIREWALL_SETUP) | (CV_STATUS_REFCOPY_SUB) )
-- (0x00004 | 0x00010 | 0x00020 | 0x800000 | 0x08000 | 0x80000 | 0x100000 | 0x10000 )
-- order by backupsetguid during insert doesnt guarantee order of insertion
DECLARE @filterSubclientStatus INT = 0x189834
INSERT INTO #TempSubclientTable
SELECT DISTINCT APPL.GUID as appGUID, APPL.id as appId, BACKUPSET.GUID as backupSetGUID from APP_Application APPL WITH (NOLOCK)
INNER JOIN APP_BackupSetName BACKUPSET WITH (NOLOCK) ON (APPL.backupSet = BACKUPSET.id)
INNER JOIN #TempBackupSetTable INPUTBACKUPSETS ON INPUTBACKUPSETS.backupSetGUID = BACKUPSET.GUID
INNER JOIN App_Client APPCLIENT WITH (NOLOCK) ON APPCLIENT.id = APPL.clientId
WHERE
(subclientStatus & @filterSubclientStatus) = 0    -- exclude dummy subclients
AND (ISNULL((SELECT MAX(attrVal) from APP_SubClientProp WITH (NOLOCK) where componentNameId = APPL.id and attrName in ('Index SubClient','DDB Backup','Enable Snap Backups','Use block level backup','First Turbo Job Id') and modified=0),0)=0) -- exclude ddbbackup and indexbackup. Archiver, SNAP and block level subclients are still not supported
AND appTypeId in (SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(22,0) --APPGRP_W2KFileSystem
                  UNION
                  SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(34,0) --APPGRP_UnixFileSystem
                 )
AND APPL.clientId NOT IN (select clientId from #TempDataAgingDisabledClients) --Exclude data aging disabled clients
AND (APPCLIENT.status & 4096) = 4096  --Include only laptop clients
AND EXISTS (select 1 from archFile WITH (NOLOCK) where isValid=1 AND APPL.id = appId) --atleast one valid archive file for the subclient is present
DECLARE AppIdCursor CURSOR FOR
SELECT appGUID, appId, backupSetGUID FROM #TempSubclientTable ORDER BY backupSetGUID
--iterate through subclients
DECLARE @prevBackupSetGUID varchar(128)=N''
SET @subclientsOutXML = NULL
OPEN AppIdCursor
FETCH NEXT FROM AppIdCursor INTO @l_cursor_AppGUID, @l_cursor_AppId, @l_cursor_BackupSetGUID
WHILE @@FETCH_STATUS = 0
BEGIN
	--inputs to SP
	SET @tempSPExecInXml = (SELECT @l_cursor_AppId as '@appId', @l_cursor_AppGUID as '@appGUID', 1 as '@isIndexingV2', @presentCSTime as '@jobStartTime', 1 as '@calledFromSP'
	FOR XML PATH('App_GetSubClientRetentionPropsReq') , TYPE)
	--get output from SP as XML
	--AppGetSubClientRetentionProps SP is called from cpp as well, so output parameter can't be introduced.
	--creating a temp table to store xml output from AppGetSubClientRetentionProps is not possible since CPP code callee for AppGetIndexDBInfo errors out with "An INSERT EXEC statement cannot be nested."
	EXEC [dbo].[AppGetSubClientRetentionProps] @inXML = @tempSPExecInXml,
	@outXML = @tempSPExecOutXml OUTPUT
	IF (@prevBackupSetGUID!=N'' AND @l_cursor_BackupSetGUID!=@prevBackupSetGUID)
	BEGIN
		--If this is a new backupset, update the subclientsOutXML for previous backupset to the temptable and set subclientsOutXML to empty for current backupset
		Update #TempBackupSetTable SET subclientInfoXml=@subclientsOutXML where backupSetGUID=CONVERT(uniqueidentifier,@prevBackupSetGUID) and dbName=@prevBackupSetGUID
		SET @subclientsOutXML = NULL
	END
	--disqualify subclient retention setting to be sent to retention routine if it is changed in last 7 days
	IF @presentCSTime - @tempSPExecOutXml.value('(/subclientInfoList/@lastRetentionSettingChangeTime)[1]', 'nvarchar(max)') > @numSecsBeforeHonouringRetentionRoutine
	BEGIN
		--append to the subclientsOutXML list for the same backupset
		SET @subclientsOutXML = (SELECT @subclientsOutXML, @tempSPExecOutXml FOR XML PATH(''))
	END
	SET @prevBackupSetGUID = @l_cursor_BackupSetGUID
	FETCH NEXT FROM AppIdCursor INTO @l_cursor_AppGUID, @l_cursor_AppId, @l_cursor_BackupSetGUID
END
CLOSE AppIdCursor
DEALLOCATE AppIdCursor
IF (@prevBackupSetGUID!=N'')
BEGIN
	--update the subclientsOutXML for previous backupset if this is a new backupset
	Update #TempBackupSetTable SET subclientInfoXml=@subclientsOutXML where backupSetGUID=CONVERT(uniqueidentifier,@prevBackupSetGUID) and dbName=@prevBackupSetGUID
END
--------------------------------------------------
--------END FETCH RETENTION DETAILS---------------
--------------------------------------------------
--create xml from join of three tables
CX_CREATE_XML:
SET @outXML = (SELECT @presentCSTime as 'presentCSTime', (SELECT INDEXDB.dbname AS 'indexDbInfoList/dbName', INDEXDB.backupSetGUID as 'indexDbInfoList/backupSetGUID',
BACKUPSET.currentIdxServerName as 'indexDbInfoList/currentIdxServer', BACKUPSET.committedTransactionId as 'indexDbInfoList/committedTransactionId',
INDEXDB.type as 'indexDbInfoList/dbType', INDEXDB.idxDbEngineType as 'indexDbInfoList/idxServerType', ISNULL(BACKUPSET.skipConsistencyCheck,0) as 'indexDbInfoList/skipConsistencyCheck', BACKUPSET.subclientInfoXml as 'indexDbInfoList',
BACKUPSET.copyTransactionFromBackupset as 'indexDbInfoList/copyTransactionFromBackupset', dbo.isSubClientIndexEnabled(INDEXDB.backupSetId) as 'indexDbInfoList/isSubclientIndex',
BACKUPSET.lastValidCheckpointTimeForDb AS 'indexDbInfoList/lastValidCheckpointTimeForDb'
FROM App_IndexDBInfo AS INDEXDB WITH(NOLOCK)
INNER JOIN #TempBackupSetTable BACKUPSET ON (INDEXDB.backupSetGUID = BACKUPSET.backupsetGUID AND INDEXDB.dbName = BACKUPSET.dbName AND INDEXDB.idxDbEngineType = BACKUPSET.dbEngineType)
FOR XML PATH(''), TYPE) for xml path(''), ROOT('App_GetIndexDBInfo'))
CX_EXIT:
SELECT @outXML
--drop temp tables
IF OBJECT_ID('tempdb.dbo.#TempBackupSetTable', 'U') IS NOT NULL
DROP TABLE #TempBackupSetTable;
IF OBJECT_ID('tempdb.dbo.#TempSubclientTable', 'U') IS NOT NULL
DROP TABLE #TempSubclientTable;
IF OBJECT_ID('tempdb.dbo.#TempDataAgingDisabledClients', 'U') IS NOT NULL
DROP TABLE #TempDataAgingDisabledClients;
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexDBInfo')
	delete from GxQscripts where name = 'AppGetIndexDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexDBInfo')
	delete from GXDBVersions where aliasname = 'AppGetIndexDBInfo'
GO

insert into GXDBVersions values(2, 'AppGetIndexDBInfo',  '00000000000000000000', 'AppGetIndexDBInfo', '00000000000000000000')
GO

