

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIndexCheckpointForGivenTimeRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   04/24/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetIndexCheckpointForGivenTimeRange.sp,v $ $Id: AppGetIndexCheckpointForGivenTimeRange.sp,v 1.1.2.3 2020/12/28 19:43:07 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIndexCheckpointForGivenTimeRange')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIndexCheckpointForGivenTimeRange <<<'
	drop procedure AppGetIndexCheckpointForGivenTimeRange
END
IF EXISTS (select * from GxQscripts where name='AppGetIndexCheckpointForGivenTimeRange')
	delete from GxQscripts where name = 'AppGetIndexCheckpointForGivenTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexCheckpointForGivenTimeRange')
	delete from GXDBVersions where aliasname = 'AppGetIndexCheckpointForGivenTimeRange'
GO
print '... Creating Procedure: AppGetIndexCheckpointForGivenTimeRange'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIndexCheckpointForGivenTimeRange
  @i_xml XML
AS
  DECLARE @outXML xml
IF object_id('tempdb.dbo.#appidCycleRange') is not null
	DROP TABLE #appidCycleRange
CREATE TABLE #appidCycleRange (appId INT, commcellId INT, startTime INT, endTime INT, fullcycleNum INT, dbName NVARCHAR(36), cycleSTartTime INT, cycleEndTime INT)
IF object_id('tempdb.dbo.#checkpointInfo') is not null
	DROP TABLE #checkpointInfo
CREATE TABLE #checkpointInfo (appId INT, dbName NVARCHAR(36), commcellId INT, checkpointStartTime INT, checkpointEndTime INT, afileId INT, minIdxAfCtime INT, latestIdxAfCtime INT)
INSERT INTO #appidCycleRange
SELECT N.value(N'@appId', N'INT') as appId, N.value(N'@commcellId', N'INT') as commcellId
, N.value(N'@startTime', N'INT') as startTime, N.value(N'@endTime', N'INT') as endTime,  N.value(N'@fullcycleNum', N'INT') as endTime, '', 0 , 0
FROM @i_xml.nodes (N'databrowse_TimeRangeForEachCycleList/cycleRange') AS T(N)
UPDATE tmp SET tmp.cycleSTartTime = T.CycleStartTime,
tmp.cycleEndTime = T.CycleEndTime
FROM #appidCycleRange tmp JOIN
(select tmp1.appId, tmp1.fullcycleNum, MIN(B.servStartDate) CycleStartTime, MAX(B.servEndDate) CycleEndTime
from #appidCycleRange tmp1
join JMBkpStats B WITH (NOLOCK) on tmp1.appId = B.appId and tmp1.fullcycleNum = B.fullCycleNum
WHERE B.status in (1,3,14)
GROUP BY tmp1.appId, tmp1.fullcycleNum) T
on tmp.appId = T.appId AND tmp.fullcycleNum = T.fullcycleNum
UPDATE #appidCycleRange
SET dbName = GUID
FROM App_Application WITH (NOLOCK) WHERE appId = Id
INSERT INTO #checkpointInfo
SELECT DISTINCT temp.appId, temp.dbName, temp.commcellId, CASE WHEN info.startTime IS NULL THEN temp.cycleSTartTime ELSE info.startTime END,
CASE WHEN info.endTime IS NULL THEN temp.cycleEndTime ELSE info.endTime END, MAX(ISNULL(info.afileId,0)), temp.startTime, temp.endTime
FROM #appidCycleRange temp
LEFT JOIN App_IndexCheckpointInfo info WITH (NOLOCK) ON temp.dbName = info.dbName AND temp.commcellId = info.commcellId
AND temp.cycleSTartTime >= info.startTime AND temp.cycleEndTime <= info.endTime AND info.flags&1 > 0
LEFT JOIN Archfile AF WITH (NOLOCK) ON AF.id = info.afileId AND AF.isValid = 1
GROUP BY temp.appId, temp.commcellId, temp.dbName, info.startTime, temp.startTime, info.endTime, temp.endTime, temp.cycleSTartTime, temp.cycleEndTime
SET @outXML =
(
SELECT (
	SELECT A.appId as '@appId', (
			SELECT dbName as '@appGuid', appId as '@appId', commcellId as '@commcellId',
			checkpointStartTime as '@checkpointStartTime', checkpointEndTime as '@checkpointEndTime', afileId as '@afileId',
			MAX(latestIdxAfCtime) as '@latestIdxAfCtime', MIN(minIdxAfCtime) as '@minIdxAfCtime'
			FROM #checkpointInfo B
			WHERE B.appId = A.appId
			GROUP by appid,dbName,commcellId,checkpointStartTime,checkpointEndTime,afileId
			FOR XML PATH('checkPointInfoPerCycle'), TYPE
		) FROM #appidCycleRange A group by appId
		FOR XML PATH('subclientInfos'), TYPE
	)
	FOR XML PATH('IndexDBInfo')
)
SELECT @outXML
IF object_id('tempdb.dbo.#appidCycleRange') is not null
	DROP TABLE #appidCycleRange
IF object_id('tempdb.dbo.#checkpointInfo') is not null
	DROP TABLE #checkpointInfo
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetIndexCheckpointForGivenTimeRange')
	delete from GxQscripts where name = 'AppGetIndexCheckpointForGivenTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIndexCheckpointForGivenTimeRange')
	delete from GXDBVersions where aliasname = 'AppGetIndexCheckpointForGivenTimeRange'
GO

insert into GXDBVersions values(2, 'AppGetIndexCheckpointForGivenTimeRange',  '00010001000200030000', 'AppGetIndexCheckpointForGivenTimeRange', '00010001000200030000')
GO

