

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIdxRetentionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =================================================================================
-- Author:		Saurabh Rajani
-- Description:	Get the retention information for given IndexServer and AppType
-- =================================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetIdxRetentionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIdxRetentionInfo <<<'
	drop procedure AppGetIdxRetentionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetIdxRetentionInfo')
	delete from GxQscripts where name = 'AppGetIdxRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetIdxRetentionInfo'
GO
print '... Creating Procedure: AppGetIdxRetentionInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetIdxRetentionInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXML XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @inIndexServerId INT
DECLARE @inAppType INT
DECLARE @inassocId INT
DECLARE @count INT
DECLARE @insubclientid INT
DECLARE @hasMore INT = 0
DECLARE @maxAssocId INT = 0
IF OBJECT_ID('tempdb.dbo.#tempObjToRetentionPolicy') IS NOT NULL     DROP TABLE #tempObjToRetentionPolicy
CREATE TABLE #tempObjToRetentionPolicy(objectGUID VARCHAR(40), subclientID INT, policyId INT, assocId INT)
SET @inAppType			= ISNULL( (SELECT ref.value('@appType', 'int') FROM @inXML.nodes('App_IdxRetentionReq') R(ref)), 0)
SET @inIndexServerId	= ISNULL( (SELECT ref.value('@indexServerClientId', 'int') FROM @inXML.nodes('App_IdxRetentionReq') R(ref)), 0)
SET @inassocId			= ISNULL( (SELECT ref.value('@lastAssocId', 'int') FROM @inXML.nodes('App_IdxRetentionReq') R(ref)), 0)
SET @count				= ISNULL( (SELECT ref.value('@count', 'int') FROM @inXML.nodes('App_IdxRetentionReq') R(ref)), 0)
SET @insubclientid		= ISNULL( (SELECT ref.value('@subclientId', 'int') FROM @inXML.nodes('App_IdxRetentionReq') R(ref)), 0)
-- Check if data aging is disabled at CC level. If yes, just return empty response
IF dbo.JMIsOpTypeEnabled(10 /* Data Aging */, 1 /* COMMCELL_ENTITY */, default, default) = 0 -- commcell level
BEGIN
	GOTO PROC_END
END
IF @inIndexServerId > 0 AND @inAppType > 0
BEGIN
IF @inAppType = 78
	BEGIN
		INSERT INTO #tempObjToRetentionPolicy
		SELECT CAP.userGUID, CAP.subClientId, PLANPROP.attrVal,CAP.userAssocId
		FROM APP_CloudAppUserDetails CAP WITH(NOLOCK) JOIN App_PlanProp PLANPROP WITH(NOLOCK) ON CAP.planId = PLANPROP.componentNameId AND PLANPROP.attrName='Office 365 retention policy'
		WHERE CAP.modified = 0 AND PLANPROP.modified = 0
		GROUP BY CAP.userGUID,CAP.subClientId, PLANPROP.attrVal,CAP.userAssocId
		SET @o_xmlText = (
							SELECT
							(
								SELECT
								SC.subclientID AS '@subclientId',
7 as '@_type_'
								FOR XML PATH ('subclient'), TYPE
							),
							(
								SELECT
									(
										SELECT  CPD.policyDetails AS 'policy'
										FROM APP_ConfigurationPolicyDetails CPD WITH(NOLOCK) WHERE CPD.componentNameId = PD.policyID AND CPD.modified=0
										FOR XML PATH(''), TYPE
									),
									(
										SELECT TMP.objectGUID AS '@objectGUID' FROM #tempObjToRetentionPolicy TMP
										WHERE TMP.policyId = PD.policyID AND TMP.subclientId = SC.subClientId
										FOR XML PATH('spObjects'), TYPE
									)
								FROM
								(
									SELECT DISTINCT policyID AS policyID
									FROM #tempObjToRetentionPolicy TMP WHERE TMP.subClientId = SC.subClientId
								) PD
								FOR XML PATH('spSiteRetentionInfo'), TYPE
							)
						FROM
						(
							SELECT DISTINCT(subclientID) FROM APP_CloudAppUserDetails WITH(NOLOCK) WHERE subclientId
							IN
							(
								SELECT APP.id FROM App_IndexDbInfo IDX  WITH(NOLOCK) JOIN APP_Application APP WITH(NOLOCK)
								ON IDX.backupSetId = APP.backupSet AND IDX.currentIdxServer = @inIndexServerId AND IDX.type = @inAppType
							)
						) SC
						FOR XML PATH ('spRetentionInfo'), ROOT('Api_GetIdxRetentionInfoResp')
					)
	END
IF @inAppType = 200118
	BEGIN
		INSERT INTO #tempObjToRetentionPolicy
		SELECT CAP.userGUID, CAP.subClientId, PLANPROP.attrVal,CAP.userAssocId
		FROM APP_CloudAppUserDetails CAP WITH(NOLOCK) JOIN App_PlanProp PLANPROP WITH(NOLOCK) ON CAP.planId = PLANPROP.componentNameId AND PLANPROP.attrName='Office 365 retention policy'
		WHERE CAP.modified = 0 AND PLANPROP.modified = 0
		GROUP BY CAP.userGUID,CAP.subClientId, PLANPROP.attrVal,CAP.userAssocId
		SET @o_xmlText = (
							SELECT
							(
								SELECT
								SC.subclientID AS '@subclientId',
7 as '@_type_'
								FOR XML PATH ('subclient'), TYPE
							),
							(
								SELECT
									(
										SELECT  CPD.policyDetails AS 'policy'
										FROM APP_ConfigurationPolicyDetails CPD WITH(NOLOCK) WHERE CPD.componentNameId = PD.policyID AND CPD.modified=0
										FOR XML PATH(''), TYPE
									),
									(
										SELECT TMP.objectGUID AS 'userGUIDs' FROM #tempObjToRetentionPolicy TMP
										WHERE TMP.policyId = PD.policyID AND TMP.subclientId = SC.subClientId
										FOR XML PATH(''), TYPE
									)
								FROM
								(
									SELECT DISTINCT policyID AS policyID
									FROM #tempObjToRetentionPolicy TMP WHERE TMP.subClientId = SC.subClientId
								) PD
								FOR XML PATH('objectLists'), TYPE
							)
						FROM
						(
							SELECT DISTINCT(subclientID) FROM APP_CloudAppUserDetails WITH(NOLOCK) WHERE subclientId
							IN
							(
								SELECT APP.id FROM App_IndexDbInfo IDX  WITH(NOLOCK) JOIN APP_Application APP WITH(NOLOCK)
								ON IDX.backupSetId = APP.backupSet AND IDX.currentIdxServer = @inIndexServerId AND IDX.type = @inAppType
							)
						) SC
						FOR XML PATH ('oneDriveRetentionInfoResp'), ROOT('Api_GetIdxRetentionInfoResp')
					)
	END
IF @inAppType = 200127
	BEGIN
		INSERT INTO #tempObjToRetentionPolicy
		 SELECT TOP(@count) CAP.userGUID, CAP.subClientId, PLANPROP.attrVal, CAP.userAssocId
		 FROM APP_CloudAppUserDetails CAP WITH(NOLOCK)
		 JOIN App_PlanProp PLANPROP WITH(NOLOCK) ON CAP.planId = PLANPROP.componentNameId AND PLANPROP.attrName='Office 365 retention policy'
		 JOIN APP_ConfigurationPolicyDetails CPD ON CPD.componentNameId = PLANPROP.attrVal AND CPD.modified=0
        WHERE
		CAP.modified = 0 AND PLANPROP.modified = 0 AND CPD.modified=0
		AND CAP.discoverByType = 14 --table level only
		AND CPD.policyDetails.value('(/cloudAppPolicy/retentionPolicy/@numOfDaysForMediaPruning)[1]','int') > 0
		AND CAP.userAssocId > @inassocId
		AND CAP.subClientId = @insubclientid
		order by CAP.userAssocId
		SET @maxAssocId = ( SELECT MAX(assocId) FROM #tempObjToRetentionPolicy)
		IF EXISTS (SELECT * FROM APP_CloudAppUserDetails where subClientId=@insubclientid AND userAssocId > @maxAssocId)
		BEGIN
			SET @hasMore = 1
		END
		SET @o_xmlText = (
							SELECT @maxAssocId as '@lastAssocId', @hasMore as '@hasMore',
							(
								SELECT
								@insubclientid AS '@subclientId',
7 as '@_type_'
								FOR XML PATH ('subclient'), TYPE
							),
							(
								SELECT
									(
										SELECT  CPD.policyDetails AS 'policy'
										FROM APP_ConfigurationPolicyDetails CPD WITH(NOLOCK) WHERE CPD.componentNameId = PD.policyID AND CPD.modified=0
										FOR XML PATH(''), TYPE
									),
									(
										SELECT TMP.objectGUID AS 'objectIds' FROM #tempObjToRetentionPolicy TMP
										WHERE TMP.policyId = PD.policyID AND TMP.subclientId = @insubclientid
										FOR XML PATH(''), TYPE
									)
								FROM
								(
									SELECT DISTINCT policyID AS policyID
									FROM #tempObjToRetentionPolicy TMP
									where
										 TMP.subClientId = @insubclientid
								) PD
								FOR XML PATH('objectLists'), TYPE
							)
						FOR XML PATH ('idxRetentionInfoResp'), ROOT('Api_GetIdxRetentionInfoResp')
					)
	END
ELSE IF @inAppType = 200128
	BEGIN
		-- Get the TeamGUID and the retention policy xml
		INSERT INTO #tempObjToRetentionPolicy
		 SELECT TOP(@count) CAP.userGUID, CAP.subClientId, PLANPROP.attrVal, CAP.userAssocId
		 FROM APP_CloudAppUserDetails CAP
		 JOIN App_PlanProp PLANPROP ON CAP.planId = PLANPROP.componentNameId AND PLANPROP.attrName='Office 365 retention policy'
		 JOIN APP_ConfigurationPolicyDetails CPD ON CPD.componentNameId = PLANPROP.attrVal AND CPD.modified=0
        WHERE
		CAP.modified = 0 AND PLANPROP.modified = 0 AND CPD.modified=0
		AND CAP.discoverByType = 12 /*CloudAppDiscoverByType.Teams */
		AND CPD.policyDetails.value('(/cloudAppPolicy/retentionPolicy/@numOfDaysForMediaPruning)[1]','int') > 0
		AND CAP.userAssocId > @inassocId
		AND CAP.subClientId = @insubclientid
		order by CAP.userAssocId
		SET @maxAssocId = ( SELECT MAX(assocId) FROM #tempObjToRetentionPolicy)
		IF EXISTS (SELECT * FROM APP_CloudAppUserDetails where subClientId=@insubclientid AND userAssocId > @maxAssocId)
		BEGIN
			SET @hasMore = 1
		END
		SET @o_xmlText = (
							SELECT @maxAssocId as '@lastAssocId', @hasMore as '@hasMore',
							(
								SELECT
								@insubclientid AS '@subclientId',
								7 as '@_type_'
								FOR XML PATH ('subclient'), TYPE
							),
							(
								SELECT
								(
									SELECT  CPD.policyDetails AS 'policy'
									FROM APP_ConfigurationPolicyDetails CPD WHERE CPD.componentNameId = PD.policyID AND CPD.modified=0
									FOR XML PATH(''), TYPE
								),
								(
									SELECT TMP.objectGUID AS 'objectIds' FROM #tempObjToRetentionPolicy TMP
									WHERE TMP.policyId = PD.policyID AND TMP.subclientId = @insubclientid
									FOR XML PATH(''), TYPE
								)
								FROM
								(
									SELECT DISTINCT policyID AS policyID FROM #tempObjToRetentionPolicy TMP WHERE TMP.subClientId = @insubclientid
								) PD
								FOR XML PATH('objectLists'), TYPE
							)
						FOR XML PATH ('idxRetentionInfoResp'), ROOT('Api_GetIdxRetentionInfoResp')
					)
	END
END
PROC_END:
IF object_id('tempdb.dbo.#tempObjToRetentionPolicy') IS NOT NULL DROP TABLE #tempObjToRetentionPolicy
IF @o_xmlText IS NULL
	SET @o_xmlText = '<Api_GetIdxRetentionInfoResp/>'
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIdxRetentionInfo')
	delete from GxQscripts where name = 'AppGetIdxRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetIdxRetentionInfo'
GO

insert into GXDBVersions values(2, 'AppGetIdxRetentionInfo',  '00000000000000000000', 'AppGetIdxRetentionInfo', '00000000000000000000')
GO

