

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIdxAfilesStatus.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetIdxAfilesStatus <<<'

IF EXISTS (select * from sysobjects where name='AppGetIdxAfilesStatus')
	drop procedure AppGetIdxAfilesStatus
IF EXISTS (select * from GxQscripts where name='AppGetIdxAfilesStatus')
	delete from GxQscripts where name = 'AppGetIdxAfilesStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxAfilesStatus')
	delete from GXDBVersions where aliasname = 'AppGetIdxAfilesStatus'
GO
print '... Creating Procedure: AppGetIdxAfilesStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIdxAfilesStatus
  @inxml XML
AS
DECLARE @copyId INT = 0
DECLARE @apptype INT = 0, @archFileID INT = 0
DECLARE @iAfiles TABLE (afileId BIGINT, commcellId  BIGINT, mediaLocation INT, isOnline INT)
INSERT INTO @iAfiles
SELECT afiles.c1.value('@afileId', 'INT') afileid, afiles.c1.value('@commCellId', 'INT') ccid, 0, 0
FROM @inxml.nodes('//Indexing_GetIdxAfilesStatus/idxAfiles') as afiles(c1)
UPDATE @iAfiles set mediaLocation = m.MediaLocation
FROM @iAfiles AF
JOIN archFileCopy AFC WITH (NOLOCK) ON AF.afileId = AFC.archfileId AND AFC.isValid = 1
JOIN archgroupCopy AGC WITH (NOLOCK) ON AFC.archcopyId = AGC.Id
JOIN archchunkmapping ACM WITH (NOLOCK) ON AF.afileId = ACM.archFileId AND AF.commcellID = ACM.commcellId
JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.ID
JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId
JOIN MMMedia M WITH (NOLOCK) ON V.MediaId = M.MediaId
UPDATE @iAfiles
set isonline = A1.isonline
FROM (SELECT MAX(CASE WHEN medialocation IN (1,2) THEN 1 ELSE 0 END) isonline, afileId from @iAfiles group by afileid) A1 JOIN @iAfiles A2 ON A1.afileId = a2.afileId
--Determine apptype
SELECT TOP 1 @archFileID = afileID from @iAfiles
SELECT TOP 1 @apptype = App.appTypeId from APP_Application App where APP.ID IN ( select appid from archFile where id = @archFileID )
-- NAS v1 snap jobs run with skip catalog option have only data arch file and no chunks. Always mark them as online.
IF @appType = 13
BEGIN
	UPDATE @iAfiles set isOnline = 1 from @iAfiles A1 JOIN archfile A2 WITH (NOLOCK) ON A1.afileId = A2.id where A2.fileType = 1
END
DECLARE @outxml XML = ''
SET @outxml = ISNULL((
SELECT distinct commcellId, afileId, isOnline from @iAfiles
FOR XML PATH ('idxAfiles') , ROOT('Indexing_GetIdxAfilesStatus')), '<Indexing_GetIdxAfilesStatus/>')
SELECT @outxml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIdxAfilesStatus')
	delete from GxQscripts where name = 'AppGetIdxAfilesStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxAfilesStatus')
	delete from GXDBVersions where aliasname = 'AppGetIdxAfilesStatus'
GO

insert into GXDBVersions values(2, 'AppGetIdxAfilesStatus',  '00000000000000000000', 'AppGetIdxAfilesStatus', '00000000000000000000')
GO

