

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetIdxActionLogDBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetIdxActionLogDBInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetIdxActionLogDBInfo <<<'
	drop procedure AppGetIdxActionLogDBInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetIdxActionLogDBInfo')
	delete from GxQscripts where name = 'AppGetIdxActionLogDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxActionLogDBInfo')
	delete from GXDBVersions where aliasname = 'AppGetIdxActionLogDBInfo'
GO
print '... Creating Procedure: AppGetIdxActionLogDBInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetIdxActionLogDBInfo
  @inXML xml
AS
  DECLARE @outXML xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @inJobId		INT
	DECLARE @inCommCellId	INT
	DECLARE @inClientId		INT
	DECLARE @inBkpSetGUID	uniqueidentifier
	DECLARE @inReqType		INT
	DECLARE @inIndexServerClientId		INT
	SET @inJobId		= ISNULL (( SELECT ref.value('@jobId', 'INTEGER')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), 0)
	SET @inCommCellId	= ISNULL (( SELECT ref.value('@commCellId', 'INTEGER')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), 2)
	SET @inClientId		= ISNULL (( SELECT ref.value('@clientId', 'INTEGER')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), 0)
	SET @inBkpSetGUID	= ISNULL (( SELECT ref.value('@backupSetGUID', 'uniqueidentifier')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), NULL)
	SET @inReqType		= ISNULL (( SELECT ref.value('@reqType', 'INTEGER')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), 0)
	SET @inIndexServerClientId	= ISNULL (( SELECT ref.value('@indexServerClientId', 'INTEGER')FROM @inXMl.nodes('App_GetIdxActionLogDBInfoReq') R(ref)), 0)
	IF @inReqType = 0 /*ClientId*/
	BEGIN
		SET @outXML =	(
							SELECT @inClientId AS '@clientId',
									(
										SELECT distinct A.backupSetGUID
										FROM App_IndexDBInfo A, App_Application B
										WHERE B.clientId = @inClientId AND B.backupSet = A.backupSetId AND A.isPrimary = 1
										FOR XML PATH('indexDbInfoList'), TYPE
									)
							FOR XML PATH('App_GetIdxActionLogDBInfoResp'), TYPE
						)
	END
	ELSE IF @inReqType = 1/*JobId*/
	BEGIN
		SET @inClientId = (SELECT B.clientid FROM App_Application B, JMBkpStats C WHERE C.jobid = @inJobId AND C.appId = B.id)
		SET @outXML =	(
							SELECT @inClientId AS '@clientId',
									(
										SELECT DISTINCT A.backupSetGUID
										FROM App_IndexDBInfo A, App_Application B, JMBkpStats C
										WHERE C.jobId = @inJobId AND C.appId = B.id AND B.backupSet = A.backupSetId AND A.isPrimary = 1
										FOR XML PATH('indexDbInfoList'), TYPE
									)
							FOR XML PATH('App_GetIdxActionLogDBInfoResp'), TYPE
						)
	END
	ELSE IF @inReqType = 2 /*BKPSETGUID*/
	BEGIN
		DECLARE @appTypeId INT
		DECLARE @IdxDbEngineType INT
		SET @appTypeId = ( select TOP 1 type from App_IndexDBInfo where backupSetGUID= @inBkpSetGUID)
		SET @IdxDbEngineType = ( select TOP 1 idxDbEngineType from App_IndexDBInfo where 					backupSetGUID= @inBkpSetGUID ORDER by idxDbEngineType ASC)
		IF ( @IdxDbEngineType = 1 )
		BEGIN
		  SET @outXML =   (
                            SELECT C.type '@appTypeId',
                            (
                            SELECT
                                    A.dbname AS '@dbName',
                                    A.backupSetGUID as '@backupSetGUID',
                                    B.name as '@currentIdxServer',
                                    A.committedTransactionId as '@committedTransactionId',
                                    A.type as '@dbType',
                                    A.idxDbEngineType as '@idxServerType',
                                   (
                                        SELECT id AS '@appId',
                                               GUID AS '@appGUID'
                                        FROM App_Application WHERE backupSet = (SELECT id FROM APP_BackupSetName WHERE GUID = @inBkpSetGUID)
                                        AND (subclientStatus & 16 != 16)/*Dummy*/ AND (subclientStatus & 32 != 32)/*Hidden*/
                                        FOR XML PATH('subclientInfoList'), TYPE
                                   )
                            FROM App_IndexDBInfo A, App_Client B
                            WHERE A.currentIdxServer = B.id AND A.backupSetGUID = @inBkpSetGUID AND A.isPrimary = 1
                            FOR XML PATH('indexDbInfoList'), TYPE
                            )
                            FROM App_IndexDBInfo C Where C.backupSetGUID = @inBkpSetGUID
                            FOR XML PATH('App_GetIdxActionLogDBInfoResp')
			)
		END
		ELSE
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
			CREATE TABLE #getIndexServers
                (     serverURL NVARCHAR(512),
                        clientId INT,
                        clientName NVARCHAR(256),
                        cloudId INT,
                        hostName NVARCHAR(256),
                        basePort INT,
                        engineName  NVARCHAR(256),
                        serverType INT,
                        indexServerClientId INT,
                        internalCloudName NVARCHAR(256)
                )
			DECLARE @indexServerClientId INT
			-- For exchange,nodeclient id is stored in App_IndexDBInfo table
			-- but for other appTypes, indexserver client id is stored in the table
IF ( @appTypeId = 137 )
				SET @indexServerClientId = ISNULL((SELECT idaProp.attrVal FROM
												App_IdaProp(NOLOCK) idaProp, App_IdaName(NOLOCK) idaName, App_Client(NOLOCK) client, App_Application(NOLOCK) sc,APP_BackupSetName(NOLOCK) bkpSet
												WHERE
												CAST(bkpSet.GUID AS VARCHAR(64)) = @inBkpSetGUID
												AND sc.backupSet = bkpSet.id
												AND sc.clientId = client.id
												AND idaName.clientId =  client.id
												AND idaName.id = idaProp.componentNameId
												AND idaProp.attrName = 'OnePass Index Server'
												AND idaProp.modified = 0), 0)
			ELSE
				SET @indexServerClientId = ( select currentIdxServer from App_IndexDBInfo where backupSetGUID = @inBkpSetGUID )
			exec DM2GetIndexServers @i_indexServerClientId = @indexServerClientId
			SET @outXML =	(
						SELECT @appTypeId '@appTypeId',
						(
						SELECT
								A.dbname AS '@dbName',
								A.backupSetGUID as '@backupSetGUID',
								(SELECT TOP 1 clientName From #getIndexServers IdxS) as '@currentIdxServer',
								A.committedTransactionId as '@committedTransactionId',
								A.type as '@dbType',
								A.idxDbEngineType as '@idxServerType',
                                (
                                    SELECT id AS '@appId',
											GUID AS '@appGUID'
									FROM App_Application WHERE backupSet = (SELECT id FROM APP_BackupSetName WHERE GUID = @inBkpSetGUID)
									AND (subclientStatus & 16 != 16)/*Dummy*/ AND (subclientStatus & 32 != 32)/*Hidden*/
									FOR XML PATH('subclientInfoList'), TYPE
                                )
						FROM App_IndexDBInfo A
						WHERE A.backupSetGUID = @inBkpSetGUID AND A.isPrimary = 1
						FOR XML PATH('indexDbInfoList'), TYPE
						)
						FOR XML PATH('App_GetIdxActionLogDBInfoResp')
						)
		END
	END
	ELSE IF @inReqType = 3 /*INDEXSERVER_CLIENT*/ -- Called for Standalone SOLR Backup.
	BEGIN
		IF object_id('tempdb.dbo.#ISBackupsets') IS NOT NULL
			DROP TABLE #ISBackupsets
		CREATE TABLE #ISBackupsets(backupSetGUID	VARCHAR(256), backupsetId INT, dbType INT)
		IF @inIndexServerClientId > 0
		BEGIN
			-- Exchange backupsets.
			INSERT INTO #ISBackupsets
			SELECT E.backupSetGUID, E.backupSetId, E.type
			FROM APP_IDAProp(NOLOCK) A, App_IdaName(NOLOCK) B, App_Application(NOLOCK) C, APP_BackupSetName(NOLOCK) D,
			App_IndexDBInfo(NOLOCK) E
			WHERE A.attrName = 'OnePass Index Server' And A.modified = 0 AND
			A.componentNameId = B.id AND B.appTypeId = 137 AND
			B.clientId = C.clientId AND B.appTypeId = C.appTypeId AND
			C.backupSet = D.id AND
			D.guid = E.backupSetGUID AND E.isPrimary = 1 AND
			CAST(A.attrVal AS INT) = @inIndexServerClientId
			-- Other than Exchange backupsets
			INSERT INTO #ISBackupsets
			SELECT distinct A.backupSetGUID AS '@backupSetGUID', A.backupSetId AS '@backupsetId', A.type AS '@dbType'
			FROM App_IndexDBInfo A
			WHERE A.currentIdxServer = @inIndexServerClientId AND A.isPrimary = 1 AND A.type != 137/*Exchange one pass*/
		END
		ELSE -- Backward compatablity for SolrBackup request below SP22 service packs.
		BEGIN
			INSERT INTO #ISBackupsets
			SELECT distinct A.backupSetGUID AS '@backupSetGUID', A.backupSetId AS '@backupsetId', A.type AS '@dbType'
			FROM App_IndexDBInfo A
			WHERE A.currentIdxServer = @inClientId AND A.isPrimary = 1
		END
		SET @outXML =	(
							SELECT @inClientId AS '@clientId',
									(
										SELECT *
										FROM #ISBackupsets
										FOR XML PATH('indexDbInfoList'), TYPE
									)
							FOR XML PATH('App_GetIdxActionLogDBInfoResp'), TYPE
						)
		DROP TABLE #ISBackupsets
	END
	IF @outXML IS NULL
		SET @outXML = '<App_GetIndexDBInfo/>'
	SELECT @outXML
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- return error response
	SET @outXML = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE)
	SELECT @outXML;
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetIdxActionLogDBInfo')
	delete from GxQscripts where name = 'AppGetIdxActionLogDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetIdxActionLogDBInfo')
	delete from GXDBVersions where aliasname = 'AppGetIdxActionLogDBInfo'
GO

insert into GXDBVersions values(2, 'AppGetIdxActionLogDBInfo',  '00000000000000000000', 'AppGetIdxActionLogDBInfo', '00000000000000000000')
GO

