

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetHonorArchiverRetentionDays.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetHonorArchiverRetentionDays.sp,v $ $Id: AppGetHonorArchiverRetentionDays.sp,v 1.1.4.4 2017/09/02 20:03:05 anarde Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetHonorArchiverRetentionDays <<<'

IF EXISTS (select * from sysobjects where name='AppGetHonorArchiverRetentionDays')
	drop procedure AppGetHonorArchiverRetentionDays
IF EXISTS (select * from GxQscripts where name='AppGetHonorArchiverRetentionDays')
	delete from GxQscripts where name = 'AppGetHonorArchiverRetentionDays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHonorArchiverRetentionDays')
	delete from GXDBVersions where aliasname = 'AppGetHonorArchiverRetentionDays'
GO
print '... Creating Procedure: AppGetHonorArchiverRetentionDays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetHonorArchiverRetentionDays
  @inputXML XML
AS
DECLARE @xmlResult XML
DECLARE @subclientId INT
DECLARE @getPolicyPropertyFromSubclientId INT
DECLARE @storagePolicyId INT
DECLARE @indexV2 INT
DECLARE @honorArchiverAgentRetention INT
DECLARE @archiveRetentionMode INT
DECLARE @backupRetentionMode INT
DECLARE @extendRetentionForNDays INT
DECLARE @associatedPolicyId INT
DECLARE @useSubclientPolicyRetention INT
DECLARE @storagePolicyArchiverDataRetention INT
DECLARE @storagePolicyRetentionDays INT
DECLARE @retentionDays INT
SET @subclientId = ISNULL(( SELECT ref.value('@subclientId', 'int')
                                    FROM   @inputXML.nodes('App_GetHonorArchiverRetentionDaysReq/subclient') R ( ref )
                                ), 0)
IF NOT EXISTS(SELECT 1 FROM APP_Application WITH(NOLOCK) WHERE id = @subclientId)
BEGIN
    SET @xmlResult =    (SELECT
                            (SELECT '1' AS '@errorCode',
                                    'Invalid subclientid' AS '@errorMessage'
                            FOR XML PATH('genericerror'), TYPE)
                        FOR XML PATH('App_GetHonorArchiverRetentionDaysResp'), TYPE )
    GOTO PROC_END
END
SET @indexV2 = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp cliProp WITH(NOLOCK)
						INNER JOIN APP_Application subclient WITH(NOLOCK) ON cliProp.componentNameId = subclient.clientId AND subclient.id = @subclientId
						WHERE cliProp.attrName = N'IndexingV2' AND cliProp.attrVal = N'1' AND cliProp.modified = 0), 0)
--Get storage policy property-------
SET @storagePolicyId = (SELECT dataArchGrpId FROM APP_Application WHERE id = @subclientId)
SET @storagePolicyArchiverDataRetention = (SELECT CASE WHEN MIN(AAR.archiverRetDays) = -1 THEN -1 ELSE MAX(AAR.archiverRetDays) END AS MaxArchiverRetDays
                                        FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
                                        WHERE AGC.archGroupId = @storagePolicyId
                                        AND      AGC.id = AAR.copyId
                                        AND      AGC.isSnapCopy = 0
                                        AND      AGC.type = 1)
SET @storagePolicyRetentionDays = (SELECT CASE WHEN MIN(AAR.retentionDays) = -1 THEN -1 ELSE MAX(AAR.retentionDays) END AS MaxRetentionDays
										FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
										WHERE AGC.archGroupId = @storagePolicyId
										AND      AGC.id = AAR.copyId
										AND      AGC.isSnapCopy = 0
										AND      AGC.type = 1)
------------------------------------
--Get non policy property-----------
SET @honorArchiverAgentRetention = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Honor Archiver Agent Retention' AND modified = 0), 0)
------------------------------------
--Get policy property---------------
SET @associatedPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Associated subclient Policy' AND modified = 0), 0)
SET @useSubclientPolicyRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Subclient Policy Has Retention' AND modified = 0)
IF @associatedPolicyId > 0 AND @useSubclientPolicyRetention > 0
	SET @getPolicyPropertyFromSubclientId = @associatedPolicyId
ELSE
	SET @getPolicyPropertyFromSubclientId = @subclientId
SET @extendRetentionForNDays = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @getPolicyPropertyFromSubclientId AND attrName = 'User deleted stubs expiration days' AND modified = 0), -1)
SET @archiveRetentionMode = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @getPolicyPropertyFromSubclientId AND attrName = N'Is Archive Retention Mode Enabled' AND modified = 0), 0)
SET @backupRetentionMode = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @getPolicyPropertyFromSubclientId AND attrName = N'Is Backup Retention Mode Enabled' AND modified = 0), 0)
------------------------------------
--Finally identify value of retention days------
IF @indexV2 = 0
	SET @retentionDays = @storagePolicyArchiverDataRetention
ELSE
BEGIN
		IF @honorArchiverAgentRetention = 1
		BEGIN
			IF @storagePolicyArchiverDataRetention = -1 OR @extendRetentionForNDays = -1
				SET @retentionDays = -1
			ELSE IF @storagePolicyArchiverDataRetention > @extendRetentionForNDays
				SET @retentionDays = @storagePolicyArchiverDataRetention
			ELSE
				SET @retentionDays = @extendRetentionForNDays
		END
		ELSE IF @archiveRetentionMode = 1 AND @backupRetentionMode = 0
		BEGIN
			IF @storagePolicyRetentionDays = -1 OR @extendRetentionForNDays = -1
				SET @retentionDays = -1
			ELSE IF @storagePolicyRetentionDays > @extendRetentionForNDays
				SET @retentionDays = @storagePolicyRetentionDays
			ELSE
				SET @retentionDays = @extendRetentionForNDays
		END
		ELSE
		BEGIN
			SET @xmlResult =    (SELECT
									(SELECT '2' AS '@errorCode',
										'Honor archiver agent retention is OFF, archive retention mode is not ON or backup retention mode is not OFF. Please check with dev on rules to get retention days.' AS '@errorMessage'
									FOR XML PATH('genericerror'), TYPE)
									FOR XML PATH('App_GetHonorArchiverRetentionDaysResp'), TYPE )
			GOTO PROC_END
		END
END
------------------------------------------------
SET @xmlResult =    (SELECT
							@retentionDays AS '@honorArchiverRetentionDays',
                            (SELECT '0' AS '@errorCode',
                                    'Success' AS '@errorMessage'
                            FOR XML PATH('genericError'), TYPE)
                        FOR XML PATH('App_GetHonorArchiverRetentionDaysResp'), TYPE )
PROC_END:
SELECT @xmlResult

IF EXISTS (select * from GxQscripts where name = 'AppGetHonorArchiverRetentionDays')
	delete from GxQscripts where name = 'AppGetHonorArchiverRetentionDays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHonorArchiverRetentionDays')
	delete from GXDBVersions where aliasname = 'AppGetHonorArchiverRetentionDays'
GO

insert into GXDBVersions values(2, 'AppGetHonorArchiverRetentionDays',  '00010001000400040000', 'AppGetHonorArchiverRetentionDays', '00010001000400040000')
GO

