

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetHedvigArrayIdForCDMSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetHedvigArrayIdForCDMSubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppGetHedvigArrayIdForCDMSubclient <<<'
	drop procedure AppGetHedvigArrayIdForCDMSubclient
END
IF EXISTS (select * from GxQscripts where name='AppGetHedvigArrayIdForCDMSubclient')
	delete from GxQscripts where name = 'AppGetHedvigArrayIdForCDMSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHedvigArrayIdForCDMSubclient')
	delete from GXDBVersions where aliasname = 'AppGetHedvigArrayIdForCDMSubclient'
GO
print '... Creating Procedure: AppGetHedvigArrayIdForCDMSubclient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetHedvigArrayIdForCDMSubclient
  @xmlstr XML 	OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @subclientId INT, @planId INT, @storagePolicyId INT, @defaultCopyId INT, @distributedStorageId INT, @controlHostId INT
DECLARE @clusterName NVARCHAR(255)
	SET @subclientId = ISNULL((SELECT  ref.value('@subclientId', 'INT')
      FROM    @xmlstr.nodes('App_GetHedvigArrayIdForCDMSubclientRequest/subclient') R ( ref )), 0)
	IF @subclientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input subclientId'
		GOTO PROC_EXIT
	END
SET @planId = (SELECT CAST(attrVal AS INT) FROM App_SubclientProp (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Associated Plan' AND cs_attrName = CHECKSUM(N'Associated Plan') AND modified = 0)
	IF @planId IS NULL
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Associated plan not found'
		GOTO PROC_EXIT
	END
SET @storagePolicyId = dbo.AppPlanGetEntityValueV2(@planId, 'Storage policy', 2)
	IF @storagePolicyId IS NULL
	BEGIN
		DECLARE @const_Inheritance  INT = 1
		DECLARE @basePlanId INT  = ISNULL((dbo.AppPlanGetBasePlanV2(@planId, @const_Inheritance)),0)
		IF @basePlanId <> 0
		BEGIN
SET @storagePolicyId = dbo.AppPlanGetEntityValueV2(@basePlanId, 'Storage policy', 2)
		END
		IF @storagePolicyId IS NULL
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Storage policy not found'
			GOTO PROC_EXIT
		END
	END
	SET @defaultCopyId = (SELECT defaultCopy FROM archGroup (NOLOCK) WHERE id = @storagePolicyId)
	IF @defaultCopyId IS NULL
	BEGIN
		SET @errorCode = 4
		SET @errorString = 'Storage policy copy not found'
		GOTO PROC_EXIT
	END
	SET @distributedStorageId = (
		SELECT top 1 MPDS.DistributedStorageId
		FROM MMDataPath D WITH (READUNCOMMITTED)
		INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
		INNER JOIN MMMountpath MP WITH (READUNCOMMITTED) ON DP.MasterPoolId = MP.MasterPoolId
		INNER JOIN MMMountPathToDistributedStorage MPDS WITH (READUNCOMMITTED) ON MP.MountPathId = MPDS.MountPathId
		WHERE D.copyId = @defaultCopyId
	)
	IF @distributedStorageId IS NULL
	BEGIN
		SET @errorCode = 5
		SET @errorString = 'Distributed storage not found'
		GOTO PROC_EXIT
	END
SET @clusterName = ISNULL((SELECT attrVal FROM App_DistributedStorageProp (NOLOCK) WHERE componentNameId = @distributedStorageId AND attrName = 'Cluster Name' AND cs_attrName = CHECKSUM('Cluster Name')), '')
	SET @controlHostId = (SELECT TOP 1 ControlHostId from SMControlHost (NOLOCK) where SMArrayId= @clusterName)
	IF @controlHostId IS NULL
	BEGIN
		SET @errorCode = 6
		SET @errorString = 'controlHostId not found for SMArrayId ' + @clusterName
		GOTO PROC_EXIT
	END
PROC_EXIT:
	SET @xmlstr = (
		SELECT @controlHostId AS '@hedvigArrayId',
		(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'), TYPE)
		FOR XML PATH ('App_GetHedvigArrayIdForCDMSubclientResponse')
	)
	select @xmlstr
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetHedvigArrayIdForCDMSubclient')
	delete from GxQscripts where name = 'AppGetHedvigArrayIdForCDMSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHedvigArrayIdForCDMSubclient')
	delete from GXDBVersions where aliasname = 'AppGetHedvigArrayIdForCDMSubclient'
GO

insert into GXDBVersions values(2, 'AppGetHedvigArrayIdForCDMSubclient',  '00000000000000000000', 'AppGetHedvigArrayIdForCDMSubclient', '00000000000000000000')
GO

