

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetHTTPProxySettingsForNetworkConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetHTTPProxySettingsForNetworkConfig.sp,v $ $Id: AppGetHTTPProxySettingsForNetworkConfig.sp,v 1.1.2.1 2020/10/14 17:37:22 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetHTTPProxySettingsForNetworkConfig
--  |
--  | Description:  This SP is used to fetch the HTTP proxy settings smartly for a given client by retrieving from parent groups as well.
--  |
--  |       Input:  Client ID
--  |
--  |      Output:  Returns HTTP Proxy settings for the given client
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Srilatha N				   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetHTTPProxySettingsForNetworkConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppGetHTTPProxySettingsForNetworkConfig <<<'
	drop procedure AppGetHTTPProxySettingsForNetworkConfig
END
IF EXISTS (select * from GxQscripts where name='AppGetHTTPProxySettingsForNetworkConfig')
	delete from GxQscripts where name = 'AppGetHTTPProxySettingsForNetworkConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHTTPProxySettingsForNetworkConfig')
	delete from GXDBVersions where aliasname = 'AppGetHTTPProxySettingsForNetworkConfig'
GO
print '... Creating Procedure: AppGetHTTPProxySettingsForNetworkConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetHTTPProxySettingsForNetworkConfig
  @i_clientId INTEGER
AS
  DECLARE @o_hostname NVARCHAR(255)
  DECLARE @o_port INTEGER
  DECLARE @o_proxyConfigType INTEGER
  DECLARE @o_credAssocId INTEGER
  DECLARE @o_parentGroupName NVARCHAR(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF EXISTS (SELECT 1 FROM App_HTTPProxySettings WHERE clientId=@i_clientId)
	BEGIN
		SELECT hostname, port, proxyType, credAssocId, '' FROM App_HTTPProxySettings WHERE clientId=@i_clientId AND proxyType<>0
	END
	ELSE
	BEGIN
		-- A client can inherit property from multiple groups,
		-- but we can consider only one, and we dont have a distinguishing factor to pick one.
		-- Hence we don't have an ORDER BY clause here.
		SELECT TOP 1 HP.hostname, HP.port, HP.proxyType, HP.credAssocId, ACG.name
		FROM App_HTTPProxySettings HP
		INNER JOIN APP_ClientGroup ACG
		ON HP.clientGroupId=ACG.id
		INNER JOIN APP_ClientGroupAssoc ACGA
		ON ACG.id=ACGA.clientGroupId
		WHERE ACGA.clientId=@i_clientId AND HP.proxyType<>0
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetHTTPProxySettingsForNetworkConfig')
	delete from GxQscripts where name = 'AppGetHTTPProxySettingsForNetworkConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHTTPProxySettingsForNetworkConfig')
	delete from GXDBVersions where aliasname = 'AppGetHTTPProxySettingsForNetworkConfig'
GO

insert into GXDBVersions values(2, 'AppGetHTTPProxySettingsForNetworkConfig',  '00010001000200010000', 'AppGetHTTPProxySettingsForNetworkConfig', '00010001000200010000')
GO

