

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetHTTPProxySettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetHTTPProxySettings.sp,v $ $Id: AppGetHTTPProxySettings.sp,v 1.1.2.1 2020/11/19 05:39:14 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetHTTPProxySettings
--  |
--  | Description:  This SP is used to fetch the HTTP proxy settings smartly for a given client/group by retrieving from parent groups as well.
--  |
--  |       Input:  Client ID
--  |				Client Group ID
--  |				Parameter governing settings inheritance from a group.
--  |
--  |      Output:  Returns HTTP Proxy settings for the given client
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Srilatha N				   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetHTTPProxySettings')
BEGIN
	print '>>> Drop Stored Procedure: AppGetHTTPProxySettings <<<'
	drop procedure AppGetHTTPProxySettings
END
IF EXISTS (select * from GxQscripts where name='AppGetHTTPProxySettings')
	delete from GxQscripts where name = 'AppGetHTTPProxySettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHTTPProxySettings')
	delete from GXDBVersions where aliasname = 'AppGetHTTPProxySettings'
GO
print '... Creating Procedure: AppGetHTTPProxySettings'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetHTTPProxySettings
  @i_clientId INTEGER,
  @i_clientGroupId INTEGER,
  @i_fetchFromParent INTEGER = 0,
  @i_forceFetchFromParent INTEGER = 0
AS
  DECLARE @o_server NVARCHAR(255)
  DECLARE @o_port INTEGER
  DECLARE @o_proxyConfigType INTEGER
  DECLARE @o_credAssocId INTEGER
  DECLARE @o_proxyBypassList VARCHAR(MAX)
  DECLARE @o_parentGroupName NVARCHAR(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
DECLARE @finalOutput TABLE (hostname NVARCHAR(255), port INTEGER, proxyType INTEGER, credAssocId INTEGER, proxyBypassList VARCHAR(MAX), parentGroupName NVARCHAR(255))
	IF @i_clientId<>0
	BEGIN
		INSERT INTO @finalOutput(hostname, port, proxyType, credAssocId, proxyBypassList, parentGroupName)
		SELECT hostname, port, proxyType, credAssocId, proxyBypassList, '' FROM App_HTTPProxySettings WHERE clientId=@i_clientId
	END
	ELSE IF @i_clientGroupId<>0
	BEGIN
		INSERT INTO @finalOutput(hostname, port, proxyType, credAssocId, proxyBypassList, parentGroupName)
		SELECT hostname, port, proxyType, credAssocId, proxyBypassList, '' FROM App_HTTPProxySettings WHERE clientGroupId=@i_clientGroupId
	END
	IF @i_fetchFromParent<>0
	BEGIN
		-- A client can inherit property from multiple groups,
		-- but we can consider only one, and we dont have a distinguishing factor to pick one.
		-- Hence we don't have an ORDER BY clause here.
		IF @i_forceFetchFromParent<>0
		BEGIN
			DELETE FROM @finalOutput
		END
		IF NOT EXISTS (SELECT 1 FROM @finalOutput)
		BEGIN
			INSERT INTO @finalOutput(hostname, port, proxyType, credAssocId, proxyBypassList, parentGroupName)
			SELECT TOP 1 HP.hostname, HP.port, HP.proxyType, HP.credAssocId, proxyBypassList, ACG.name
			FROM App_HTTPProxySettings HP
			INNER JOIN APP_ClientGroup ACG
			ON HP.clientGroupId=ACG.id
			INNER JOIN APP_ClientGroupAssoc ACGA
			ON ACG.id=ACGA.clientGroupId
			WHERE ACGA.clientId=@i_clientId
		END
	END
	SELECT hostname, port, proxyType, credAssocId, proxyBypassList, parentGroupName FROM @finalOutput
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetHTTPProxySettings')
	delete from GxQscripts where name = 'AppGetHTTPProxySettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetHTTPProxySettings')
	delete from GXDBVersions where aliasname = 'AppGetHTTPProxySettings'
GO

insert into GXDBVersions values(2, 'AppGetHTTPProxySettings',  '00010001000200010000', 'AppGetHTTPProxySettings', '00010001000200010000')
GO

