

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetGUIDbyNameAndAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetGUIDbyNameAndAppType.sp,v $ $Id: AppGetGUIDbyNameAndAppType.sp,v 1.4.86.1 2018/03/22 01:36:16 jiechen Exp $"
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetGUIDbyNameAndAppType <<<'

IF EXISTS (select * from sysobjects where name='AppGetGUIDbyNameAndAppType')
	drop procedure AppGetGUIDbyNameAndAppType
IF EXISTS (select * from GxQscripts where name='AppGetGUIDbyNameAndAppType')
	delete from GxQscripts where name = 'AppGetGUIDbyNameAndAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetGUIDbyNameAndAppType')
	delete from GXDBVersions where aliasname = 'AppGetGUIDbyNameAndAppType'
GO
print '... Creating Procedure: AppGetGUIDbyNameAndAppType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetGUIDbyNameAndAppType
  @appClientNameGUIDInfo XML
AS
DECLARE @handle INT
DECLARE @filter NVARCHAR(MAX)
DECLARE @appType INT = @appClientNameGUIDInfo.value('(/App_ClientNameGUIDInfo/@appTypeId)[1]', 'INT')
DECLARE @nameSearchType VARCHAR(20) = @appClientNameGUIDInfo.value('(/App_ClientNameGUIDInfo/@nameSearchType)[1]', 'VARCHAR(20)')
IF @nameSearchType = 'AND'
BEGIN
	EXEC sp_xml_preparedocument @handle OUTPUT, @appClientNameGUIDInfo
	SELECT @filter = COALESCE( @filter + '%','') + name FROM OPENXML (@handle, 'App_ClientNameGUIDInfo/info') WITH (name [NVARCHAR](1000) '@sName')
	EXEC sp_xml_removedocument @handle
END
IF EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = @appType ) --'APPGRP_W2KFileSystem
   OR EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = @appType) --'APPGRP_UnixFileSystem
BEGIN
	IF @nameSearchType = 'OR'
	BEGIN
		SET @appClientNameGUIDInfo =
		(SELECT @appType AS '@appTypeId',
			(SELECT DISTINCT CL.name AS '@sName', CL.GUID AS '@sGUID'
				FROM APP_Client CL WITH(NOLOCK), APP_Application APP WITH(NOLOCK)
				CROSS APPLY @appClientNameGUIDInfo.nodes('/App_ClientNameGUIDInfo/info') AS Info(inf)
				WHERE CL.id = APP.clientId
				  AND APP.appTypeId IN
						(SELECT appTypeId FROM GetAppTypesForAppGroup(22,0)
						 UNION
						 SELECT appTypeId FROM GetAppTypesForAppGroup(34,0))
				  AND CL.name like '%'+ (inf.value('@sName', 'nvarchar(512)')) + '%'
			FOR XML PATH('info'),TYPE)
		FOR XML PATH('App_ClientNameGUIDInfo'))
	END
	IF @nameSearchType = 'AND'
	BEGIN
		SET @appClientNameGUIDInfo =
		(SELECT @appType AS '@appTypeId',
			(SELECT DISTINCT CL.name AS '@sName', CL.GUID AS '@sGUID'
				FROM APP_Client CL WITH(NOLOCK), APP_Application APP WITH(NOLOCK)
				WHERE CL.id = APP.clientId
     			AND APP.appTypeId IN
						(SELECT appTypeId FROM GetAppTypesForAppGroup(22,0)
						 UNION
						 SELECT appTypeId FROM GetAppTypesForAppGroup(34,0))
				AND CL.name like '%'+ @filter + '%'
			FOR XML PATH('info'),TYPE)
		FOR XML PATH('App_ClientNameGUIDInfo'))
	END
END
ELSE
BEGIN
	IF @nameSearchType = 'OR'
	BEGIN
		SET @appClientNameGUIDInfo =
		(SELECT @appType AS '@appTypeId',
			(SELECT DISTINCT appGuid.name AS '@sName', appGuid.GUID AS '@sGUID'
				FROM APP_GUID appGuid WITH(NOLOCK)
				CROSS APPLY @appClientNameGUIDInfo.nodes('/App_ClientNameGUIDInfo/info') AS Info(inf)
				WHERE appGuid.status = 1 AND appGuid.name like '%'+ (inf.value('@sName', 'nvarchar(512)')) + '%'
			FOR XML PATH('info'),TYPE)
		FOR XML PATH('App_ClientNameGUIDInfo'))
	END
	IF @nameSearchType = 'AND'
	BEGIN
		SET @appClientNameGUIDInfo =
		(SELECT @appType AS '@appTypeId',
			(SELECT DISTINCT appGuid.name AS '@sName', appGuid.GUID AS '@sGUID'
				FROM APP_GUID appGuid WITH(NOLOCK)
				WHERE  status = 1 AND appGuid.name like '%'+ @filter + '%'
			FOR XML PATH('info'),TYPE)
		FOR XML PATH('App_ClientNameGUIDInfo'))
	END
END
SELECT @appClientNameGUIDInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetGUIDbyNameAndAppType')
	delete from GxQscripts where name = 'AppGetGUIDbyNameAndAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetGUIDbyNameAndAppType')
	delete from GXDBVersions where aliasname = 'AppGetGUIDbyNameAndAppType'
GO

insert into GXDBVersions values(2, 'AppGetGUIDbyNameAndAppType',  '00010004008600010000', 'AppGetGUIDbyNameAndAppType', '00010004008600010000')
GO

