

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFirstClientForClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- This SP will return clientId from ClientGroup as data access node.
-- It will return first client which is part of clientGroup having appTypeId supported.
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetFirstClientForClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFirstClientForClientGroup <<<'
	drop procedure AppGetFirstClientForClientGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetFirstClientForClientGroup')
	delete from GxQscripts where name = 'AppGetFirstClientForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirstClientForClientGroup')
	delete from GXDBVersions where aliasname = 'AppGetFirstClientForClientGroup'
GO
print '... Creating Procedure: AppGetFirstClientForClientGroup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetFirstClientForClientGroup
  @clientGroupId INT,
  @appTypeId INT
AS
  DECLARE @clientId INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT TOP 1 @clientId =  CGA.clientId
FROM APP_ClientGroupAssoc CGA
INNER JOIN APP_Application APP WITH(NOLOCK)
ON CGA.clientId = APP.clientId
	AND APP.appTypeId = @appTypeId
WHERE CGA.clientGroupId = @clientGroupId
IF @clientId IS NULL
BEGIN
	SET @clientId = 0
END
SELECT @clientId as 'clientId'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFirstClientForClientGroup')
	delete from GxQscripts where name = 'AppGetFirstClientForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirstClientForClientGroup')
	delete from GXDBVersions where aliasname = 'AppGetFirstClientForClientGroup'
GO

insert into GXDBVersions values(2, 'AppGetFirstClientForClientGroup',  '00000000000000000000', 'AppGetFirstClientForClientGroup', '00000000000000000000')
GO

