

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFirewallTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		July 08, 2009: Converted to SP for performance/debugging  -SKatz
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFirewallTopology.sp,v $ $Id: AppGetFirewallTopology.sp,v 1.3.2.10 2018/09/08 03:17:59 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFirewallTopology <<<'

IF EXISTS (select * from sysobjects where name='AppGetFirewallTopology')
	drop procedure AppGetFirewallTopology
IF EXISTS (select * from GxQscripts where name='AppGetFirewallTopology')
	delete from GxQscripts where name = 'AppGetFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppGetFirewallTopology'
GO
print '... Creating Procedure: AppGetFirewallTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFirewallTopology
  @userId INT
AS
  DECLARE @o_topologyId INT
  DECLARE @o_topologyName nvarchar(256)
  DECLARE @o_description nvarchar(max)
  DECLARE @o_topologyType INT
  DECLARE @o_created INT
  DECLARE @o_modified INT
  DECLARE @o_extendedProperties NVARCHAR(MAX)
  DECLARE @o_isSmartTopology INT
  DECLARE @o_isTopologyForCSFailover INT
  DECLARE @o_flags INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF object_id('tempdb.dbo.#cgList') IS NOT null
	BEGIN
		DROP TABLE #cgList
	END
	CREATE TABLE #cgList (cgId INTEGER NOT NULL)
	--Get the list of client groups that the user has access to
EXEC sec_getNonIdaObjectsForThisUser @userId,28,0,#cgList
	--Because we have to pick the smart topologies too in the final select query, insert -1,-2,-3,-4 into #cgList.
	INSERT INTO #cgList VALUES (-1),(-2),(-3),(-4)
SELECT topologyId,topologyName,description,topologyType,created,modified,convert(nvarchar(max),extendedProperties),(flag & 1) isSmartTopology,
(flag & 2) isTopologyForCSFailover, flag from APP_FirewallTopology WHERE topologyId not in (
	SELECT topologyId from APP_FirewallTopologyAssoc WHERE groupId not in (SELECT cgId from #cgList))
	IF object_id('tempdb.dbo.#cgList') IS NOT null
	BEGIN
		DROP TABLE #cgList
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFirewallTopology')
	delete from GxQscripts where name = 'AppGetFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppGetFirewallTopology'
GO

insert into GXDBVersions values(2, 'AppGetFirewallTopology',  '00010003000200100000', 'AppGetFirewallTopology', '00010003000200100000')
GO

