

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFirewallEnabledEntities.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFirewallEnabledEntities.sp,v $ $Id: AppGetFirewallEnabledEntities.sp,v 1.1.2.2 2018/12/19 23:41:29 bmehta Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetFirewallEnabledEntities   - get list of firewall enabled entities
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFirewallEnabledEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFirewallEnabledEntities <<<'
	drop procedure AppGetFirewallEnabledEntities
END
IF EXISTS (select * from GxQscripts where name='AppGetFirewallEnabledEntities')
	delete from GxQscripts where name = 'AppGetFirewallEnabledEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirewallEnabledEntities')
	delete from GXDBVersions where aliasname = 'AppGetFirewallEnabledEntities'
GO
print '... Creating Procedure: AppGetFirewallEnabledEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFirewallEnabledEntities
  @i_userId INT,
  @o_xmlText NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @canManageCommserver INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 1 /*EV_SCHEDULE_ADMIN*/, @canManageCommserver OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
IF @canManageCommserver	> 0
BEGIN
	SET @o_xmlText = (SELECT (
								SELECT id AS '@clientId', name AS '@clientName', displayName AS '@displayName'
								FROM App_Client C
									INNER JOIN (SELECT clientId FROM App_FWTrivialConfig WHERE isTrivialConfig > 0 AND clientId > 0
												UNION
												SELECT CG.clientId FROM App_FWTrivialConfig T
													INNER JOIN APP_ClientGroupAssoc CG ON  T.clientGroupId = CG.clientGroupId
												WHERE T.isTrivialConfig > 0 AND T.clientGroupId > 0) FW
									ON C.id = FW.clientId
								FOR XML PATH ('clients'), TYPE
							)
						FOR XML PATH(''), ROOT('App_FirewallEnabledEntitiesResp')
					  )
END
IF(@o_xmlText is null)
	SET @o_xmlText = '<App_FirewallEnabledEntitiesResp />'
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFirewallEnabledEntities')
	delete from GxQscripts where name = 'AppGetFirewallEnabledEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFirewallEnabledEntities')
	delete from GXDBVersions where aliasname = 'AppGetFirewallEnabledEntities'
GO

insert into GXDBVersions values(2, 'AppGetFirewallEnabledEntities',  '00010001000200020000', 'AppGetFirewallEnabledEntities', '00010001000200020000')
GO

