

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFireWallProxyClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetFireWallProxyClients')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFireWallProxyClients <<<'
	drop procedure APPGetFireWallProxyClients
END
IF EXISTS (select * from GxQscripts where name='APPGetFireWallProxyClients')
	delete from GxQscripts where name = 'APPGetFireWallProxyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFireWallProxyClients')
	delete from GXDBVersions where aliasname = 'APPGetFireWallProxyClients'
GO
print '... Creating Procedure: APPGetFireWallProxyClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFireWallProxyClients
  @userId INTEGER
AS
SET NOCOUNT ON
	DECLARE @isAllAssociationsSet INTEGER = 0
	DECLARE @clients table(clientId int)
	DECLARE @clientGroup table (clientGroupId int)
    IF object_id('tempdb.dbo.#ClientList') IS NOT NULL
        DROP TABLE #ClientList
create table  #ClientList ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @userId, 2009, 0, '#ClientList'
select @isAllAssociationsSet=capabilities & CAST(POWER(2.0, 2 - 1)as bigint ) FROM #ClientList sec	WHERE ((sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	IF @isAllAssociationsSet<>0
		BEGIN
			insert into @clients
			 select clientId from App_FirewallOptions with (nolock) where isdmz=1
			insert into @clientGroup
select AFO.clientgroupid from APP_FirewallOptions AFO with (nolock) where AFO.isdmz=1 AND (AFO.flag & 4 <> 4)
		END
	ELSE
		BEGIN
			insert into @clients
				select FW.clientId from App_FirewallOptions FW with (nolock)
				inner join #ClientList CL on FW.clientId=CL.clientId
where FW.isDMZ=1 and (isnull(CL.capabilities & (CAST(POWER(2.0, 2 - 1)as bigint )), 0) <> 0)
			insert into @clientGroup
				select FW.clientGroupId from App_FirewallOptions FW with (nolock)
inner join #ClientList CGL on FW.clientGroupId=CGL.clientGroupId AND (FW.flag & 4 <> 4)
where FW.isDMZ=1 and (isnull(CGL.capabilities & (CAST(POWER(2.0, 2 - 1)as bigint )), 0) <> 0)
		END
	select 1 as tag,
	NULL as Parent,
	NULL as [App_GetFirewallProxyClientsResp!1!],
	NULL as [proxyEntities!2!clientId],
	NULL as [proxyEntities!2!clientName],
    NULL as [proxyEntities!2!displayName],
	NULL as [proxyEntities!2!clientGroupId],
	NULL as [proxyEntities!2!clientGroupName],
	NULL as [proxyEntities!2!_type_]
	UNION ALL
    select distinct 2,1, NULL, C.id, C.name,C.displayName,NULL,NULL, 3
	from @clients FWClients
	inner join App_Client C with (nolock) on C.id = FWClients.clientid
	UNION ALL
    select distinct 2, 1, NULL, NULL,NULL, NULL, CG.id,CG.name, 28
	from @clientGroup FWClientGroup
	inner join App_ClientGroup CG with (nolock) on CG.id = FWClientGroup.clientGroupid
	for xml explicit
	drop table #ClientList
SET NOCOUNT OFF
--sample output
--<App_GetFirewallProxyClientsResp>
--  <proxyEntities clientId="5" clientName="client_1" displayName="my_display_name_1" _type_="3" />
--  <proxyEntities clientId="6" clientName="client_2" displayName="my_display_name_2" _type_="3" />
--  <proxyEntities clientGroupId="5" clientGroupName="grp1" _type_="28" />
--</App_GetFirewallProxyClientsResp>
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFireWallProxyClients')
	delete from GxQscripts where name = 'AppGetFireWallProxyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFireWallProxyClients')
	delete from GXDBVersions where aliasname = 'AppGetFireWallProxyClients'
GO

insert into GXDBVersions values(2, 'AppGetFireWallProxyClients',  '00000000000000000000', 'AppGetFireWallProxyClients', '00000000000000000000')
GO

