

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFileSystemUsages.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFileSystemUsages.sp,v $ $Id: AppGetFileSystemUsages.sp,v 1.11.2.6 2018/09/30 02:36:05 srajani Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Get quota limit and space consumption for all users
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFileSystemUsages <<<'

IF EXISTS (select * from sysobjects where name='AppGetFileSystemUsages')
	drop procedure AppGetFileSystemUsages
IF EXISTS (select * from GxQscripts where name='AppGetFileSystemUsages')
	delete from GxQscripts where name = 'AppGetFileSystemUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFileSystemUsages')
	delete from GXDBVersions where aliasname = 'AppGetFileSystemUsages'
GO
print '... Creating Procedure: AppGetFileSystemUsages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFileSystemUsages
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- get list of all galaxy users and end users
	IF object_id('tempdb.dbo.#quotaUsageDetails') IS NOT NULL DROP TABLE #quotaUsageDetails
	CREATE TABLE #quotaUsageDetails(userId INT, name nvarchar(max), login nvarchar(max), email nvarchar(max), quotaLimit BIGINT, spaceConsumed BIGINT);
	INSERT INTO #quotaUsageDetails
	SELECT id, name, login, email, ISNULL([FSQuotaLimit], 0), ISNULL([FSQuotaUsage], 0)
	FROM
		(
			SELECT U.id, U.name, U.email, U.login, UP.attrName, CAST(UP.attrVal AS BIGINT) AS attrVal
FROM UMUsers U WITH(NOLOCK) JOIN UMUsersProp UP WITH (NOLOCK) ON U.id = UP.componentNameId	AND attrName IN ('FSQuotaLimit','FSQuotaUsage')
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 AND U.id > 0
		) as T
	PIVOT ( MAX(attrVal) FOR attrName IN ( [FSQuotaLimit], [FSQuotaUsage]) ) AS P
	--
	-- return the table response
	SELECT
		U.userId, U.name, U.login, U.email,
		CASE WHEN U.quotaLimit = 0 THEN N'Not Set' ELSE CONVERT(nvarchar(max), U.quotaLimit / (1024*1024*1024)) END, -- quota limit
		CASE WHEN U.spaceConsumed = 0 THEN N'0.00' ELSE CONVERT(decimal(10,2), (CAST(U.spaceConsumed AS float) / (1024*1024*1024))) END, -- space consumed
		CASE WHEN U.quotaLimit = 0 THEN N'0.00' ELSE CONVERT(decimal(10,2), (U.spaceConsumed * 100.0) / U.quotaLimit) END -- quota limit (in percentage)
		FROM #quotaUsageDetails U;
	IF object_id('tempdb.dbo.#quotaUsageDetails') IS NOT NULL DROP TABLE #quotaUsageDetails
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- return no response
END CATCH
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFileSystemUsages')
	delete from GxQscripts where name = 'AppGetFileSystemUsages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFileSystemUsages')
	delete from GXDBVersions where aliasname = 'AppGetFileSystemUsages'
GO

insert into GXDBVersions values(2, 'AppGetFileSystemUsages',  '00010011000200060000', 'AppGetFileSystemUsages', '00010011000200060000')
GO

