

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFileStoreShares.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFileStoreShares.sp,v $ $Id: AppGetFileStoreShares.sp,v 1.1.2.2 2018/12/15 20:09:24 gpattabiraman Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetFileStoreShares
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFileStoreShares')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFileStoreShares <<<'
	drop procedure AppGetFileStoreShares
END
IF EXISTS (select * from GxQscripts where name='AppGetFileStoreShares')
	delete from GxQscripts where name = 'AppGetFileStoreShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFileStoreShares')
	delete from GXDBVersions where aliasname = 'AppGetFileStoreShares'
GO
print '... Creating Procedure: AppGetFileStoreShares'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFileStoreShares
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL(( SELECT ref.value('@userId', 'int')
								FROM @i_xml . nodes('CvEntities_UserEntity') R ( ref )
							), 0)
	IF OBJECT_ID(N'tempdb.dbo.#FileStoreClients') IS NOT NULL
		DROP TABLE #FileStoreClients
	CREATE TABLE #FileStoreClients(clientId int, clientName NVARCHAR(512), privateShareId int, publicShareId int)
	-- Get all file store clients that the user has access to
	INSERT INTO #FileStoreClients
	SELECT C.id, C.name, CAST(SP.attrVal AS INT), CAST(SP2.attrVal AS INT)
	FROM APP_Client C
	INNER JOIN APP_ClientProp CP ON C.id = CP.componentNameId AND CP.modified = 0 AND CP.attrName = 'OutlookAddin ContentStore UserGroups' --CV_PROP_OUTLOOK_ADDIN_USERGROUPS
	INNER JOIN APP_Application APP ON APP.clientId = C.id AND APP.subclientStatus& 0x20000 = 0x20000 --CV_STATUS_EDGEDRIVE_SUB
	INNER JOIN APP_ClientProp CP2 ON C.id = CP2.componentNameId AND CP2.modified = 0 AND CP2.attrName = 'System Drive Type' -- CV_PROP_SYSTEM_DRIVE_TYPE
	INNER JOIN APP_SubClientProp SP ON APP.id = SP.componentNameId AND SP.modified = 0 AND SP.attrName = 'OutlookAddinStore Private Share' -- CV_PROP_OUTLOOK_ADDIN_STORE_PRIVATE_SHARE
	INNER JOIN APP_SubClientProp SP2 ON APP.id = SP2.componentNameId AND SP2.modified = 0 AND SP2.attrName = 'OutlookAddinStore Public Share' -- CV_PROP_OUTLOOK_ADDIN_STORE_PUBLIC_SHARE
	WHERE C.status & 0x40000000 = 0x40000000 --CV_STATUS_SYSTEM_EDGE_DRIVE
	AND CP2.attrVal = '7' -- EdgeSystemDriveTypes_FILESTORE
	AND
	EXISTS( SELECT 1
				FROM dbo.SplitStringByDelimiter(CP.attrVal, ':') A
				INNER JOIN UMUserGroup G ON A._ID = G.groupId
				WHERE G.userId = @userId
			  )
	SET @o_xml = (
					SELECT
					(
						SELECT
							(
								SELECT	clientId AS '@clientId',
										clientName AS '@clientName'
								FOR XML PATH('objectStore'),TYPE
							),
							(
								SELECT privateShareId AS '@shareId'
								FOR XML PATH('privateShare'),TYPE
							),
							(
								SELECT publicShareId AS '@shareId'
								FOR XML PATH('publicShare'),TYPE
							)
						FROM #FileStoreClients
						FOR XML PATH('fileStores'),TYPE
					)
					FOR XML PATH('App_FileStoreShares'), TYPE
				)
	IF OBJECT_ID(N'tempdb.dbo.#FileStoreClients') IS NOT NULL
		DROP TABLE #FileStoreClients
	SELECT @o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFileStoreShares')
	delete from GxQscripts where name = 'AppGetFileStoreShares'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFileStoreShares')
	delete from GXDBVersions where aliasname = 'AppGetFileStoreShares'
GO

insert into GXDBVersions values(2, 'AppGetFileStoreShares',  '00010001000200020000', 'AppGetFileStoreShares', '00010001000200020000')
GO

