

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFeaturesListForClient.sp] ---------- 

-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFeaturesListForClient.sp,v $ $Id: AppGetFeaturesListForClient.sp,v 1.1.2.12 2018/07/05 16:33:16 nshah Exp $";
-- Name of the stored procedure
-- It must match with the name of the .sp file
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFeaturesListForClient <<<'

IF EXISTS (select * from sysobjects where name='AppGetFeaturesListForClient')
	drop procedure AppGetFeaturesListForClient
IF EXISTS (select * from GxQscripts where name='AppGetFeaturesListForClient')
	delete from GxQscripts where name = 'AppGetFeaturesListForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFeaturesListForClient')
	delete from GXDBVersions where aliasname = 'AppGetFeaturesListForClient'
GO
print '... Creating Procedure: AppGetFeaturesListForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFeaturesListForClient
-- Input variables of the stored procedure
  @i_xml XML output,
  @i_selectOut int
-- Tell the AWK processor that body of query starts here
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
DECLARE @detailsRequested int = Isnull((SELECT @i_xml.value('(/App_GetFeaturesListforClientReq/@detailsRequested)[1]', 'INT')),3)
DECLARE @userId int = (SELECT @i_xml.value('(/App_GetFeaturesListforClientReq/user/@userId)[1]','INT'))
DECLARE @userName nvarchar(max) = (SELECT @i_xml.value('(/App_GetFeaturesListforClientReq/user/@userName)[1]','nvarchar(max)'))
DECLARE @clientId int = (SELECT @i_xml.value('(/App_GetFeaturesListforClientReq/client/@clientId)[1]','INT'))
DECLARE @clientName nvarchar(max) = (SELECT @i_xml.value('(/App_GetFeaturesListforClientReq/client/@clientName)[1]','nvarchar(max)'))
declare @planId int = 0
declare @userCentric int = 0
declare @xmlData xml
DECLARE @isDriveExist BIT = 0
DECLARE @edgeClientsWithCapabilities TABLE (
    clientId INT
    ,clientStatus INT
    ,capabilities BIGINT
    ,userAssociationType INT
    )
declare @isTokenNeeded int =0
declare @isFeatureListNeeded int = 0
-- ClientAppRequestType_TOKEN, ClientAppRequestType_ALL
if (@detailsRequested=2 or @detailsRequested=3)
begin
	set @isTokenNeeded = 1
end
-- ClientAppRequestType_FEATURES_LIST, ClientAppRequestType_ALL
if (@detailsRequested=1 or @detailsRequested=3)
begin
	set @isFeatureListNeeded = 1
end
-- If userId isnt filled, pick it up from userName
if @userId is null or @userId<=0
begin
	select @userId = id from UMUsers where login=@userName
end
if @userId is null or @userId<=0
begin
	set @errorCode = 1 -- Invalid user information.
	set @errorMsg = 'Invalid User information passed'
	goto EXIT_ERROR
end
-- If clientId isnt filled, pick it up from Client name.
if @clientId is NULL or @clientId<=0
begin
	select @clientId = id from App_client where name=@clientName
end
if @clientId is NULL or @clientId<=0
begin
	set @errorCode = 2 -- Invalid client information.
	set @errorMsg = 'Invalid client information passed'
	goto EXIT_ERROR
end
-- Fill user name and client name here.
select @userName=login from UMUsers where id=@userId
select @clientName=name from app_client where id=@clientId
-- Check whether user is client owner or not.
declare @isClientOwner int = 0;
select @isClientOwner = dbo.IsClientOwner(@clientId,@userId)
if (@isClientOwner=0 and @isTokenNeeded=1)
begin
	set @errorCode = 3 -- User isnt owner of client
	set @errorMsg = 'User needs to be client owner to retrieve token. '
	goto EXIT_ERROR
end
declare @token nvarchar(max) = ''
if @isTokenNeeded=1
begin
	declare @csName nvarchar(max) = ''
	declare @csNetHostName nvarchar(max) = ''
	select @csName=name,@csNetHostName=net_hostname from app_client where id=2
	declare @tokenGuid table
	(
		errorCode int,
		guid nvarchar(max)
	)
	Insert into @tokenGuid
	exec QSDKCreateSessionForGUIUser @userId,@clientName
	select @errorCode = errorCode,@token=guid from @tokenGuid
	if @errorCode<>0
	begin
		goto EXIT_ERROR
	end
	-- Once you have the tokenGuid, set the timeout to a very large value like 1 yr...
	-- Generate a random no between 335 and 365 days so that not all of them have timeouts at the same time.
	Update UMQsdkSessions
	set timeout = ROUND(((365 - 335 -1) * RAND() + 335), 0)*24*60
	where Guid=@token
	-- Now we have tokenGuid, userName,client name and Cs name.. form the token.
	-- Generate QAllTokenInfo xml from above. and pass it on client side.
	declare @loginTokenXml xml
	declare @loginTokenXmlNvarchar nvarchar(maX)
	set @loginTokenXml = ( select
		 @userName '@user',
		 @csName '@csClientName',
		 @csNetHostName '@commServer',
		 dbo.base64Encode(@token) '@guid'
	for xml path('tokenInfo'),root('QSDKLogin_QAllTokenInfo')
	)
	set @loginTokenXmlNvarchar = convert(nvarchar(max),@loginTokenXml)
	exec pswEncryptionManaged @loginTokenXmlNvarchar , @token output
	set @token = 'QSDK '+@token
end
if @isFeatureListNeeded=1
begin
	-- check whether user is associated to plan.
DECLARE @capUploadBrowse bigint= ( CONVERT(BIGINT,POWER(2.0, 5 -1)) | CONVERT(BIGINT,POWER(2.0, 13 -1)) );
    DECLARE @planName NVARCHAR(255)
	DECLARE @planDetails table
    (
		planId int,
        userCentric int,
        errorCode int,
        errorString nvarchar(max)
    )
	Insert into @planDetails
	exec AppGetAssociatedPlanForUser @userId,0, @planId OUTPUT, @planName OUTPUT, @userCentric OUTPUT, @errorCode OUTPUT, @errorMsg OUTPUT
	if @errorCode<>0
	begin
		goto EXIT_ERROR
	end
	declare @permissionList table
	(
		permissionId int
	)
	if (@planId>0)
	begin
			Insert into @permissionList
            	SELECT  URP.permissionId
                FROM    UMRolesPermissions URP
WHERE   URP.roleId = CAST(dbo.AppPlanGetEntityValueV2(@planId, 'Feature', default) AS INT)
	end
	-- We have come to Else. So no plan is associated. Now we check user/client level properties only if its machine centric. Else we dont return anything.
	else if @userCentric=0
	begin
		-- In case its not associated to plan
		-- check whether dlp is enabled.
		-- if its laptop client then dlp is enabled
		if exists(select 1 from app_client where id=@clientId and (status&4096)>0 )
		begin
			insert into @permissionList
select 148
			-- check whether user is owner of client. If so, add laptop feature also.
			if (@isClientOwner=1)
			begin
				insert into @permissionList
select 145
			end
		end
		IF EXISTS (SELECT TOP 1 AAP.id
		FROM APP_BackupSetProp ABP
		INNER JOIN App_Application AAP ON ABP.componentNameId = AAP.backupset
		WHERE 1 = 1
        AND ABP.attrName = 'Edge Drive User Id'
        AND ABP.attrVal = CAST(@userId AS NVARCHAR(256))
        AND ABP.modified = 0
		)
		BEGIN
			SET @isDriveExist = 1
		END
		ELSE
		BEGIN
			declare @tempClientId int = 0
			INSERT INTO @edgeClientsWithCapabilities
			EXEC AppGetEdgeCapabilties @userId
				,NULL
			SET @tempClientId = ISNULL((
						SELECT TOP 1 EC.clientId
						FROM @edgeClientsWithCapabilities EC
						INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId
							AND EDA.entityType = 3
							AND EDA.entityId > 1
						WHERE capabilities & @capUploadBrowse = @capUploadBrowse -- Client with upload and browse capability
							--AND (@clientToUse = 0 OR EC.clientId = @clientToUse)
ORDER BY (EC.clientStatus & 0x40000000) DESC, EC.userAssociationType DESC
						), 0)
			IF (@tempClientId > 0)
			BEGIN
				SET @isDriveExist = 1
			END
			ELSE
			BEGIN
				SET @isDriveExist = 0
			END
		end
		if @isDriveExist=1
		begin
			insert into @permissionList
select 146
		end
	end
	-- Activation is needed when its a user centric client.
	-- If not user centric, if plan is there activation is needed. Else not needed.
	declare @activationNeeded int = 0
	if @userCentric=1 or @planId>0
	begin
		set @activationNeeded = 1
	end
	SET @xmlData = ( SELECT @userCentric '@userCentricFlag', @activationNeeded '@activationFlag',
                (
                    SELECT id as '@planId',
                    name as '@planName'
                    FROM App_PLAN
                    WHERE id = @planId
                    FOR XML PATH ('plan'),TYPE
                ),
                (
                    SELECT   UP.id AS '@permissionId',
                            UP.permissionName AS '@permissionName'
                        FROM   @permissionList permissions
                    INNER JOIN UMPermissions UP ON permissions.permissionId = UP.id
                    FOR XML PATH ('permissions'),TYPE
                )
                FOR XML PATH ('featureDetails'),TYPE)
end
set @i_xml = (select @token '@token',
	(select @userId '@userId', @userName '@userName' for xml path('user'),TYPE),
	(select @clientId '@clientId', @clientName '@clientName' for xml path('client'),TYPE),
	 @xmlData.query('.')
	for xml path('App_GetFeaturesListforClientResp'))
if @i_selectOut=1
begin
	select @i_xml
end
return
EXIT_ERROR:
set @i_xml = (
	select @errorCode '@errorCode', @errorMsg '@errorMessage'
	for xml path('errorResponse'),root('App_GetFeaturesListforClientResp')
)
if @i_selectOut=1
begin
	select @i_xml
end
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFeaturesListForClient')
	delete from GxQscripts where name = 'AppGetFeaturesListForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFeaturesListForClient')
	delete from GXDBVersions where aliasname = 'AppGetFeaturesListForClient'
GO

insert into GXDBVersions values(2, 'AppGetFeaturesListForClient',  '00010001000200120000', 'AppGetFeaturesListForClient', '00010001000200120000')
GO

