

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFastServerListXML.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetFastServerListXML
--  | Description: Wrapper for AppGetFastServerList
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFastServerListXML <<<'

IF EXISTS (select * from sysobjects where name='AppGetFastServerListXML')
	drop procedure AppGetFastServerListXML
IF EXISTS (select * from GxQscripts where name='AppGetFastServerListXML')
	delete from GxQscripts where name = 'AppGetFastServerListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerListXML')
	delete from GXDBVersions where aliasname = 'AppGetFastServerListXML'
GO
print '... Creating Procedure: AppGetFastServerListXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFastServerListXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
DECLARE @errorCode		AS INT          = 0
DECLARE @errorString	AS NVARCHAR(MAX) = N''
DECLARE @cloudId		AS INT = 0
BEGIN TRY
    SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                    FROM @i_xmlText.nodes ('App_GetFastServerListReq') R(ref)), 0)
DECLARE @FastServers TABLE (	  serverName	NVARCHAR(MAX)
								, clientId		INT
								, clientName	NVARCHAR(MAX)
								, cloudId		INT
								, hostName	NVARCHAR(MAX)
								, baseport	INT
								, version		VARCHAR(1024)
								, engineName	VARCHAR(1024)
								, serverType	INT DEFAULT 3 --App::CloudServerType_SearchEngine
							  )
	DECLARE @t_ServerList	TABLE( attrVal NVARCHAR(1024),
							   attrName NVARCHAR(1024),
							   clientId INT)
	INSERT INTO @t_ServerList
	SELECT DISTINCT CLP.attrVal , CLP.attrName, CLP.componentNameId
	FROM APP_ClientProp AS CLP (NOLOCK)
	INNER JOIN APP_Client C (NOLOCK) ON C.id = CLP.componentnameId
	WHERE ( ( CLP.attrName = 'FAST_QPS_URL' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_hostname' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_baseport' AND CLP.modified = 0 )
		)
AND  (C.status & 0x00002) = 0
		AND EXISTS ( SELECT componentnameId
				 FROM app_clientprop  (NOLOCK)
				 WHERE ( attrname = 'Content Index Server' OR attrname in ('PackageStateForId 257', 'PackageStateForId 261','PackageStateForId 260') )
					AND attrVal = '1'
					AND componentnameId = CLP.componentnameId)
	IF EXISTS (SELECT 1 FROM @t_ServerList)
	BEGIN
		INSERT INTO @t_ServerList
		SELECT DISTINCT CP.stringVal, 'FAST_Version', CLP.componentNameId
		FROM APP_ComponentProp CP (NOLOCK)
			INNER JOIN APP_ClientProp AS CLP (NOLOCK) ON CP.componentId = CLP.attrVal AND CLP.attrName = 'CLOUD_ID'
			INNER JOIN 	@t_ServerList ON CLP.componentNameId = clientId
WHERE (  CP.componentType = 2 AND CP.propertyTypeId = 1014 AND CP.modified = 0 	)
		INSERT INTO @t_ServerList
		SELECT CP.stringVal,'UNITY_NAME',CP.id * -1
FROM ( select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1023 ) UNITY_SERVER
			INNER JOIN APP_ComponentProp CP (NOLOCK) ON UNITY_SERVER.componentId = CP.id
		INSERT @FastServers	(serverName, clientId, clientName, cloudId, hostName, baseport, version, engineName)
		SELECT [FAST_QPS_URL] AS serverName ,
			   clientId,
			   clientName,
			   cloudId,
			   [FAST_hostname] AS hostName,
			   [FAST_baseport] AS baseport,
			   [FAST_Version] AS version,
			   (SELECT ISNULL(StringVal, '')  FROM APP_ComponentProp (NOLOCK)
						WHERE id = cloudId )AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId, dbo.APP_Client.net_hostname AS clientName, CAST(dbo.APP_ClientProp.attrVal AS INT) AS cloudId
			FROM @t_ServerList AS SL LEFT OUTER JOIN
			dbo.APP_Client (NOLOCK) ON dbo.APP_Client.id = Sl.clientId LEFT OUTER JOIN
			dbo.APP_ClientProp (NOLOCK) ON dbo.APP_ClientProp.componentNameId = SL.clientId AND dbo.app_clientprop.attrName = 'CLOUD_ID'
			WHERE SL.clientId > 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[FAST_hostname],[FAST_baseport], [FAST_Version] )
		) AS P
		UNION ALL
		SELECT [FAST_QPS_URL] AS serverName ,
			   0 AS clientId,
			   [UNITY_NAME] AS clientName,
			   -(clientId) AS cloudId,
			   '' AS hostName,
			   0 AS baseport,
			   '4.3' AS version,
			   '' AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId
			FROM @t_ServerList SL
			WHERE SL.clientId <= 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[UNITY_NAME])
		) AS Q
	END
	SET @o_xmlText =
	( SELECT (SELECT  serverName '@serverName'
					, clientId '@clientId'
					, clientName '@clientName'
					, cloudId '@cloudId'
					, hostName '@fastHostName'
					, baseport '@fastBasePort'
					, version '@version'
					, engineName '@engineName'
			FROM @FastServers FS where (@cloudId = 0 OR FS.cloudId = @cloudId)
			FOR XML PATH('fastServerList'), TYPE
			)
	  FOR XML  PATH('App_GetFastServerListResp'), TYPE )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode   = ERROR_NUMBER()
    SET @errorString  = N'Error Procedure [' + ISNULL(ERROR_PROCEDURE(), N'Custom Script') + N'], Error Line[' + CAST( ERROR_LINE() AS nVARCHAR(MAX)) + N'], Error Message [' + ERROR_MESSAGE() + N'].'
    SET @o_xmlText = ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
						FOR XML PATH('App_GetFastServerListResp'), TYPE )
END CATCH
IF @o_xmlText IS NULL
	SET @o_xmlText = '<App_GetFastServerListResp/>'
SELECT @o_xmlText AS [o_xmlText]
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFastServerListXML')
	delete from GxQscripts where name = 'AppGetFastServerListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerListXML')
	delete from GXDBVersions where aliasname = 'AppGetFastServerListXML'
GO

insert into GXDBVersions values(2, 'AppGetFastServerListXML',  '00000000000000000000', 'AppGetFastServerListXML', '00000000000000000000')
GO

