

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFastServerListForAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFastServerListForAppId.sp,v $ $Id: AppGetFastServerListForAppId.sp,v 1.8.12.6 2018/07/05 16:33:19 nshah Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the App ID information for the given job.
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFastServerListForAppId <<<'

IF EXISTS (select * from sysobjects where name='AppGetFastServerListForAppId')
	drop procedure AppGetFastServerListForAppId
IF EXISTS (select * from GxQscripts where name='AppGetFastServerListForAppId')
	delete from GxQscripts where name = 'AppGetFastServerListForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerListForAppId')
	delete from GXDBVersions where aliasname = 'AppGetFastServerListForAppId'
GO
print '... Creating Procedure: AppGetFastServerListForAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFastServerListForAppId
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
DECLARE @inAppId INT = 0
DECLARE @inArchFileId INT = 0
DECLARE @inArchCopyId INT = 0
SET @inAppId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
                    FROM @i_xmlText.nodes ('App_GetFastServerListForAppIdReq/entity') R(ref)), 0)
SET @inArchCopyId = ISNULL (( SELECT ref.value('@copyId', 'INT')
                    FROM @i_xmlText.nodes ('App_GetFastServerListForAppIdReq/copy') R(ref)), 0)
SET @inArchFileId = ISNULL (( SELECT ref.value('@archiveFileId', 'INT')
                    FROM @i_xmlText.nodes ('App_GetFastServerListForAppIdReq') R(ref)), 0)
DECLARE @o_xmlText XML
DECLARE @cloudIdTbl TABLE
( cloudId INT )
DECLARE @indexServerRoleName NVARCHAR(MAX) = (SELECT CASE ISNULL(CP.attrVal , 0)
														WHEN 4 THEN 'NFS Index'
														ELSE 'EDGE Drive'
													END
											  FROM APP_Application APP
											  LEFT OUTER JOIN APP_ClientProp CP ON CP.componentNameId = APP.clientId AND CP.attrName = 'System Drive Type'
											  WHERE APP.id = @inAppId)
INSERT INTO @cloudIdTbl
SELECT DM.CloudId
FROM DM2SearchServerCoreInfo DM
INNER JOIN DM2Cloud C ON DM.CloudId = C.cloudId
INNER JOIN DM2CloudCoreRole R ON DM.CloudId = R.CloudId
INNER JOIN DM2CloudRoleMaster RM ON RM.roleType = R.roleId AND RM.roleTypeName = @indexServerRoleName
WHERE C.pseudoClientId IN (SELECT entityId
						FROM App_EdgeDriveAssociation AE
						WHERE AE.entityType = 3 AND AE.clientId IN (SELECT ClientId
																		FROM APP_Application
																		WHERE id = @inAppId))
DECLARE @physicalOffset BIGINT
DECLARE @logicaOffset BIGINT
SELECT @physicalOffset = physicalSize, @logicaOffset = logicalSize
						FROM   archFileCopy WITH (NOLOCK)
						WHERE  archFileId = @inArchFileId
						AND CommCellId = 2 -- DEFAULT_COMM_CELL_ID
      AND archCopyId = @inArchCopyId
DECLARE @FastServers TABLE (	  serverName	NVARCHAR(MAX)
								, clientId		INT
								, clientName	NVARCHAR(MAX)
								, cloudId		INT
								, hostName	NVARCHAR(MAX)
								, baseport	INT
								, version		VARCHAR(1024)
								, engineName	VARCHAR(1024)
								, serverType	INT DEFAULT 3 --App::CloudServerType_SearchEngine
							  )
	DECLARE @t_ServerList	TABLE( attrVal NVARCHAR(1024),
							   attrName NVARCHAR(1024),
							   clientId INT)
	INSERT INTO @t_ServerList
	SELECT DISTINCT CLP.attrVal , CLP.attrName, CLP.componentNameId
	FROM APP_ClientProp AS CLP (NOLOCK)
	INNER JOIN APP_Client C (NOLOCK) ON C.id = CLP.componentnameId
	WHERE ( ( CLP.attrName = 'FAST_QPS_URL' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_hostname' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_baseport' AND CLP.modified = 0 )
		)
AND  (C.status & 0x00002) = 0
		AND EXISTS ( SELECT componentnameId
				 FROM app_clientprop  (NOLOCK)
				 WHERE ( attrname = 'Content Index Server' OR attrname in ('PackageStateForId 257', 'PackageStateForId 261','PackageStateForId 260') )
					AND attrVal = '1'
					AND componentnameId = CLP.componentnameId)
	IF EXISTS (SELECT 1 FROM @t_ServerList)
	BEGIN
		INSERT INTO @t_ServerList
		SELECT DISTINCT CP.stringVal, 'FAST_Version', CLP.componentNameId
		FROM APP_ComponentProp CP (NOLOCK)
			INNER JOIN APP_ClientProp AS CLP (NOLOCK) ON CP.componentId = CLP.attrVal AND CLP.attrName = 'CLOUD_ID'
			INNER JOIN 	@t_ServerList ON CLP.componentNameId = clientId
WHERE (  CP.componentType = 2 AND CP.propertyTypeId = 1014 AND CP.modified = 0 	)
		INSERT INTO @t_ServerList
		SELECT CP.stringVal,'UNITY_NAME',CP.id * -1
FROM ( select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1023 ) UNITY_SERVER
			INNER JOIN APP_ComponentProp CP (NOLOCK) ON UNITY_SERVER.componentId = CP.id
		INSERT @FastServers	(serverName, clientId, clientName, cloudId, hostName, baseport, version, engineName)
		SELECT [FAST_QPS_URL] AS serverName ,
			   clientId,
			   clientName,
			   cloudId,
			   [FAST_hostname] AS hostName,
			   [FAST_baseport] AS baseport,
			   [FAST_Version] AS version,
			   (SELECT ISNULL(StringVal, '')  FROM APP_ComponentProp (NOLOCK)
						WHERE id = cloudId )AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId, dbo.APP_Client.net_hostname AS clientName, CAST(dbo.APP_ClientProp.attrVal AS INT) AS cloudId
			FROM @t_ServerList AS SL LEFT OUTER JOIN
			dbo.APP_Client (NOLOCK) ON dbo.APP_Client.id = Sl.clientId LEFT OUTER JOIN
			dbo.APP_ClientProp (NOLOCK) ON dbo.APP_ClientProp.componentNameId = SL.clientId AND dbo.app_clientprop.attrName = 'CLOUD_ID'
			WHERE SL.clientId > 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[FAST_hostname],[FAST_baseport], [FAST_Version] )
		) AS P
		UNION ALL
		SELECT [FAST_QPS_URL] AS serverName ,
			   0 AS clientId,
			   [UNITY_NAME] AS clientName,
			   -(clientId) AS cloudId,
			   '' AS hostName,
			   0 AS baseport,
			   '4.3' AS version,
			   '' AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId
			FROM @t_ServerList SL
			WHERE SL.clientId <= 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[UNITY_NAME])
		) AS Q
	END
SET @o_xmlText =
	( SELECT @physicalOffset AS '@offset', @logicaOffset AS '@logicalOffset',
			(SELECT  serverName '@serverName'
					, FS.clientId '@clientId'
					, clientName '@clientName'
					, FS.cloudId '@cloudId'
					, hostName '@fastHostName'
					, baseport '@fastBasePort'
					, version '@version'
					, engineName '@engineName'
			FROM @cloudIdTbl CT
			INNER JOIN @FastServers FS ON CT.cloudId = FS.cloudId
			INNER JOIN DM2SearchServerCoreInfo DM ON FS.clientId = DM.ClientId
			WHERE DM.CoreRoles & 4 <> 0 -- CV_FC_SERVER_TYPE_ADMIN
			AND CT.cloudId >= 0
			FOR XML PATH('fastServerList'), TYPE
			)
	  FOR XML  PATH('App_GetFastServerListForAppIdResp'), TYPE )
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFastServerListForAppId')
	delete from GxQscripts where name = 'AppGetFastServerListForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerListForAppId')
	delete from GXDBVersions where aliasname = 'AppGetFastServerListForAppId'
GO

insert into GXDBVersions values(2, 'AppGetFastServerListForAppId',  '00010008001200060000', 'AppGetFastServerListForAppId', '00010008001200060000')
GO

