

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFastServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/05/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFastServerList.sp,v $ $Id: AppGetFastServerList.sp,v 1.19.2.7 2018/03/27 08:08:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFastServerList <<<'

IF EXISTS (select * from sysobjects where name='AppGetFastServerList')
	drop procedure AppGetFastServerList
IF EXISTS (select * from GxQscripts where name='AppGetFastServerList')
	delete from GxQscripts where name = 'AppGetFastServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerList')
	delete from GXDBVersions where aliasname = 'AppGetFastServerList'
GO
print '... Creating Procedure: AppGetFastServerList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetFastServerList
  @i_exchangeIndex integer = 0
AS
  DECLARE @o_serverName NVARCHAR(255)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_cloudId INT
  DECLARE @o_fastHostName NVARCHAR(255)
  DECLARE @o_fastBasePort INT
  DECLARE @o_version VARCHAR(1024)
  DECLARE @o_engineName VARCHAR(1024)
  DECLARE @o_serverType INT
BEGIN
	SET NOCOUNT ON
DECLARE @FastServers TABLE (	  serverName	NVARCHAR(MAX)
								, clientId		INT
								, clientName	NVARCHAR(MAX)
								, cloudId		INT
								, hostName	NVARCHAR(MAX)
								, baseport	INT
								, version		VARCHAR(1024)
								, engineName	VARCHAR(1024)
								, serverType	INT DEFAULT 3 --App::CloudServerType_SearchEngine
							  )
	DECLARE @t_ServerList	TABLE( attrVal NVARCHAR(1024),
							   attrName NVARCHAR(1024),
							   clientId INT)
	INSERT INTO @t_ServerList
	SELECT DISTINCT CLP.attrVal , CLP.attrName, CLP.componentNameId
	FROM APP_ClientProp AS CLP (NOLOCK)
	INNER JOIN APP_Client C (NOLOCK) ON C.id = CLP.componentnameId
	WHERE ( ( CLP.attrName = 'FAST_QPS_URL' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_hostname' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_baseport' AND CLP.modified = 0 )
		)
AND  (C.status & 0x00002) = 0
		AND EXISTS ( SELECT componentnameId
				 FROM app_clientprop  (NOLOCK)
				 WHERE ( attrname = 'Content Index Server' OR attrname in ('PackageStateForId 257', 'PackageStateForId 261','PackageStateForId 260') )
					AND attrVal = '1'
					AND componentnameId = CLP.componentnameId)
	IF EXISTS (SELECT 1 FROM @t_ServerList)
	BEGIN
		INSERT INTO @t_ServerList
		SELECT DISTINCT CP.stringVal, 'FAST_Version', CLP.componentNameId
		FROM APP_ComponentProp CP (NOLOCK)
			INNER JOIN APP_ClientProp AS CLP (NOLOCK) ON CP.componentId = CLP.attrVal AND CLP.attrName = 'CLOUD_ID'
			INNER JOIN 	@t_ServerList ON CLP.componentNameId = clientId
WHERE (  CP.componentType = 2 AND CP.propertyTypeId = 1014 AND CP.modified = 0 	)
		INSERT INTO @t_ServerList
		SELECT CP.stringVal,'UNITY_NAME',CP.id * -1
FROM ( select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1023 ) UNITY_SERVER
			INNER JOIN APP_ComponentProp CP (NOLOCK) ON UNITY_SERVER.componentId = CP.id
		INSERT @FastServers	(serverName, clientId, clientName, cloudId, hostName, baseport, version, engineName)
		SELECT [FAST_QPS_URL] AS serverName ,
			   clientId,
			   clientName,
			   cloudId,
			   [FAST_hostname] AS hostName,
			   [FAST_baseport] AS baseport,
			   [FAST_Version] AS version,
			   (SELECT ISNULL(StringVal, '')  FROM APP_ComponentProp (NOLOCK)
						WHERE id = cloudId )AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId, dbo.APP_Client.net_hostname AS clientName, CAST(dbo.APP_ClientProp.attrVal AS INT) AS cloudId
			FROM @t_ServerList AS SL LEFT OUTER JOIN
			dbo.APP_Client (NOLOCK) ON dbo.APP_Client.id = Sl.clientId LEFT OUTER JOIN
			dbo.APP_ClientProp (NOLOCK) ON dbo.APP_ClientProp.componentNameId = SL.clientId AND dbo.app_clientprop.attrName = 'CLOUD_ID'
			WHERE SL.clientId > 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[FAST_hostname],[FAST_baseport], [FAST_Version] )
		) AS P
		UNION ALL
		SELECT [FAST_QPS_URL] AS serverName ,
			   0 AS clientId,
			   [UNITY_NAME] AS clientName,
			   -(clientId) AS cloudId,
			   '' AS hostName,
			   0 AS baseport,
			   '4.3' AS version,
			   '' AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId
			FROM @t_ServerList SL
			WHERE SL.clientId <= 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[UNITY_NAME])
		) AS Q
	END
	--Temp table is created by QS_CommcellUsageReport. If it exists, populate temp table, else select statement as before
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCIEngineDataForLicCapacity'))
	BEGIN
	INSERT INTO #tmpCIEngineDataForLicCapacity
	SELECT  serverName
			, clientId
			, clientName
			, cloudId
			, hostName
			, baseport
			, version
			, engineName
			, serverType
	FROM @FastServers
	ORDER BY engineName
	END
	ELSE
	BEGIN
	IF @i_exchangeIndex = 1
	begin
		INSERT @FastServers
		SELECT 'http://' + REPLACE(name, ' ' , ''), 0, REPLACE(name, ' ' , ''), cloudId, '', 0, 'Solr 1.0', name, CloudType
		FROM DM2CLOUD WITH (NOLOCK)
WHERE (flags & 2) > 0 OR (flags & 4) > 0 OR (flags & 8) > 0
	end
	--get all VIRTUAL CLOUDIds
	DECLARE @virtualCLouds TABLE (t_vitrualCloudId int, t_serverUrl nvarchar(2048))
	INSERT INTO @virtualCLouds
	SELECT componentid , N''
	FROM APP_ComponentProp WITH (NOLOCK)
WHERE propertytypeid = 1001 AND componentType =2 AND stringval = 'virtual'
	--returns list of all nodes of virtual clouds
	IF EXISTS (SELECT 1 FROM @virtualCLouds)
	BEGIN
		DECLARE @virtualToPhysicalCloud TABLE (t_vitrualCloudId int, t_CloudId int, t_virtualCloudname NVARCHAR(2048))
		INSERT INTO @virtualToPhysicalCloud
		SELECT t_vitrualCloudId, longval, ''
		FROM APP_ComponentProp WITH (NOLOCK)
			INNER JOIN @virtualCLouds ON componentid = t_vitrualCloudId
WHERE propertytypeid = 1010 AND componentType =2
		IF EXISTS (SELECT 1 FROM @virtualToPhysicalCloud)
		BEGIN
			UPDATE @virtualToPhysicalCloud
			SET t_virtualCloudname = stringval
			FROM APP_ComponentProp WITH (NOLOCK)
WHERE  id = t_vitrualCloudId AND propertytypeid = 1 AND componentType = 1
			INSERT INTO @FastServers
			SELECT serverName,	clientId, clientName, t_vitrualCloudId, hostname, baseport, version, t_virtualCloudname, serverType
			FROM @FastServers INNER JOIN @virtualToPhysicalCloud ON cloudId = t_CloudId
			--servername  =NULL if more than one cloud is selected
			IF EXISTS (SELECT 1 FROM @FastServers WHERE LEN(serverName) > 0 GROUP BY cloudId HAVING COUNT(serverName) >1 )
			BEGIN
				UPDATE @virtualCLouds
				SET t_serverUrl = (SELECT TOP 1 serverName FROM @FastServers WHERE CloudId = t_vitrualCloudId AND LEN (serverName) > 0)
				UPDATE @FastServers
				SET servername = NULL
				FROM @virtualCLouds
				WHERE  CloudId = t_vitrualCloudId AND serverName != t_serverUrl AND LEN (serverName) > 0
			END
		END
	END
		SELECT  serverName
			, clientId
			, clientName
			, cloudId
			, hostName
			, baseport
			, version
			, engineName
			, serverType
		FROM @FastServers
		ORDER BY engineName, serverName DESC
	END
	SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetFastServerList')
	delete from GxQscripts where name = 'AppGetFastServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFastServerList')
	delete from GXDBVersions where aliasname = 'AppGetFastServerList'
GO

insert into GXDBVersions values(2, 'AppGetFastServerList',  '00010019000200070000', 'AppGetFastServerList', '00010019000200070000')
GO

