

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFailedJobOccuranceListForMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: AppGetFailedJobOccuranceListForMA
--        Returns occurance of failed job for given mediaAgent Id, daysToConsider and jobTypes
--
--		  input: 1. Media Agent Id
--				 2. daysToConsider
--				 3. jobTypes
--                  (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--
--        output: past days data to analyze
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetFailedJobOccuranceListForMA <<<'

IF EXISTS (select * from sysobjects where name='AppGetFailedJobOccuranceListForMA')
	drop procedure AppGetFailedJobOccuranceListForMA
IF EXISTS (select * from GxQscripts where name='AppGetFailedJobOccuranceListForMA')
	delete from GxQscripts where name = 'AppGetFailedJobOccuranceListForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailedJobOccuranceListForMA')
	delete from GXDBVersions where aliasname = 'AppGetFailedJobOccuranceListForMA'
GO
print '... Creating Procedure: AppGetFailedJobOccuranceListForMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetFailedJobOccuranceListForMA
  @mediaAgentId INT,
  @daysToConsider INT = 90,
  @jobTypes INT = 15
AS
  DECLARE @occurance INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @currentDate INT = ((@time / @secondsInDay) - 1) * @secondsInDay
	DECLARE @LastBackupRunDay INT = (SELECT (@time - MIN(servStartDate)) / @secondsInDay FROM JMBkpStats)
	DECLARE @minimumDaysForData INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MInimumDaysForDataInFailedJobAnomaly' and modified=0),30)
	IF @LastBackupRunDay < @minimumDaysForData
		RETURN;
	IF @LastBackupRunDay < @daysToConsider
		SET @daysToConsider = @LastBackupRunDay
	DECLARE @startDate INT = @currentDate - (@secondsInDay * (@daysToConsider-1))
	DECLARE @Dates TABLE ( day INT )
	DECLARE @count INT = 0
	WHILE @count < @daysToConsider
	BEGIN
		INSERT INTO @Dates VALUES ( @startDate + (@count * @secondsInDay))
		SET @count = @count + 1
	END
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
	CREATE TABLE #jobTable
	(
	    jobId INT,
		failedDate INT
	)
IF @jobTypes & 1 <> 0 OR @jobTypes & 8 <> 0
		INSERT INTO #jobTable
			SELECT
			JM.jobID, (servEndDate / @secondsInDay) * @secondsInDay
			FROM JMBkpStats JM WITH (NOLOCK)
			INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId AND JRH.clientId = @mediaAgentId
			WHERE  JM.servEndDate > @startDate AND status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
IF @jobTypes & 2 <> 0
		INSERT INTO #jobTable
			SELECT
			JM.jobId, (servEndTime / @secondsInDay) * @secondsInDay
			FROM JMRestoreStats JM WITH (NOLOCK)
			INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId AND JRH.clientId = @mediaAgentId
			WHERE  JM.servEndTime > @startDate AND status IN (2,3,4,14,15)
IF @jobTypes & 4 <> 0
		INSERT INTO #jobTable
			SELECT
			JM.jobId, (servEnd / @secondsInDay) * @secondsInDay
			FROM JMAdminJobStatsTable JM WITH (NOLOCK)
			INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId AND JRH.clientId = @mediaAgentId
			WHERE JM.servEnd > @startDate AND status IN (2,3,4,14,15)
	SELECT
	COUNT(jobId) AS occurance
	FROM #jobTable HD
	RIGHT OUTER JOIN @Dates DT ON HD.failedDate = DT.day
	GROUP BY DT.day
	ORDER BY DT.day
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFailedJobOccuranceListForMA')
	delete from GxQscripts where name = 'AppGetFailedJobOccuranceListForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailedJobOccuranceListForMA')
	delete from GXDBVersions where aliasname = 'AppGetFailedJobOccuranceListForMA'
GO

insert into GXDBVersions values(2, 'AppGetFailedJobOccuranceListForMA',  '00000000000000000000', 'AppGetFailedJobOccuranceListForMA', '00000000000000000000')
GO

