

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFailedJobOccuranceListForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: AppGetFailedJobOccuranceListForClients
--        Returns occurance of failed job for given clientId, daysToConsider and jobTypes
--
--		  input: 1. clientId
--				 2. daysToConsider
--				 3. jobTypes
--                  (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--
--        output: past days data to analyze
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFailedJobOccuranceListForClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFailedJobOccuranceListForClients <<<'
	drop procedure AppGetFailedJobOccuranceListForClients
END
IF EXISTS (select * from GxQscripts where name='AppGetFailedJobOccuranceListForClients')
	delete from GxQscripts where name = 'AppGetFailedJobOccuranceListForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailedJobOccuranceListForClients')
	delete from GXDBVersions where aliasname = 'AppGetFailedJobOccuranceListForClients'
GO
print '... Creating Procedure: AppGetFailedJobOccuranceListForClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetFailedJobOccuranceListForClients
  @clientId INT,
  @daysToConsider INT = 90,
  @jobTypes INT = 15
AS
  DECLARE @occurance INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @currentDate INT = ((@time / @secondsInDay) - 1) * @secondsInDay
	DECLARE @LastBackupRunDay INT = (SELECT (@time - MIN(servStartDate)) / @secondsInDay FROM JMBkpStats)
	DECLARE @minimumDaysForData INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MInimumDaysForDataInFailedJobAnomaly' and modified=0),30)
	IF @LastBackupRunDay < @minimumDaysForData
		RETURN;
	IF @LastBackupRunDay < @daysToConsider
		SET @daysToConsider = @LastBackupRunDay
	DECLARE @startDate INT = @currentDate - (@secondsInDay * (@daysToConsider-1))
	DECLARE @Dates TABLE ( day INT )
	DECLARE @count INT = 0
	WHILE @count < @daysToConsider
	BEGIN
		INSERT INTO @Dates VALUES ( @startDate + (@count * @secondsInDay))
		SET @count = @count + 1
	END
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
	CREATE TABLE #jobTable
	(
	    count INT,
		failedDate INT
	)
IF @jobTypes & 1 <> 0 OR @jobTypes & 8 <> 0
	INSERT INTO #jobTable
		SELECT
		COUNT(jobId), (servEndDate / @secondsInDay) * @secondsInDay
		FROM JMBkpStats JM WITH (NOLOCK)
		INNER JOIN APP_Application  APP WITH (NOLOCK) ON JM.appID = APP.id AND clientId = @clientId
		WHERE  JM.servEndDate > @startDate AND status IN (2,3,4,14,15)
		GROUP BY (servEndDate / @secondsInDay) * @secondsInDay
IF @jobTypes & 2 <> 0
	INSERT INTO #jobTable
		SELECT
		COUNT(jobId), (servEndTime / @secondsInDay) * @secondsInDay
		FROM JMRestoreStats JM WITH (NOLOCK)
		WHERE JM.servEndTime > @startDate AND status IN (2,3,4,14,15) AND srcClientId = @clientId
		GROUP BY (servEndTime / @secondsInDay) * @secondsInDay
IF @jobTypes & 4 <> 0
	INSERT INTO #jobTable
		SELECT
		COUNT(jobId), (servEnd / @secondsInDay) * @secondsInDay
		FROM JMAdminJobStatsTable JM WITH (NOLOCK)
		INNER JOIN APP_Application APP WITH (NOLOCK) ON JM.appID = APP.id AND clientId = @clientId
		WHERE JM.servEnd > @startDate AND status IN (2,3,4,14,15)
		GROUP BY (servEnd / @secondsInDay) * @secondsInDay
	SELECT
	ISNULL(SUM(count), 0) AS occurance
	FROM #jobTable HD
	RIGHT OUTER JOIN @Dates DT ON HD.failedDate = DT.day
	GROUP BY DT.day
	ORDER BY DT.day
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFailedJobOccuranceListForClients')
	delete from GxQscripts where name = 'AppGetFailedJobOccuranceListForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailedJobOccuranceListForClients')
	delete from GXDBVersions where aliasname = 'AppGetFailedJobOccuranceListForClients'
GO

insert into GXDBVersions values(2, 'AppGetFailedJobOccuranceListForClients',  '00000000000000000000', 'AppGetFailedJobOccuranceListForClients', '00000000000000000000')
GO

