

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFailbackVServerInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFailbackVServerInfo.sp,v $ $Id: AppGetFailbackVServerInfo.sp,v 1.1.2.15.16.2 2021/03/28 08:11:06 spedditi Exp $";
--  +========================================================================+
--  | Stored Proc:  AppGetFailbackVServerInfo()
--  |
--  | Description:
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetFailbackVServerInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFailbackVServerInfo <<<'
	drop procedure AppGetFailbackVServerInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetFailbackVServerInfo')
	delete from GxQscripts where name = 'AppGetFailbackVServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailbackVServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetFailbackVServerInfo'
GO
print '... Creating Procedure: AppGetFailbackVServerInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetFailbackVServerInfo
  @i_xmlText XML
AS
  DECLARE @r_ReturnResult xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
DECLARE @i_replId integer
DECLARE @i_operationType integer
DECLARE @subclientId integer = 0
DECLARE @instance integer = 0
DECLARE @taskId integer = 0
DECLARE @subtaskId integer = 0
declare @in_xml XML
declare @out_xml XML
DECLARE @vserver NVARCHAR(MAX) = N''
DECLARE @userName NVARCHAR(MAX) = N''
DECLARE @userPassword NVARCHAR(MAX) = N''
DECLARE @instanceType NVARCHAR(MAX) = N''
DECLARE @datacenter NVARCHAR(MAX) = N''
DECLARE @errorCode integer = 0
DECLARE @destClient integer = 0
DECLARE @credAssocId  INT = 0
SET @i_replId = ISNULL ( ( SELECT R.ref.value('@replicationId', 'integer') FROM @i_xmlText.nodes ( '/App_GetFailbackVServerInfoReq' ) R ( ref ) ), 0 )
SET @i_operationType = ISNULL ( ( SELECT R.ref.value('@operationType', 'integer') FROM @i_xmlText.nodes ( '/App_GetFailbackVServerInfoReq' ) R ( ref ) ), 0 )
 IF @i_operationType = 1 --OperationType 1 means get source vcenter credentials
 BEGIN
	SELECT TOP 1  @subclientId = subclientID FROM app_vsareplication WHERE replicationId = @i_replId
	SELECT TOP 1  @subclientId = JMJobDataLink.parentAppid FROM JMJobDataLink (NOLOCK)
		INNER JOIN App_Application (NOLOCK) ON @subclientId = JMJobDataLink.childAppid
		AND JMJobDataLink.parentAppid = App_Application.id
		AND linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
	SELECT TOP 1 @instance = instance FROM APP_Application WHERE id = @subclientId
	SELECT @vserver = attrVal FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server Host'
	SET @credAssocId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @instance AND attrName = 'Virtual Server Credential Assoc Id' and modified=0),0)
	IF @credAssocId > 0
	BEGIN
		-- Update user name and password
		EXEC GetCredentialsFromCredentialAssocIds @credAssocId, @userName OUTPUT, @userPassword OUTPUT
	END
	ELSE
	BEGIN
		SELECT @userName = attrVal FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server User'
		SELECT @userPassword = dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server Password'
	END
END
declare @policyID int
declare @vcClientId int
IF @i_operationType = 2 --OperationType 2 means get destination vcenter credentials
BEGIN
	SELECT TOP 1 @taskId = taskId FROM app_vsareplication WHERE replicationId = @i_replId
	SELECT TOP 1 @subtaskId = subtaskId FROM TM_SubTask WHERE taskId = @taskId
	SELECT @in_xml = xmlValue FROM TM_SubTaskxmlOptions WHERE subTaskId = @subtaskId
	IF  @in_xml.exist('//TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy') =1
		AND @in_xml.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int') >0
	BEGIN
	    select @policyID = @in_xml.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int')
		select @vcClientId = attrval  from App_VmAllocationPolicyprop where componentNameId = @policyID and attrName ='destinationHyperV' and modified=0
	    select @instance = instance from app_application where clientid = @vcClientId and appTypeId=106
	END
	ELSE
	BEGIN
		SET @instance = ISNULL ( ( SELECT R.ref.value('@instanceId', 'integer') FROM @in_xml.nodes ( '/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance' ) R ( ref ) ), 0 )
	END
	--Destination client
	SELECT @destClient = ISNULL ( ( SELECT R.ref.value('@clientId', 'integer') FROM @in_xml.nodes ( '/TMMsg_JobOption/restoreOptions/destination/destClient' ) R ( ref ) ), 0 )
	SELECT @vserver = attrVal FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server Host'
	SET @credAssocId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_InstanceProp WITH(nolock) WHERE componentNameId = @instance AND attrName = 'Virtual Server Credential Assoc Id' and modified=0),0)
	IF @credAssocId > 0
	BEGIN
		-- Update user name and password
		EXEC GetCredentialsFromCredentialAssocIds @credAssocId, @userName OUTPUT, @userPassword OUTPUT
	END
	ELSE
	BEGIN
		SELECT @userName = attrVal FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server User'
		SELECT @userPassword = dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server Password'
	END
END
--username/password is stored in different property for differen vendors.
--Get instance entity type and get its own fields.
SELECT @instanceType = attrVal FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Virtual Server Instance Type'
if @instanceType = '301' --AWS
BEGIN
	SELECT @userPassword = dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp where componentNameId=@instance AND attrName = 'Amazon Center Secret Key'
	SELECT @userName = dbo.pswConvertV5ToV3(attrVal) FROM APP_InstanceProp WHERE componentNameId=@instance AND attrName='Amazon Center Access Key'
	IF  @in_xml.exist('//TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@datacenter') = 1
	BEGIN
		SELECT @datacenter = @in_xml.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@datacenter)[1]','nvarchar(max)')
	END
END
else if @instanceType = '402'  -- Azure resource manager
BEGIN
	SELECT @vserver = attrval FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Azure Subscription Id'
	SELECT @vserver = CONCAT(@vserver, '\', attrval) FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Azure Tenant Id'
END
else if @instanceType = '403'  -- Azure Stack
BEGIN
	--{1}?SubscriptionId={2}&TenantId={3}
	--https:--management.local.azurestack.external?SubscriptionId=d10ebced-90eb-4107-bc85-64ffaed0df42&TenantId=2c0cbffc-a32f-40a4-85c1-ded3536acc94
	SELECT @vserver = attrval FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Virtual Server Host' AND modified = 0
	SELECT @vserver = CONCAT(@vserver, '?SubscriptionId=')
	SELECT @vserver = CONCAT(@vserver, attrval) FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Azure Subscription Id' AND modified = 0
	SELECT @vserver = CONCAT(@vserver, '&TenantId=')
	SELECT @vserver = CONCAT(@vserver, attrval) FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Azure Tenant Id' AND modified = 0
END
else if @instanceType = '102' AND @destClient != 0    -- Hyper-v destination server
BEGIN
	-- Get Hyper-vhost name
	SELECT @vserver = net_hostname FROM APP_Client(NOLOCK) WHERE id = @destClient
END
else if @instanceType = '1301' --Google Cloud
BEGIN
	SELECT @userName = attrVal FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Virtual Server User' AND modified = 0
	SELECT @userName = CONCAT(@userName, '|')
	SELECT @userName = CONCAT(@userName, attrval) FROM APP_InstanceProp(NOLOCK) WHERE componentNameId=@instance AND attrName='Google Cloud Account Id' AND modified = 0
END
SET @out_xml = (SELECT
		@errorCode AS '@errorCode',
        @vserver AS '@serverName',
		@datacenter AS '@datacenterName',
		@userName     AS '@userName',
        @userPassword AS '@password',
		@instance AS '@instanceId'
FOR XML PATH ( 'App_GetFailbackVServerInfoResp' ))
SELECT	@out_xml
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFailbackVServerInfo')
	delete from GxQscripts where name = 'AppGetFailbackVServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFailbackVServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetFailbackVServerInfo'
GO

insert into GXDBVersions values(2, 'AppGetFailbackVServerInfo',  'v1.1.2.15.16.2', 'AppGetFailbackVServerInfo', 'v1.1.2.15.16.2')
GO

