

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFWPushClientList.sp] ---------- 

   --  +========================================================================+
   --  | Name:  AppGetFWPushClientList
   --  | Description:
   --  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFWPushClientList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFWPushClientList <<<'
	drop procedure AppGetFWPushClientList
END
IF EXISTS (select * from GxQscripts where name='AppGetFWPushClientList')
	delete from GxQscripts where name = 'AppGetFWPushClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFWPushClientList')
	delete from GXDBVersions where aliasname = 'AppGetFWPushClientList'
GO
print '... Creating Procedure: AppGetFWPushClientList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFWPushClientList
  @i_clientGroupId int
AS
  DECLARE @o_clientId int
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientTbl TABLE(clientId INT PRIMARY KEY)
INSERT INTO @clientTbl
SELECT FW.clientId
FROM APP_Firewall FW
WHERE FW.forClientGroupId = @i_clientGroupId AND FW.flag & 4 <> 4
UNION
SELECT CG.clientId
FROM APP_Firewall FW INNER JOIN
APP_ClientGroupAssoc CG ON CG.clientGroupId = FW.clientGroupId AND FW.flag & 4 <> 4
WHERE FW.forClientGroupId = @i_clientGroupId
UNION
SELECT FW.forClientId
FROM APP_Firewall FW
WHERE FW.clientGroupId = @i_clientGroupId AND FW.flag & 4 <> 4
UNION
SELECT CG.clientId
FROM APP_Firewall FW INNER JOIN
APP_ClientGroupAssoc CG ON CG.clientGroupId = FW.forClientGroupId AND FW.flag & 4 <> 4
WHERE FW.clientGroupId = @i_clientGroupId
UNION
SELECT FW.clientId
FROM App_FWOutGoingRoutes FW
WHERE FW.forClientGroupId = @i_clientGroupId AND FW.flag & 4 <> 4
UNION
SELECT CG.clientId
FROM App_FWOutGoingRoutes FW INNER JOIN
APP_ClientGroupAssoc CG ON CG.clientGroupId = FW.clientGroupId AND FW.flag & 4 <> 4
WHERE FW.forClientGroupId = @i_clientGroupId
UNION
SELECT FW.forClientId
FROM App_FWOutGoingRoutes FW
WHERE FW.clientGroupId = @i_clientGroupId AND FW.flag & 4 <> 4
UNION
SELECT CG.clientId
FROM App_FWOutGoingRoutes FW INNER JOIN
APP_ClientGroupAssoc CG ON CG.clientGroupId = FW.forClientGroupId AND FW.flag & 4 <> 4
WHERE FW.clientGroupId = @i_clientGroupId
SELECT DISTINCT FW.clientId
FROM @clientTbl FW
INNER JOIN APP_Platform AP ON AP.clientId = FW.clientId AND AP.platformType in (1,2)
UNION
SELECT DISTINCT FW.clientId
FROM @clientTbl FW
INNER JOIN App_FirewallOptions O ON FW.clientId = O.clientId AND O.isDMZ = 1 AND O.flag & 4 <> 4 -- Currently only clients can be proxies hence need to consider only them
UNION
-- Push the configuration for proxies when cascading topology is configured as proxies require firewall configuration about the new client that is added
SELECT distinct ACGA.clientId
FROM App_FWOutGoingRoutes FW with (READUNCOMMITTED)
INNER JOIN APP_ClientGroupAssoc CGAssoc WITH (READUNCOMMITTED) ON (CGAssoc.clientGroupId = FW.clientGroupId or CGAssoc.clientGroupId = FW.forClientGroupId) AND CGAssoc.clientGroupId=@i_clientGroupId
INNER JOIN APP_FirewallTopologyAssoc TPAssoc WITH (READUNCOMMITTED)  ON CGAssoc.clientGroupId = TPAssoc.groupId
INNER JOIN APP_FirewallTopology TP WITH (READUNCOMMITTED) ON TPAssoc.topologyId = TP.topologyId
CROSS APPLY FW.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') AS dx(c)
INNER JOIN APP_ClientGroup ACG WITH (READUNCOMMITTED) ON ACG.id = dx.c.value('@clientGroupId', 'integer')
INNER JOIN APP_ClientGroupAssoc ACGA WITH (READUNCOMMITTED) on ACG.id = ACGA.clientGroupId
where TP.topologyType = 4
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFWPushClientList')
	delete from GxQscripts where name = 'AppGetFWPushClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFWPushClientList')
	delete from GXDBVersions where aliasname = 'AppGetFWPushClientList'
GO

insert into GXDBVersions values(2, 'AppGetFWPushClientList',  '00000000000000000000', 'AppGetFWPushClientList', '00000000000000000000')
GO

