

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFSAppTypeByClientId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFSAppTypeByClientId.sp,v $ $Id: AppGetFSAppTypeByClientId.sp,v 1.1.2.2 2020/04/30 07:36:03 manojg Exp $";
--
--  +========================================================================+
--  |      Cursor:  AppGetFSAppTypeByClientId()
--  +========================================================================+
--
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFSAppTypeByClientId')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFSAppTypeByClientId <<<'
	drop procedure AppGetFSAppTypeByClientId
END
IF EXISTS (select * from GxQscripts where name='AppGetFSAppTypeByClientId')
	delete from GxQscripts where name = 'AppGetFSAppTypeByClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFSAppTypeByClientId')
	delete from GXDBVersions where aliasname = 'AppGetFSAppTypeByClientId'
GO
print '... Creating Procedure: AppGetFSAppTypeByClientId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFSAppTypeByClientId
  @i_clientId INTEGER,
  @i_appVersion INTEGER = 0,
  @i_bGetMultiAppTypes INTEGER = 0,
  @i_appTypeId INTEGER = 0
AS
  DECLARE @o_appType INTEGER
  DECLARE @o_licType INTEGER
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @packageId INT
DECLARE @osId INT
DECLARE @AppTypes TABLE(AppType INT, licType INT)
DECLARE @Package TABLE(packageId INT)
SELECT @packageId = MIN(simPackageID) FROM simInstalledPackages WHERE ClientId = @i_clientId AND simPackageID IN (1, 1002)
SELECT @osId = simOperatingSystemId FROM APP_Client WHERE id = @i_clientId
IF @packageId IS NULL AND @i_appTypeId <> 0
BEGIN
INSERT INTO @Package
EXEC SimGetPackageIDFromAppType @i_appTypeId, @osid
SELECT TOP 1 @packageId = packageId FROM @Package
END
IF @packageId IS NOT NULL AND @osId IS NOT NULL
BEGIN
	INSERT INTO @AppTypes
	EXEC SimGetAppTypeLicTypeByPackageId @packageId, @osId, @i_appVersion, @i_bGetMultiAppTypes
END
SELECT DISTINCT AppType, licType FROM @AppTypes
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFSAppTypeByClientId')
	delete from GxQscripts where name = 'AppGetFSAppTypeByClientId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFSAppTypeByClientId')
	delete from GXDBVersions where aliasname = 'AppGetFSAppTypeByClientId'
GO

insert into GXDBVersions values(2, 'AppGetFSAppTypeByClientId',  '00010001000200020000', 'AppGetFSAppTypeByClientId', '00010001000200020000')
GO

