

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFLAServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/05/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetFLAServerList.sp,v $ $Id: AppGetFLAServerList.sp,v 1.16.2.9 2019/10/27 22:02:15 sgolla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
IF NOT EXISTS (SELECT * FROM systypes where name = 'Identifiers')
BEGIN
CREATE TYPE Identifiers AS TABLE(
    nID int NOT NULL
)
END;;
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFLAServerList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFLAServerList <<<'
	drop procedure AppGetFLAServerList
END
IF EXISTS (select * from GxQscripts where name='AppGetFLAServerList')
	delete from GxQscripts where name = 'AppGetFLAServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFLAServerList')
	delete from GXDBVersions where aliasname = 'AppGetFLAServerList'
GO
print '... Creating Procedure: AppGetFLAServerList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetFLAServerList
  @i_clientIdTbl AS dbo.Identifiers READONLY,
  @i_flaRequest INT = 0
AS
  DECLARE @o_serverName NVARCHAR(255)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_cloudId INT
  DECLARE @o_fastHostName NVARCHAR(255)
  DECLARE @o_fastBasePort INT
  DECLARE @o_version VARCHAR(1024)
  DECLARE @o_engineName VARCHAR(1024)
BEGIN
	SET NOCOUNT ON
	IF object_id('tempdb.dbo.#subClientList') IS NOT null DROP TABLE #subClientList
	CREATE TABLE #subClientList	 (
									t_appId		INT,
									t_clientId		INT
								  )
	IF object_id('tempdb.dbo.#clientCloudList') IS NOT null DROP TABLE #clientCloudList
	CREATE TABLE #clientCloudList (
									t_cloudId		INT,
									t_clientId		INT,
									t_cloudClientId		INT
							        )
	IF object_id('tempdb.dbo.#clientList') IS NOT null DROP TABLE #clientList
	CREATE TABLE #clientList	 (
									t_cId		INT
								  )
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
            CREATE TABLE #getIndexServers
                (     serverURL NVARCHAR(512),
                        clientId INT,
                        clientName NVARCHAR(256),
                        cloudId INT,
                        hostName NVARCHAR(256),
                        basePort INT,
                        engineName  NVARCHAR(256),
                        serverType INT,
                        indexServerClientId INT,
                        internalCloudName NVARCHAR(256)
                )
	--get all clients
	--for cloud setup, clientidlist is empty
	IF NOT EXISTS (SELECT TOP 1 1 FROM @i_clientIdTbl)
		INSERT INTO #clientList
		SELECT id from APP_Client C (NOLOCK)
WHERE C.specialClientFlags & 0x2 =0
	ELSE
		INSERT INTO #clientList
		SELECT DISTINCT nID FROM @i_clientIdTbl
	--get all subclients which are associated with <clientLists>
	INSERT INTO #subClientList
    SELECT id, clientId
    from APP_Application WITH (READUNCOMMITTED), #clientList C
    where clientId =C.t_cId
	--Get index server details with data analytics role
EXEC DM2GetIndexServers 'Data Analytics'
	--VSA support
	INSERT INTO #clientCloudList
	SELECT DISTINCT S.CloudId, C.t_cId, S.ClientId
	FROM #clientList C, APP_ClientProp CP WITH (READUNCOMMITTED), #getIndexServers S
	WHERE C.t_cId= CP.componentNameId AND  CP.modified=0 AND CP.attrName='AnalyticsCloudId' AND S.CloudId=CAST(CP.attrVal AS INT)
	AND EXISTS (SELECT 1 FROM APP_CLIENTPROP CP WITH (READUNCOMMITTED) WHERE CP.AttrVal = '1' AND  CP.modified=0 AND CP.attrName='AnalysisComplete')
	--vsa clients are already considererd, so delete it if any (in case of workflow)
	DELETE FROM #subClientList
	WHERE t_clientId IN (SELECT t_clientId FROM #clientCloudList)
	--get all analytics servers where analytics job are run for these subclients
	INSERT INTO #clientCloudList
	SELECT DISTINCT S.cloudid,  SC.t_clientId, S.ClientId
	FROM archFile  AF (NOLOCK)
	JOIN archFLAIndexingInfo F (NOLOCK) ON AF.id = F.archFileId
	JOIN #getIndexServers S ON F.cloudId = S.CloudId
	JOIN #subClientList SC ON AF.appId =SC.t_appId
	WHERE (F.flags & 64)>0
	DROP TABLE #subClientList
	SELECT DISTINCT	serverURL + ( CASE WHEN  @i_flaRequest = 0  THEN '/solr/cvcorefla'+ cast(c.t_clientId %8 as varchar(100)) ELSE '/solr/cvcorestats' END) as 'serverName'
			, clientId
			, clientName
			, cloudId
			, hostName
			, baseport
			, 'Analytics 1.0' as 'version'
			, engineName
	FROM #getIndexServers s
		JOIN #clientCloudList c on s.cloudId =c.t_cloudId
	DROP TABLE #clientCloudList
	DROP TABLE #getIndexServers
	SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetFLAServerList')
	delete from GxQscripts where name = 'AppGetFLAServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFLAServerList')
	delete from GXDBVersions where aliasname = 'AppGetFLAServerList'
GO

insert into GXDBVersions values(2, 'AppGetFLAServerList',  '00010016000200090000', 'AppGetFLAServerList', '00010016000200090000')
GO

