

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetFBRMAList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetFBRMAList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetFBRMAList <<<'
	drop procedure AppGetFBRMAList
END
IF EXISTS (select * from GxQscripts where name='AppGetFBRMAList')
	delete from GxQscripts where name = 'AppGetFBRMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFBRMAList')
	delete from GXDBVersions where aliasname = 'AppGetFBRMAList'
GO
print '... Creating Procedure: AppGetFBRMAList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetFBRMAList
  @xmlText XML 
AS
DECLARE @osType         INTEGER = 2
DECLARE @osStr varchar(20)
DECLARE @MediaAgentList TABLE ( mediaAgentId int)
DECLARE @userId INTEGER =0
SET @osType     =  ISNULL( @xmlText.value('(/App_GetFBRMAList/@osType)[1]', 'int' ) ,0)
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetFBRMAList/processinginstructioninfo/user') R ( ref )),0)
-- SELECT ALL CLIENTS WITH PROP SET and is MA
INSERT INTO @MediaAgentList
select distinct componentNameId
from
APP_ClientProp CProp,
APP_Platform P
where CProp.attrName = 'FBR MediaAgent' and CProp.attrVal = '1'
and P.platformType = 2 and P.clientId = componentNameId
-- CLIENT_PLATFORM_OSTYPE_WINDOWS
IF @osType = 1
	SET @osStr = 'WINDOWS'
ELSE IF @osType = 2
	SET @osStr = 'UNIX'
ELSE
	SET @osStr = '' -- SELECT ALL MA WITH PROP SET
-- DELETE THOSE WHOSE OSID DOES NOT MATCH
IF @osStr <> ''
BEGIN
	DELETE @MediaAgentList where mediaAgentId in (
	SELECT C.id FROM APP_Client C, @MediaAgentList MA
	WHERE MA.mediaAgentId = C.id
	and C.simOperatingSystemId not in
	(select id from simOperatingSystem where Type = @osStr ))
END
--	#define ENTITY_TYPE_CLIENT_ENTITY	3
--	#define ENTITY_TYPE_MEDIAAGENT_ENTITY	11
IF @userId > 0
BEGIN
	DECLARE @disableUseProxy INT = 0
	SET @disableUseProxy = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
	IF @disableUseProxy != 1
	BEGIN
		CREATE TABLE #getIdaObjectsOutput
		(
			clientId INT,
			appTypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT
		)
EXEC sec_getIdaObjectsForUser @userId, 3, 0, 0, '#getIdaObjectsOutput', 1, '252, 2'
		SET @xmlText = (SELECT @osType as '@osType',
					 (select DISTINCT C.id as '@mediaAgentId',
									  C.name as '@mediaAgentName',
									  --MEDIAAGENT_ENTITY
									 11 as '@_type_'
									FROM @MediaAgentList temp,App_Client C, #getIdaObjectsOutput sec
									where C.id = temp.mediaAgentId and
								    (C.id = sec.clientId)
								FOR XML PATH('mediaAgentList'),TYPE)
						FOR XML PATH('App_GetFBRMAList'),TYPE)
	END
	ELSE --Old behaviour
	BEGIN
		IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 0, 0, '#tempUserObjects'
		delete #tempUserObjects
		WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
		  OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR taskId <> 0
		  OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
		  OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
		  OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
		  OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
		SET @xmlText = (SELECT @osType as '@osType',
					 (select DISTINCT C.id as '@mediaAgentId',
									  C.name as '@mediaAgentName',
									  --MEDIAAGENT_ENTITY
									 11 as '@_type_'
									FROM @MediaAgentList temp,App_Client C, #tempUserObjects sec
									where C.id = temp.mediaAgentId and
(C.id = sec.clientId or sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
								FOR XML PATH('mediaAgentList'),TYPE)
						FOR XML PATH('App_GetFBRMAList'),TYPE)
		DROP TABLE #tempUserObjects
	END
END
ELSE
BEGIN
SET @xmlText = (SELECT @osType as '@osType',
				 (select DISTINCT C.id as '@mediaAgentId',
								  C.name as '@mediaAgentName',
								  --MEDIAAGENT_ENTITY
								 11 as '@_type_'
								FROM @MediaAgentList temp,App_Client C
								where C.id = temp.mediaAgentId
							FOR XML PATH('mediaAgentList'),TYPE)
					FOR XML PATH('App_GetFBRMAList'),TYPE)
END
SELECT @xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetFBRMAList')
	delete from GxQscripts where name = 'AppGetFBRMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetFBRMAList')
	delete from GXDBVersions where aliasname = 'AppGetFBRMAList'
GO

insert into GXDBVersions values(2, 'AppGetFBRMAList',  '00000000000000000000', 'AppGetFBRMAList', '00000000000000000000')
GO

