

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExtensionsForPreview.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExtensionsForPreview.sp,v $ $Id: AppGetExtensionsForPreview.sp,v 1.1.2.3 2020/03/04 16:33:09 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetExtensionsForPreview()
--  |
--  | Description:  SP to get extensions supprted by preview
--  |
--  |       Input:  GetExtensionsForPreviewRequest XML
--  |
--  |      Output:  GetExtensionsForPreviewResponse containing extensions
--  |      Return:  errorCode
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	Get extensions supprted by preview
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetExtensionsForPreview')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExtensionsForPreview <<<'
	drop procedure AppGetExtensionsForPreview
END
IF EXISTS (select * from GxQscripts where name='AppGetExtensionsForPreview')
	delete from GxQscripts where name = 'AppGetExtensionsForPreview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExtensionsForPreview')
	delete from GXDBVersions where aliasname = 'AppGetExtensionsForPreview'
GO
print '... Creating Procedure: AppGetExtensionsForPreview'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExtensionsForPreview
  @i_xml XML	
AS
BEGIN TRY
		SELECT
		(
			SELECT
			(
					SELECT
						ext as '@val'
					FROM
					(
						SELECT
							extension as 'ext'
						FROM
							App_FileTypeAndExtensions(NOLOCK)
							WHERE typeName IN ('Image', 'Office')
						UNION
								--Special extensions that we should allowed for preview
						SELECT
							ext
						FROM
						(
								VALUES
								('*.rtf\/\/'),
								('*.txt\/\/'),
								('*.log\/\/'),
								('*.xml\/\/'),
								('*.htm\/\/'),
								('*.html\/\/')
						) AS SPE(ext)
					)AS PreviewExtensions
					FOR XML PATH('extension'), TYPE
			)
			FOR xml PATH('Api_GetExtensionsForPreviewResponse')
		)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT
	(
		SELECT
		ERROR_NUMBER() '@errorCode',
		'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
		FOR XML PATH('error'), TYPE
	)
	FOR XML PATH('Api_GetExtensionsForPreviewResponse'), TYPE
END  CATCH

IF EXISTS (select * from GxQscripts where name = 'AppGetExtensionsForPreview')
	delete from GxQscripts where name = 'AppGetExtensionsForPreview'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExtensionsForPreview')
	delete from GXDBVersions where aliasname = 'AppGetExtensionsForPreview'
GO

insert into GXDBVersions values(2, 'AppGetExtensionsForPreview',  '00010001000200030000', 'AppGetExtensionsForPreview', '00010001000200030000')
GO

