

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExpiredSPClientList.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetExpiredSPClientList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExpiredSPClientList <<<'
	drop procedure AppGetExpiredSPClientList
END
IF EXISTS (select * from GxQscripts where name='AppGetExpiredSPClientList')
	delete from GxQscripts where name = 'AppGetExpiredSPClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExpiredSPClientList')
	delete from GXDBVersions where aliasname = 'AppGetExpiredSPClientList'
GO
print '... Creating Procedure: AppGetExpiredSPClientList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetExpiredSPClientList
  @days INT = 30
AS
BEGIN
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @version11SetupId INT = 16
DECLARE @spVersionInfoString VARCHAR(30) = 'SP Version Info'
DECLARE @unixtimeStampStartTime VARCHAR(50) = '1970-01-01 00:00:00'
IF EXISTS (SELECT * FROM gxglobalParam
	                WHERE name  = 'bCheckClientsForServicePackExpiry' AND value = 'true' AND modified = 0)
BEGIN
      SELECT client.name,clientProp.attrVal , dbo.AppGetExpiryInfoForSP(max(installedPackages.HighestSP), max(client.releaseId))
FROM APP_Client as client
INNER JOIN APP_ClientProp as clientProp ON client.id = clientProp.componentNameId
INNER JOIN simInstalledPackages as installedPackages ON client.id = installedPackages.ClientId
WHERE client.releaseId = @version11SetupId AND clientProp.attrName = @spVersionInfoString
GROUP BY client.name, client.id, clientProp.attrVal
HAVING   (DATEDIFF(day, DATEADD(second, dbo.AppGetExpiryInfoForSP(max(installedPackages.HighestSP), max(client.releaseId)), @unixtimeStampStartTime), DATEADD(day, @days, GETUTCDATE())) >= 0)
END
ELSE -- If "bCheckClientsForServicePackExpiry" key not set true then, checking only CS for servicePack expiry
BEGIN
     SELECT client.name,clientProp.attrVal , dbo.AppGetExpiryInfoForSP(max(installedPackages.HighestSP), max(client.releaseId))
FROM APP_Client as client
INNER JOIN APP_ClientProp as clientProp ON client.id=2 and client.id = clientProp.componentNameId
INNER JOIN simInstalledPackages as installedPackages ON client.id = installedPackages.ClientId
WHERE client.releaseId = @version11SetupId AND clientProp.attrName = @spVersionInfoString
GROUP BY client.name, client.id, clientProp.attrVal
HAVING   (DATEDIFF(day, DATEADD(second, dbo.AppGetExpiryInfoForSP(max(installedPackages.HighestSP), max(client.releaseId)), @unixtimeStampStartTime), DATEADD(day, @days, GETUTCDATE())) >= 0)
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExpiredSPClientList')
	delete from GxQscripts where name = 'AppGetExpiredSPClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExpiredSPClientList')
	delete from GXDBVersions where aliasname = 'AppGetExpiredSPClientList'
GO

insert into GXDBVersions values(2, 'AppGetExpiredSPClientList',  '00000000000000000000', 'AppGetExpiredSPClientList', '00000000000000000000')
GO

