

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchangeServiceProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetExchangeServiceProperties()
--  |
--  | Description:  For a given client id , return the service properties like autodiscover url, adminAccount details
--  |
--  |       Input:  client id
--  |      Output:  App_ExchangeOnePassIdaProp XML ( .x)
--  |
--  |
--  +================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetExchangeServiceProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExchangeServiceProperties <<<'
	drop procedure AppGetExchangeServiceProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetExchangeServiceProperties')
	delete from GxQscripts where name = 'AppGetExchangeServiceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeServiceProperties')
	delete from GXDBVersions where aliasname = 'AppGetExchangeServiceProperties'
GO
print '... Creating Procedure: AppGetExchangeServiceProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExchangeServiceProperties
  @i_clientId INTEGER
AS
  DECLARE @componentId INTEGER
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @componentId = (SELECT TOP 1 id FROM APP_IDAName where clientId = @i_clientId and appTypeId = 137 )
DECLARE @exchangeOnePassProperties TABLE (
                                            id int              IDENTITY(1,1) PRIMARY KEY,
                                            accounts            XML,
                                            url nvarchar(max),
											cloudRegion	INT,
											azureAppList            XML
                                            )
        INSERT @exchangeOnePassProperties VALUES(NULL, N'', 0, N'')
		UPDATE @exchangeOnePassProperties
			SET accounts =
			 (SELECT (
                SELECT po.query('.')
                FROM
                (
                    SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
                    FROM APP_IDAProp
					WHERE componentNameId = @componentId AND attrName=N'Exchange OnePass Admin Accounts' and modified = 0
                ) PROP
                CROSS APPLY PROP.attrVal.nodes('./App_ExchangeAdminAccounts/adminAccounts') P(po)
                FOR XML PATH(''),TYPE))
        --ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
        UPDATE @exchangeOnePassProperties
            SET accounts = '<App_ExchangeAdminAccounts></App_ExchangeAdminAccounts>'
        WHERE accounts IS NULL
		UPDATE @exchangeOnePassProperties
            SET url = (SELECT attrval from APP_IDAProp WHERE componentNameId = @componentId AND attrName=N'Exchange OnePass AutoDiscover URL' and modified = 0 )
		--Default Value for the MSCloudRegion is 1 (DEFAULT Cloud)
		UPDATE @exchangeOnePassProperties
            SET cloudRegion = ISNULL((SELECT attrVal from APP_IDAProp WHERE componentNameId = @componentId and attrName = N'MSCloud Region Type' and modified = 0 ),1)
		UPDATE @exchangeOnePassProperties
			SET azureAppList =
			 (SELECT (
                SELECT po.query('.')
                FROM
                (
                    SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
                    FROM APP_IDAProp
					WHERE componentNameId = @componentId AND attrName=N'Exchange Azure Connections' and modified = 0
                ) PROP
                CROSS APPLY PROP.attrVal.nodes('./App_Office365AzureConnections/azureApps') P(po)
                FOR XML PATH(''),TYPE))
		--ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
        UPDATE @exchangeOnePassProperties
            SET azureAppList = '<App_Office365AzureConnections></App_Office365AzureConnections>'
        WHERE accounts IS NULL
		--select the output as xml
		SELECT
			url '@autoDiscoverURL',
			cloudRegion '@cloudRegion',
			accounts,
			azureAppList
			FROM @exchangeOnePassProperties
		FOR XML PATH('onePassProp'),
		ROOT('App_ExchangeOnePassProperties')
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExchangeServiceProperties')
	delete from GxQscripts where name = 'AppGetExchangeServiceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeServiceProperties')
	delete from GXDBVersions where aliasname = 'AppGetExchangeServiceProperties'
GO

insert into GXDBVersions values(2, 'AppGetExchangeServiceProperties',  '00000000000000000000', 'AppGetExchangeServiceProperties', '00000000000000000000')
GO

