

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchangeMailboxHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExchangeMailboxHistory.sp,v $ $Id: AppGetExchangeMailboxHistory.sp,v 1.8.274.2 2018/03/27 08:04:48 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetExchangeMailboxHistory"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetExchangeMailboxHistory <<<'

IF EXISTS (select * from sysobjects where name='AppGetExchangeMailboxHistory')
	drop procedure AppGetExchangeMailboxHistory
IF EXISTS (select * from GxQscripts where name='AppGetExchangeMailboxHistory')
	delete from GxQscripts where name = 'AppGetExchangeMailboxHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeMailboxHistory')
	delete from GXDBVersions where aliasname = 'AppGetExchangeMailboxHistory'
GO
print '... Creating Procedure: AppGetExchangeMailboxHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetExchangeMailboxHistory
  @_mailboxName nvarchar(1024),
  @_backupSetId integer,
  @_fromTime integer,
  @_endTime integer
AS
  DECLARE @o_mailboxId integer
  DECLARE @o_bsetId integer
  DECLARE @o_fromTime integer
  DECLARE @o_endTime integer
  DECLARE @o_mailboxName nvarchar(1024)
  DECLARE @o_mailboxGUID nvarchar(1024)
declare     @prefix						nvarchar(12)
declare     @seper						nchar(1)
Declare @l_DisplayName nvarchar(512)           -- THESE ARE THE (3) THINGS WE ARE TRYING TO SEPERATE OUT
Declare @l_AliasName   nvarchar(512)
Declare @l_smtpName    nvarchar(512)
Declare @l_GUID		   nvarchar(512)
Declare @start      int
Declare @index      int
Declare @currentMailboxId int
Declare @subClientId int
Declare @nowTime int
Set @nowTime = dbo.GetUnixTime (GetUTCdate())
SET NOCOUNT ON
set  @prefix = '\MB\'
set  @seper = char(18)
   IF object_id('tempdb.dbo.#mailBoxHistory') is not null DROP TABLE #mailBoxHistory
   create table  #mailBoxHistory
   (
      mailBoxId		int	NOT null,
      backupSetId	int NOT null,
      subClientId   int NOT null,
      fromTime		integer,
      endTime		integer,
      propType		integer,
      displayName	nvarchar(512),
      aliasName		nvarchar(512),
      smtpName		nvarchar(512),
      mailboxGUID	nvarchar(1024),
    )
--------------------------------------------------------
--  PARSE THE MAILBOX NAME TO GIVE US SEARCH CRITERIA --
--------------------------------------------------------
--select top 1 id FROM app_subClientProp WHERE attrType = 111 AND attrName = @_mailboxName ORDER BY id desc
--		GOTO RETURN_RESULTS
set @currentMailboxId = ISNULL((select TOP 1 id FROM app_subClientProp WHERE attrType = 111 AND attrName = @_mailboxName order by id desc), 0)
set @l_GUID           = ISNULL((select stringVal from APP_ComponentProp
WHERE componentType = 7						-- 'CV_COMPONENT_TYPE_EXMB'
AND PropertyTypeId = 1103		--'CV_COMPONENT_EXMB_GUID'
                                    AND componentId = @currentMailboxId), '')
----------------------------------
-- For Backwards compatability, --
-- We need smtp name to do      --
-- search on too                --
----------------------------------
set @start = Len(@prefix)+1                                                    --DISPLAY NAME--
set @index = (select charindex(@seper, @_mailboxName, @start))
set @l_DisplayName = subString(@_mailboxName, @start, @index-@start)
set @start = @index+1                                                         --ALIAS NAME--
set @index = (select charindex(@seper, @_mailboxName, @start))
set @l_AliasName = subString(@_mailboxName, @start, @index-@start)
set @start = @index+1                                                         --SMTP NAME--
set @l_smtpName  = ISNULL(subString(@_mailboxName, @start, LEN(@_mailboxName)-@start+1), '')
-- select debug = 'start', mailboxName=@_mailboxName, currentMailboxId= @currentMailboxId, l_GUID = @l_GUID, l_smtpName= @l_smtpName, nowTime = @nowTime
------------------------------------------------------
-- IF WE DIDN'T GET A GUID, NO REASON TO GO FURTHER --
------------------------------------------------------
IF @l_GUID = '' AND @l_smtpName = ''
BEGIN
	INSERT #mailBoxHistory VALUES ( 0,0,0,0,0,0, 'No GUID or SMTP For MailBox:', @_mailboxName, '', @l_GUID)
		GOTO RETURN_RESULTS
END
--------------------------
-- Find all the 'Parts' --
--------------------------
IF @L_GUID <> ''
BEGIN
	INSERT INTO #mailBoxHistory
SELECT DISTINCT componentId, 0, 0, 0, 0, 1103, '', '', '', stringVal				--'CV_COMPONENT_EXMB_GUID'
	FROM    APP_ComponentProp
	WHERE
componentType = 	7				-- 'CV_COMPONENT_TYPE_EXMB'
AND (PropertyTypeId = 1103 AND stringVal = @l_GUID)   -- 'CV_COMPONENT_EXMB_GUID'
END
IF @l_smtpName <> ''
BEGIN
	INSERT INTO #mailBoxHistory
SELECT DISTINCT componentId, 0, 0, 0, 0, 1100,  '', '', '', stringVal			-- 'CV_COMPONENT_EXMB_MAILBOX'
	FROM    APP_ComponentProp
	WHERE
componentType = 	7				-- 'CV_COMPONENT_TYPE_EXMB'
AND (PropertyTypeId = 1100 AND stringVal = @l_smtpName)				-- 'CV_COMPONENT_EXMB_MAILBOX'
			AND NOT EXISTS (Select * from #mailBoxHistory WHERE componentId = mailboxId)
END
-- select debug='debug', * from #mailBoxHistory
UPDATE #mailBoxHistory
Set fromTime = created, endTime = modified
FROM #mailBoxHistory as MBH, app_subclientProp as SCP
WHERE mailboxId = id
----------------------------------
-- PRUNE BASED ON BACKUPSETID  ---
----------------------------------
UPDATE #mailBoxHistory
SET subClientId = ISNULL((select componentNameId from APP_subclientProp WHERE id=mailboxId),0)
UPDATE #mailBoxHistory
Set backupSetId = ISNULL((select top 1 backupset FROM APP_Application Where APP_Application.id = subClientId),0)
IF @_backupSetId <> 0
   DELETE #mailBoxHistory
      WHERE backupSetId <> @_backupSetId
DELETE FROM #mailBoxHistory WHERE subClientId=0 or backupSetId=0   --APP_ComponentProp NOT GETTING CLEANED UP?
----------------------------------
-- !NOW! FILL IN MISSING FIELDS --
----------------------------------
UPDATE #mailBoxHistory
SET displayName = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  7						--'CV_COMPONENT_TYPE_EXMB'
AND PropertyTypeId = 1102	--'CV_COMPONENT_EXMB_DISPLAYNAME'
                        AND componentId = mailboxId), '')
WHere displayName = ''
UPDATE #mailBoxHistory
SET aliasName = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  7						--'CV_COMPONENT_TYPE_EXMB'
AND PropertyTypeId = 1101	--'CV_COMPONENT_EXMB_ALIASNAME'
                        AND componentId = mailboxId), '')
WHere aliasName = ''
UPDATE #mailBoxHistory
SET smtpName = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  7						--'CV_COMPONENT_TYPE_EXMB'
AND PropertyTypeId = 1100 --'CV_COMPONENT_EXMB_MAILBOX'
                        AND componentId = mailboxId), '')
WHere smtpName = ''
UPDATE #mailBoxHistory
SET mailboxGUID = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  7						--'CV_COMPONENT_TYPE_EXMB'
AND PropertyTypeId = 1103 --'CV_COMPONENT_EXMB_GUID'
                        AND componentId = mailboxId), '')
WHere mailboxGUID = ''
------------------------------
-- RETURN RESULTS TO CALLER --
------------------------------
RETURN_RESULTS:
--	select DISTINCT
--	       mailBoxId,
--		   backupSetId,
--		   fromTime,
--		   endTime,
--		 (select attrName from app_subClientProp where id = mailBoxId),
--		   mailBoxGUID
--	FROM  #mailBoxHistory
select DISTINCT
	       0,
		   backupSetId,
		   fromTime,
		   endTime,
		 (select attrName from app_subClientProp where id = mailBoxId),
		   0
	FROM  #mailBoxHistory
	ORDER BY backupSetId, fromTime desc
DROP TABLE #mailBoxHistory
SET NOCOUNT OFF
GO
/*
exec  AppGetExchangeMailboxHistory
			'\MB\test1test1test1@CI.commvault.com',
              0,
              0,
              0
*/

IF EXISTS (select * from GxQscripts where name = 'AppGetExchangeMailboxHistory')
	delete from GxQscripts where name = 'AppGetExchangeMailboxHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeMailboxHistory')
	delete from GXDBVersions where aliasname = 'AppGetExchangeMailboxHistory'
GO

insert into GXDBVersions values(2, 'AppGetExchangeMailboxHistory',  '00010008027400020000', 'AppGetExchangeMailboxHistory', '00010008027400020000')
GO

