

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchangeIdxRetentionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExchangeIdxRetentionInfo.sp,v $ $Id: AppGetExchangeIdxRetentionInfo.sp,v 1.1.2.22.14.1 2021/03/22 15:13:11 jraju Exp $";
-- =================================================================
-- Author:		Jaya Rama Raju Inavolu
-- Description:	Get the retention information for given IndexServer.
-- =================================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetExchangeIdxRetentionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExchangeIdxRetentionInfo <<<'
	drop procedure AppGetExchangeIdxRetentionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetExchangeIdxRetentionInfo')
	delete from GxQscripts where name = 'AppGetExchangeIdxRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeIdxRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetExchangeIdxRetentionInfo'
GO
print '... Creating Procedure: AppGetExchangeIdxRetentionInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetExchangeIdxRetentionInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @reqType INT
DECLARE @inIndexServerId INT
DECLARE @inPseudoClient	INT
DECLARE @retentionPolicyId INT
DECLARE @count INT
DECLARE @inAssocId INT
DECLARE @inCoreId	INT
DECLARE @inSubclientId INT = 0
DECLARE @skipDataAgingCheck INT = 0
DECLARE @wsMangledHostName NVARCHAR(1024) = ''
DECLARE @mailboxGUID	VARCHAR(64) = ''
DECLARE @assocIdTbl	TABLE
(
	assocId			int,
	displayName		nvarchar(512),
	aliasName		nvarchar(512),
	smtpAddress		nvarchar(512),
	userGuid		varchar(40),
	coreId			int,
	isActiveMailbox	int
)
IF OBJECT_ID('tempdb.dbo.#deletedMbxTbl') IS NOT NULL
	DROP TABLE #deletedMbxTbl
CREATE TABLE  #deletedMbxTbl
(
	userGuid		varchar(64),
	modified		integer
)
CREATE INDEX userGuid_idx ON #deletedMbxTbl(userGuid)
SET @reqType			= ISNULL( (SELECT ref.value('@requestType', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq') R(ref)), 0)
SET @inIndexServerId	= ISNULL( (SELECT ref.value('@clientId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq/idxServer') R(ref)), 0)
SET @inPseudoClient		= ISNULL( (SELECT ref.value('@clientId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq/client') R(ref)), 0)
SET @retentionPolicyId	= ISNULL( (SELECT ref.value('@policyId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq/policy') R(ref)), 0)
SET @count				= ISNULL( (SELECT ref.value('@count', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq') R(ref)), 200000) -- Default all users(2 lakhs)
SET @inAssocId			= ISNULL( (SELECT ref.value('@assocId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq') R(ref)), 0)
SET @inCoreId			= ISNULL( (SELECT ref.value('@coreId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq') R(ref)), -1)
SET @skipDataAgingCheck = ISNULL( (SELECT ref.value('@skipDataAgingCheck', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq') R(ref)), 0)
SET @inSubclientId		= ISNULL( (SELECT ref.value('@subclientId', 'int') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq/subclient') R(ref)), 0)
SET @mailboxGUID		= ISNULL( (SELECT ref.value('@GUID', 'varchar(46)') FROM @i_xmlText.nodes('Api_GetExchangeIdxRetentionInfoReq/user') R(ref)), 0)
IF @reqType != 4 -- ExchangeIdxRetentionReqType.WEBSERVER_INFO
BEGIN
	-- Check if data aging is disabled at CC level. If yes, just return empty response
	IF dbo.JMIsOpTypeEnabled(10 /* Data Aging */, 1 /* COMMCELL_ENTITY */, default, default) = 0 -- commcell level
	BEGIN
		GOTO PROC_END
	END
END
IF @inIndexServerId > 0
BEGIN
	DECLARE @webServerClientId	INT = 0
	DECLARE @clientName			NVARCHAR(MAX) = ''
	DECLARE @hostName			NVARCHAR(MAX) = ''
	DECLARE @portNum			NVARCHAR(MAX) = ''
	DECLARE @webServerAlias		NVARCHAR(MAX) = ''
	DECLARE @outWebServerUrl	NVARCHAR(MAX) = ''
	DECLARE @webServerHttpSecure	NVARCHAR(MAX) = ''
IF EXISTS(SELECT 1 from simInstalledPackages WHERE SimPackageId = 252 AND clientId = @inIndexServerId)
		SET @webServerClientId = @inIndexServerId
	ELSE
		Exec @webServerClientId = AppGetWebSearchServerClientId @inPseudoClient, 1, 0/*i_proxyClientId*/
	IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id= @webServerClientId)
	BEGIN
		GOTO PROC_END
	END
	SELECT @hostName = net_hostname, @clientName = name
	FROM APP_Client
	WHERE id = @webServerClientId
	SET @outWebServerUrl = dbo.AppFetchWebServiceURL(@webServerClientId, 1, 0) + '/'
	SET @wsMangledHostName = dbo.GetClientMangledHostName(@webServerClientId, NULL)
END
IF @reqType IN (2, 3)
BEGIN
	DECLARE @scTable TABLE
	(
		subclientId	   int
		PRIMARY KEY(subclientId)
	)
	IF @inSubclientId > 0
		INSERT INTO @scTable VALUES(@inSubclientId)
	ELSE
		INSERT INTO @scTable
		SELECT id FROM APP_Application Where clientId = @inPseudoClient
	-- Active mailboxes
	INSERT INTO @assocIdTbl
	SELECT conf.assocId, conf.displayName, conf.aliasName, conf.smtpAdrress, conf.userGUid, conf.coreId, 1/*Active Mailbox*/
	From
	APP_EmailConfigPolicyAssoc conf,
	APP_EmailConfigPolicies conf1
	WHERE
	conf.subclientId IN (SELECT subclientId FROM @scTable) AND
	(
	conf.mailBoxType IN (1,2,3) /*Ida.x->MailboxType*/
	OR conf.discoverByType = 12 /*Public folder mailbox*/
	) AND
	conf.assocId > @inAssocId AND
	conf.assocId = conf1.componentNameId AND
	conf1.policyId = @retentionPolicyId AND
	conf.modified = 0 AND
	conf1.modified = 0
	INSERT INTO #deletedMbxTbl
	SELECT userGuid, MAX(modified)as modified from APP_EmailConfigPolicyAssoc A, @scTable B
	WHERE
	A.subClientId = B.subclientId AND
	A.mailBoxType IN (1,2,3)
	GROUP BY A.userGuid
	HAVING MIN(A.modified) ! = 0
	-- Inactive mailboxes
	INSERT INTO @assocIdTbl
	SELECT allMbx.assocId, allMbx.displayName, allMbx.aliasName, allMbx.smtpAdrress, allMbx.userGuid, allMbx.coreId, 0/*Inactive mailbox*/
	FROM APP_EmailConfigPolicyAssoc allMbx,
	APP_EmailConfigPolicies policy,
	@scTable sc,
	[#deletedMbxTbl] deletedMbx
	WHERE
	allMbx.assocId > @inAssocId AND
	allMbx.subclientId = sc.subclientId AND
	allMbx.mailBoxType IN(1,2,3) AND
	allMbx.userGuid = deletedMbx.userGuid AND
	allMbx.modified = deletedMbx.modified AND
	allMbx.assocId = policy.componentNameId AND
	policy.policyId = @retentionPolicyId AND
	policy.modified = 0
END
IF @reqType = 0 -- IndexServer to list of pseudo clients
BEGIN
	SET @o_xmlText =	(
							SELECT
							(
								SELECT
								DISTINCT conf.clientId AS '@clientId',
								cli.name AS '@clientName',
3 as '@_type_'
								FROM APP_EmailConfigPolicyAssoc conf, App_Client cli
								WHERE conf.clientId IN (SELECT DISTINCT clientId FROM App_IdaName WHERE id IN(SELECT componentNameId FROM App_IdaProp WHERE attrname = 'OnePass Index Server' AND modified = 0 AND attrVal = CAST(@inIndexServerId as NVARCHAR(12))))
								AND conf.clientId = cli.id
								AND conf.modified = 0
								AND (
									@skipDataAgingCheck = 1 OR
									conf.clientId NOT IN
									(
										-- Exclude client with Data Aging disabled at the Client/Client group level.
										SELECT DISTINCT clientId
										FROM JMJobAction
										WHERE opType = 10 -- Data Aging
										AND clientId != 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0 AND instanceID = 1  -- Clients disabled dataaging
										AND action = 1 -- Disabled
										UNION
										SELECT DISTINCT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId IN(
										SELECT DISTINCT clientGroupId
										FROM JMJobAction
										WHERE opType = 10 -- Data Aging
										AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId != 0 AND instanceID = 1 -- ClientGroup disabled dataging.
										AND action = 1 -- Disabled
										)
									)
								)
								FOR XML PATH('entities'), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType in( 1,6) -- Psuedo clients to list of retention policies
BEGIN
	SET @o_xmlText =	(
							SELECT
							(
								SELECT
								DISTINCT policy.policyId AS '@policyId',
								policy.policyName AS '@policyName',
154 as '@_type_'
								FROM APP_EmailConfigPolicyAssoc conf, APP_EmailConfigPolicies conf1, APP_ConfigurationPolicy policy
								WHERE conf.backupsetId IN (SELECT backupset FROM App_Application WHERE clientId = @inPseudoClient)
								AND conf.assocId = conf1.componentNameId
								AND ( (@reqType = 1 AND conf1.policyType = 3) OR (@reqType=6 AND conf1.policyType in (1,4) ) )
								AND conf1.policyId = policy.policyId
								AND conf1.modified = 0
								AND ( @inSubclientId = 0 OR conf.subClientId = @inSubclientId)
								FOR XML PATH('entities'), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType = 2 -- Virtual Client, Retention Policy to List of cores
BEGIN
	SET @o_xmlText =	(
							SELECT
							(
								SELECT
								DISTINCT coreId AS 'cores'
								FROM @assocIdTbl
								FOR XML PATH(''), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType = 3 -- Retention Policy, cores to users.
BEGIN
	DECLARE @lastAssocId		INT = 0
	DECLARE @hasMore			INT = 0
	DECLARE @policyDetail		XML
	DECLARE @subclientId	int
	DECLARE @subclientName	nvarchar(256)
	DELETE FROM @assocIdTbl	WHERE coreId != @inCoreId
	IF (ISNULL( (SELECT count(*) FROM @assocIdTbl), 0) > @count)
		SET @hasMore = 1
	DELETE FROM @assocIdTbl WHERE assocId NOT IN(SELECT TOP(@count) assocId FROM @assocIdTbl order by assocId)
	SET @policyDetail = (SELECT policyDetails FROM APP_ConfigurationPolicyDetails WHERE componentNameId = @retentionPolicyId AND modified = 0)
	SET @lastAssocId  = ISNULL( (SELECT max(assocId) FROM @assocIdTbl), 0)
	SET @subclientId  = (SELECT subclientId FROM APP_EmailConfigPolicyAssoc WHERE assocId IN(SELECT top 1 assocId FROM @assocIdTbl))
	SET @subclientName = (SELECT top 1 subclientName FROM APP_Application WHERE id = @subclientId)
	SET @o_xmlText =	(
							SELECT
							@outWebServerUrl AS '@webServerURL',
							@lastAssocId AS '@lastAssocId',
							@hasMore AS '@hasMore',
@wsMangledHostName AS '@webServerMangledHostName',
							(
								SELECT
									@clientName AS '@clientName',
3 as '@_type_'
								FOR XML PATH ('webServer'), TYPE
							),
							(
								SELECT
									@policyDetail AS 'policy',
									(
										SELECT
											@subclientId AS '@subclientId',
											@subclientName AS '@subclientName',
7 as '@_type_'
										FOR XML PATH ('subclient'), TYPE
									),
									(
										SELECT
										(
											SELECT
											(
												SELECT
												conf.displayName AS '@displayName',
												conf.aliasName AS '@aliasName',
												conf.smtpAddress AS '@smtpAddress',
												conf.assocId AS '@assocId',
												conf.coreId AS '@coreId',
												conf.isActiveMailbox AS '@isActiveMailbox',
												(
													SELECT
														conf.userGUid AS '@userGUID',
13 as '@_type_'
													FOR XML PATH ('user'), TYPE
												)
												FOR XML PATH('userInfo'), TYPE
											)
										From
										@assocIdTbl conf
										FOR XML PATH(''), TYPE
										)
									)
									FOR XML PATH('retentionInfo'), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType = 4 -- ExchangeIdxRetentionReqType.WEBSERVER_INFO
BEGIN
	SET @outWebServerUrl += 'CVWebService.svc'
	SET @o_xmlText =	(
							SELECT
							@outWebServerUrl AS '@webServerURL',
@wsMangledHostName AS '@webServerMangledHostName',
							(
								SELECT
									@clientName AS '@clientName',
3 as '@_type_'
								FOR XML PATH ('webServer'), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType = 5 -- ExchangeIdxRetentionReqType.SUBCLIENT_LIST
BEGIN
	SET @outWebServerUrl += 'CVWebService.svc'
	SET @o_xmlText =	(
							SELECT
							@outWebServerUrl AS '@webServerURL',
@wsMangledHostName AS '@webServerMangledHostName',
							(
								SELECT
									@clientName AS '@clientName',
3 as '@_type_'
								FOR XML PATH ('webServer'), TYPE
							),
							(
								SELECT A.subClientId AS '@subclientId',
									   A.backupsetId AS '@backupSetId',
									   C.GUID AS '@backupSetGUID',
									   B.attrval AS '@backupSetType'
								FROM
								(SELECT distinct subclientId, backupsetId FROM APP_EmailConfigPolicyAssoc Where clientId = @inPseudoClient AND modified = 0) A, App_backupSetProp B, App_BackupsetName C
								WHERE A.backupsetId = B.componentNameId And B.attrName = 'Exchange OnePass BackupSet Type' and B.modified = 0
								AND C.id = A.backupsetId
								FOR XML PATH('scInfo'), TYPE
							)
							FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
						)
END
ELSE IF @reqType = 7 -- Mailbox's associated retention policy
BEGIN
	SET @o_xmlText =
					(
						SELECT
						(
							SELECT
							C.policyDetails AS 'policy',
							(
								SELECT
								A.subclientId AS '@subclientId',
7 as '@_type_'
								FOR XML PATH ('subclient'), TYPE
							)
							FROM
							APP_EmailConfigPolicyAssoc A, APP_EmailConfigPolicies B, APP_ConfigurationPolicyDetails C
							WHERE
							A.assocId = B.componentNameId AND
							A.mailBoxType IN (1, 2, 3)
							AND B.policyType = 3/*Retention*/
							AND B.policyId = C.componentNameId
							AND A.modified = 0
							AND B.modified = 0
							AND C.modified = 0
							AND A.subClientId = @inSubclientId
							AND A.userGuid = @mailboxGUID
							FOR XML PATH('retentionInfo'), TYPE
						)
						FOR XML PATH('Api_GetExchangeIdxRetentionInfoResp'), TYPE
					)
END
PROC_END:
DROP TABLE #deletedMbxTbl
IF @o_xmlText IS NULL
	SET @o_xmlText = '<Api_GetExchangeIdxRetentionInfoResp/>'
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExchangeIdxRetentionInfo')
	delete from GxQscripts where name = 'AppGetExchangeIdxRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeIdxRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetExchangeIdxRetentionInfo'
GO

insert into GXDBVersions values(2, 'AppGetExchangeIdxRetentionInfo',  'v1.1.2.22.14.1', 'AppGetExchangeIdxRetentionInfo', 'v1.1.2.22.14.1')
GO

