

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchangeClouds.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetExchangeClouds()
--  | Description:  Returns the SOLR URLs associated to the subclients.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExchangeClouds.sp,v $ $Id: AppGetExchangeClouds.sp,v 1.1.2.30 2020/07/29 10:14:08 jraju Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetExchangeClouds')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExchangeClouds <<<'
	drop procedure AppGetExchangeClouds
END
IF EXISTS (select * from GxQscripts where name='AppGetExchangeClouds')
	delete from GxQscripts where name = 'AppGetExchangeClouds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeClouds')
	delete from GXDBVersions where aliasname = 'AppGetExchangeClouds'
GO
print '... Creating Procedure: AppGetExchangeClouds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExchangeClouds
  @inputXml xml
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @i_shouldSelectOutput INT = 0
	-- if out table exists, output will be inserted into the table for caller SP to read it
	IF OBJECT_ID('tempdb.dbo.#AppGetExchangeCloudsOutTable') IS NULL
	BEGIN
		SET @i_shouldSelectOutput = 1
		CREATE TABLE #AppGetExchangeCloudsOutTable(     ciServerXML xml )
	END
	DECLARE @outputXML XML
	DECLARE @corePrefix  nvarchar(max)
	DECLARE @backupSetStr uniqueidentifier
	DECLARE @indexServerClientId integer = -1
	DECLARE @alternateIndexServerClientId integer = -1
	DECLARE @recoveryPointId INT = 0
	DECLARE @dataSourceId INT = 0
	DECLARE @subclientId INT
	DECLARE @mbxGUID	 VARCHAR(64)
	DECLARE @coreId INT = -1
	DECLARE @backupsetType		INT
	DECLARE @indexServerType	INT
	DECLARE @isNewSchema INT = 0
	DECLARE @cloudId	INT
	DECLARE @srcClientId	INT = 0
	DECLARE @multiNodeDSId INT = 0
	DECLARE @multiCloud TABLE
	(
		subclientId		int,
		cloudId			int,
		collectionName	varchar(128),
		backupsetType	int,
		dataSourceId	int
	)
	DECLARE @coreNameTbl TABLE
	(
		coreId int,
		name varchar(64)
	)
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
	DROP TABLE #getCollectionInfoOutTbl
	CREATE TABLE #getCollectionInfoOutTbl
	(
		DatasourceId INT,
		CloudId INT,
		CollectionName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
        IdxServerClientId INT
	)
	SET @subclientId = ISNULL((SELECT ref.value('@subclientId', 'INTEGER')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq/exchangeEntity/subClient') R(ref)), 0)
	SET @mbxGUID = ISNULL((SELECT ref.value('@GUID', 'VARCHAR(64)')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq/exchangeEntity/mbxGUIDs') R(ref)), '')
	SET @backupSetStr = (SELECT ref.value('@backupsetGUID', 'uniqueidentifier')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq') R(ref))
	SET @corePrefix = (SELECT ref.value('@corePrefix', 'nvarchar(max)')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq') R(ref))
	SET @alternateIndexServerClientId = ISNULL((SELECT ref.value('@alternateIndexServerClientId', 'INTEGER')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq') R(ref)), -1)
	SET @recoveryPointId = ISNULL((SELECT ref.value('@recoveryPointId', 'INTEGER')FROM @inputXml.nodes('DM2ContentIndexing_GetExchangeCloudsReq') R(ref)), 0)
	IF @subclientId = 0 AND LEN(@backupSetStr) > 0
		SET @subclientId = ISNULL((SELECT TOP 1 id FROM App_Application WHERE backupSet = (SELECT id FROM App_BackupSetName WHERE GUID = @backupSetStr)), 0)
	SET @backupsetType = (SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp(NOLOCK) WHERE attrName = 'Exchange OnePass BackupSet Type' AND modified = 0 AND
							componentNameId = (SELECT distinct backupset FROM App_Application(NOLOCK) WHERE id = @subclientId/*Subclient*/))
	IF @recoveryPointId > 0
	BEGIN
		-- Fetch datasourceId from the recovery point table.
		IF @corePrefix = 'metainfo'
			SET @dataSourceId = ISNULL((SELECT initRequest.value('(/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo/@metadataSourceId)[1]', 'INT')
							FROM APP_LiveBrowseRecoveryPoints WHERE id = @recoveryPointId), -1)
		ELSE
			SET @dataSourceId = ISNULL((SELECT initRequest.value('(/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo/@dataSourceId)[1]', 'INT')
							FROM APP_LiveBrowseRecoveryPoints WHERE id = @recoveryPointId), -1)
		SET @alternateIndexServerClientId = ISNULL((SELECT initRequest.value('(/databrowse_BrowseRequest/advOptions/advConfig/browseAdvancedConfigReq/additionalFlags[@flagType="13"]/@value)[1]', 'INT')
							FROM APP_LiveBrowseRecoveryPoints WHERE id = @recoveryPointId), 0)
	END
	IF @alternateIndexServerClientId > 0
		SET @indexServerClientId = @alternateIndexServerClientId
	ELSE
		SET @indexServerClientId = ISNULL((SELECT CAST(attrVal AS INT) FROM App_IdaProp
						WHERE componentNameId in (SELECT A.id FROM App_IdaName A, App_Application B WHERE B.clientId = A.clientId AND A.appTypeId = B.appTypeID AND B.id = @subclientId)
						AND attrName = 'OnePass Index Server' AND modified = 0), -1)
	SELECT @cloudId = cloudId, @indexServerType = CloudType FROM DM2Cloud WHERE pseudoClientId = @indexServerClientId
	SELECT @backupSetStr = GUID FROM APP_BackupSetName WHERE ID =(SELECT backupset FROM APP_Application WHERE id = @subclientId)
	SELECT @srcClientId = clientId FROM App_Application WHERE id = @subclientId
	IF @dataSourceId = 0
	BEGIN
		IF @corePrefix != 'metainfo'
		BEGIN
			IF @backupsetType = 1/*App::ExchangeOnePassBackupsetType_USER_MAILBOXES*/
				SET @corePrefix = 'usermbx'
			ELSE IF @backupsetType = 2
				SET @corePrefix = 'journalmbx'
			ELSE IF @backupsetType = 3
				SET @corePrefix = 'contentstorembx'
			ELSE
				SET @corePrefix = 'not supported'
		END
		EXEC AppGetCloudCollectionInfo @cloudId, 'exchange', @corePrefix, @i_shouldSelectOutput=0, @i_propertyName1 = 'backupsetguid', @i_propertyValue1 = @backupSetStr
		IF EXISTS ( SELECT COUNT(*) from #getCollectionInfoOutTbl where CloudId = @cloudId )
			SELECT @dataSourceId=DatasourceId FROM #getCollectionInfoOutTbl
	END
	IF @indexServerType = 1 /*Standalone*/
	BEGIN
		DECLARE @useCvSolrForExchange INT
		IF @recoveryPointId > 0 /*RecoverPoint*/
			SET @isNewSchema = 1
		ELSE IF dbo.GetPropValue('Case Manager Pseudo Client', @srcClientId) = '1' /*CaseManager Client*/
			SET @isNewSchema = 1
		ELSE
		BEGIN
			DECLARE @oldSchema INT
			SET @oldSchema = ISNULL((select CAST(PropertyValue AS INT) from SEDataSourceProperty where datasourceId = @dataSourceId and PropertyId IN(select propertyId From SEProperty where PropertyName = 'schemaversion')), 0)
			SET @isNewSchema = 0
			IF @oldSchema = 1
				SET @isNewSchema = 0
			ELSE
				BEGIN
					SET @useCvSolrForExchange = ISNULL((SELECT TOP 1 CAST(value AS INT) FROM GXGlobalParam WHERE name = 'UseCvSolrForExchange' and modified = 0), 1)
					IF @backupsetType = 1/*UserMbx*/
						SET @isNewSchema = @useCvSolrForExchange & 1
					ELSE IF @backupsetType = 2/*JournalMbx*/
						SET @isNewSchema = @useCvSolrForExchange & 2
					ELSE
						SET @isNewSchema = @useCvSolrForExchange & 4
					IF @isNewSchema > 0
						SET @isNewSchema = 1
				END
		END
	END
	IF @indexServerType IN (4,5) OR (@indexServerType = 1 AND @isNewSchema = 1) -- Solr Cloud or standlone with new schema.
	BEGIN
		INSERT INTO @multiCloud
		SELECT @subclientId, @cloudId, dbo.SEGetCollectionName(@dataSourceId), @backupsetType, @dataSourceId
	END
	ELSE
	BEGIN
		-- Standalone index server.
		IF @backupsetType = 1/*App::ExchangeOnePassBackupsetType_USER_MAILBOXES*/
		BEGIN
			INSERT INTO @coreNameTbl(coreId, name)
			VALUES(0, 'usermbx0'),
				  (1, 'usermbx1'),
				  (2, 'usermbx2'),
				  (3, 'usermbx3'),
				  (4, 'usermbx4'),
				  (5, 'usermbx5'),
				  (6, 'usermbx6'),
				  (7, 'usermbx7')
			-- If mailboxGUID is passed, use the corresponding core only.
			IF LEN(@mbxGUID ) > 0
			BEGIN
				IF @mbxGUID = '00000000X0000X0000X0000X000000000003' -- For legacy public folder which don't have the GUID entry in the App_EmailConfigPolicyAssoc table.
					SET @coreId = 3
				ELSE
					SET @coreId = ISNULL((SELECT top 1 coreId FROM APP_EmailConfigPolicyAssoc(NOLOCK) WHERE userGuid = @mbxGUID), -1)
				IF @coreId != -1
					DELETE FROM @coreNameTbl WHERE coreId != @coreId
			END
			INSERT INTO @multiCloud
			SELECT @subclientId, @cloudId, name, @backupsetType, @dataSourceId
			FROM @coreNameTbl
		END
		ELSE /*App::ExchangeOnePassBackupsetType_JOURNAL_MAILBOXES*/
		BEGIN
			INSERT INTO @multiCloud
			SELECT @subclientId, @cloudId, 'journalmbx', @backupsetType, @dataSourceId
		END
	END
	EXEC @multinodeDsId= GetMultinodeFederatedDataSourceId 0, NULL, 0, @datasourceId
	DECLARE @schemaVersion INT = 0
	SELECT @schemaVersion = CAST(ISNULL(PropertyValue, 0) AS INT) FROM SEDataSourceProperty DSP INNER JOIN
			SEProperty P WITH(NOLOCK) ON P.PropertyId = DSP.PropertyId AND
			P.PropertyGuid = 'C973E447-14F9-46C4-A987-CB98398023FC' -- schemaVersion property
			WHERE DSP.DataSourceId = @datasourceId
	SET @outputXML =
		(
			SELECT
			'http://'+ CL.net_hostname +':' + CONVERT(VARCHAR(10), c.Portno) + '/solr/' + MC.collectionName AS '@cIServerURL',
			C.ClientId AS '@clientId',
			CL.name AS '@clientName',
			MC.cloudId AS '@cloudID',
			CL.net_hostname AS '@hostName',
			C.portNo AS '@basePort',
			ISNULL((SELECT TOP 1 AP.stringVal FROM APP_ComponentProp AP WITH (NOLOCK)  WHERE AP.componentType = 2 AND AP.propertyTypeId = 1014 and AP.componentId = c.cloudid), '')  AS '@version',
			DC.name  AS '@engineName',
			MC.cloudId AS '@engineID',
			3 AS '@type',
			DC.cloudType AS '@serverType',
			DC.pseudoClientId AS '@indexServerClientId',
			MC.backupsetType AS '@backupSetType',
			@dataSourceId  AS '@dataSourceId',
			@isNewSchema AS '@isMultiNodeDataSource' ,-- Only Applicable for the StandAlone Engine.
			@multiNodeDSId AS '@multiNodeDataSourceId',
			@schemaVersion AS '@schemaVersion'
			FROM DM2SearchServerCoreInfo c WITH (NOLOCK)
			JOIN APP_Client CL WITH (NOLOCK) ON C.ClientId = CL.id
			JOIN DM2Cloud DC WITH (NOLOCK) ON C.CloudId = DC.cloudId
			JOIN @multiCloud MC ON MC.cloudId = c.cloudId
			FOR XML PATH('listOfCIServer'), ROOT('DM2ContentIndexing_CIServers')
		)
	IF @outputXML IS NULL
		SET @outputXML = '<DM2ContentIndexing_CIServers/>'
	INSERT INTO #AppGetExchangeCloudsOutTable 	SELECT @outputXML
	if ( @i_shouldSelectOutput = 1 )
	BEGIN
		select ciServerXML from #AppGetExchangeCloudsOutTable
		DROP TABLE #AppGetExchangeCloudsOutTable
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExchangeClouds')
	delete from GxQscripts where name = 'AppGetExchangeClouds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeClouds')
	delete from GXDBVersions where aliasname = 'AppGetExchangeClouds'
GO

insert into GXDBVersions values(2, 'AppGetExchangeClouds',  '00010001000200300000', 'AppGetExchangeClouds', '00010001000200300000')
GO

