

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchangeArchiveClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExchangeArchiveClients.sp,v $ $Id: AppGetExchangeArchiveClients.sp,v 1.7.294.2 2018/03/27 08:15:56 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetExchangeArchiveClients"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetExchangeArchiveClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetExchangeArchiveClients')
	drop procedure AppGetExchangeArchiveClients
IF EXISTS (select * from GxQscripts where name='AppGetExchangeArchiveClients')
	delete from GxQscripts where name = 'AppGetExchangeArchiveClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeArchiveClients')
	delete from GXDBVersions where aliasname = 'AppGetExchangeArchiveClients'
GO
print '... Creating Procedure: AppGetExchangeArchiveClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetExchangeArchiveClients
  @userId integer
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_instanceId integer
  DECLARE @o_bsetId integer
SET NOCOUNT ON
   IF object_id('tempdb.dbo.#entitiesWithExArchCapability') is not null DROP TABLE #entitiesWithExArchCapability
create table  #entitiesWithExArchCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
   EXEC sec_getUserObjects userId, 0, 0, '#entitiesWithExArchCapability'
DECLARE @clientTable TABLE ( id integer, name nvarchar(1024))
INSERT INTO @clientTable SELECT DISTINCT id,name  from APP_client CL
   INNER JOIN #entitiesWithExArchCapability sec ON
   capabilities = 2816911 OR
    ((((capabilities&524288) <> 0)) AND
   ((( sec.clientId = 0 )    OR
      (CL.id  = sec.clientId))
      AND  (sec.appTypeId  IN (67, 68)  OR  sec.appTypeId = 0 )))
WHERE ID in ( select clientId from APP_idaName where  apptypeId in ( 67, 68))
--Check if any content indexing engine is installed
If ((EXISTS(select * from gxglobalparam where name = 'Disable Oulook Compliance' )) OR (NOT EXISTS(select * from app_clientprop where attrname = 'Content Indexing Engine' )))
BEGIN
SELECT 1, '1', 1, 1, 1
END
ELSE
SELECT APP.clientId, CL.name, APP.appTypeId, APP.instance, APP.backupset FROM APP_application APP  inner JOIN
@clientTable CL ON CL.id = APP.clientId WHERE subclientStatus & 8 = 8 and apptypeId in ( 67, 68)
DROP TABLE #entitiesWithExArchCapability
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExchangeArchiveClients')
	delete from GxQscripts where name = 'AppGetExchangeArchiveClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchangeArchiveClients')
	delete from GXDBVersions where aliasname = 'AppGetExchangeArchiveClients'
GO

insert into GXDBVersions values(2, 'AppGetExchangeArchiveClients',  '00010007029400020000', 'AppGetExchangeArchiveClients', '00010007029400020000')
GO

