

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetExchVirtualClouds.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetExchVirtualClouds()
--  | Description:  Returns the SOLR URLs associated to the subclients.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetExchVirtualClouds.sp,v $ $Id: AppGetExchVirtualClouds.sp,v 1.1.4.4 2018/03/27 08:43:17 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetExchVirtualClouds <<<'

IF EXISTS (select * from sysobjects where name='AppGetExchVirtualClouds')
	drop procedure AppGetExchVirtualClouds
IF EXISTS (select * from GxQscripts where name='AppGetExchVirtualClouds')
	delete from GxQscripts where name = 'AppGetExchVirtualClouds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchVirtualClouds')
	delete from GXDBVersions where aliasname = 'AppGetExchVirtualClouds'
GO
print '... Creating Procedure: AppGetExchVirtualClouds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExchVirtualClouds
  @i_subClientId INT = 0,
  @i_includeSearchEngine INT = 0,
  @i_cloudId INT = 0,
  @i_ciServerXML XML OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @includeSearchEngine int = 0
	DECLARE @outputXML XML
	DECLARE @propertyTypeId integer = 0
	DECLARE @backupsetType INT
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#SearchEngines') IS NOT NULL
		DROP TABLE #SearchEngines
	CREATE TABLE #SearchEngines
	(
		id	int IDENTITY(1,1),
		cIServerURL		NVARCHAR(2048),
		clientId		INT,
		clientName		NVARCHAR(1024),
		cloudId			INT,
		hostName		NVARCHAR(256),
		baseport		INT,
		version			VARCHAR(1024),
		engineName		NVARCHAR(1024),
		engineID		INT,
		type			INT,
		serverType		INT,
		indexServerClientID INT,
		backupsetType   INT
	)
	IF @i_includeSearchEngine = 1
	BEGIN
		SET @backupsetType = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp(NOLOCK) WHERE attrName = 'Exchange OnePass BackupSet Type' AND modified = 0 AND
									  componentNameId = (SELECT distinct backupset FROM App_Application(NOLOCK) WHERE id = @i_subClientId /*Subclient*/)),0)
		IF @backupsetType = 0 -- Classic agent
		BEGIN
			IF EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE cloudId = @i_cloudId AND name ='Mailbox Index')
SET @propertyTypeId = 1040
			ELSE IF EXISTS (SELECT 1 FROM DM2Cloud (NOLOCK) WHERE cloudId = @i_cloudId AND name ='Journal Index')
SET @propertyTypeId = 1041
		END
		ELSE IF @backupsetType = 1 -- App::ExchangeOnePassBackupsetType_USER_MAILBOXES
SET @propertyTypeId = 1040
		ELSE /*App::ExchangeOnePassBackupsetType_JOURNAL_MAILBOXES*/
		BEGIN
SET @propertyTypeId = 1041
		END
		--get all associated exchange virtual cloud to physcial nodes info
IF EXISTS ( SELECT 1 FROM APP_ComponentProp WITH (NOLOCK) WHERE propertytypeid = @propertytypeid AND componentType =2 )
		BEGIN
			INSERT INTO #SearchEngines
			SELECT DISTINCT 'http://'+ CL.net_hostname +':' + CONVERT(VARCHAR(10), S.Portno) + '/solr/',
			S.ClientId,
			CL.name,
			CPROP.componentId, -- Virtual CloudID
			CL.net_hostname,
			S.portNo,
			ISNULL((SELECT TOP 1 AP.stringVal FROM APP_ComponentProp AP WITH (NOLOCK) WHERE AP.componentType = 2 AND AP.propertyTypeId = 1014 and AP.componentId = S.cloudid), ''),
			ISNULL((SELECT E.stringVal FROM APP_ComponentProp E WITH (NOLOCK) WHERE E.id = S.CloudId AND E.componentType = 1 AND E.propertyTypeId = 1),''),
			CPROP.componentId, -- Virtual CloudID
			3,
			S.cloudType,
			0,
			0
			FROM DM2SearchServerCoreInfo S WITH (NOLOCK)
			JOIN APP_Client CL WITH (NOLOCK) ON S.ClientId = CL.id
			JOIN APP_ComponentProp CPROP WITH (NOLOCK)  ON S.CloudId = CPROP.longval
WHERE CPROP.propertytypeid = @propertytypeid AND CPROP.componentType =2
		END
	END
	SET @outputXML = (
						SELECT cIServerURL AS '@cIServerURL',
							ClientId as '@clientId',
							clientName as '@clientName',
							cloudId as '@cloudID',
							hostName as '@hostName',
							basePort AS '@basePort',
							version AS '@version',
							engineName AS '@engineName',
							engineID AS '@engineID',
							type AS '@type',
							serverType AS '@serverType',
							indexServerClientId AS '@indexServerClientId',
							backupsetType AS '@backupSetType'
							FROM #SearchEngines
							ORDER BY id
							FOR XML PATH('listOfCIServer')
					 )
	IF @outputXML IS NOT NULL
		SET @i_ciServerXML.modify ('insert sql:variable("@outputXML") as last into (/DM2ContentIndexing_CIServers)[1]')
	DROP TABLE #SearchEngines
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetExchVirtualClouds')
	delete from GxQscripts where name = 'AppGetExchVirtualClouds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchVirtualClouds')
	delete from GXDBVersions where aliasname = 'AppGetExchVirtualClouds'
GO

insert into GXDBVersions values(2, 'AppGetExchVirtualClouds',  '00010001000400040000', 'AppGetExchVirtualClouds', '00010001000400040000')
GO

