

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEventsForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEventsForEntity.sp,v $ $Id: AppGetEventsForEntity.sp,v 1.1.2.1 2018/03/29 22:27:03 aselvanayagam Exp $";
--	+===================================================================+
--	| AppGetEventsForEntity - Get Comserv Events						|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEventsForEntity <<<'

IF EXISTS (select * from sysobjects where name='AppGetEventsForEntity')
	drop procedure AppGetEventsForEntity
IF EXISTS (select * from GxQscripts where name='AppGetEventsForEntity')
	delete from GxQscripts where name = 'AppGetEventsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEventsForEntity')
	delete from GXDBVersions where aliasname = 'AppGetEventsForEntity'
GO
print '... Creating Procedure: AppGetEventsForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEventsForEntity
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @userId INT = 0
	DECLARE @localeId INT = 0
	DECLARE @maxEventCount INT = 100
	DECLARE @o_xml XML
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
					FROM @i_xml.nodes ('App_GetEventsForEntityReq/processinginstructioninfo/user') R(ref)), @userId)
	SET @maxEventCount = ISNULL (( SELECT ref.value('@maxEventCount', 'INT')
					FROM @i_xml.nodes ('App_GetEventsForEntityReq') R(ref)), @maxEventCount)
	-- Check whether the user has view capability at commcell level. If so, he is unrestricted user
	DECLARE @userHasCapability int = 0
	EXEC sec_checkPermissionOnEntity @userId, 31, @userHasCapability OUTPUT, 2018, 2
	CREATE TABLE #entityTable
	(
		_type_ INT,								--_type_ as defined in CvEntities.x and App_Entity
		typeIndex INT,							--position of _type_ in the given XML
		originalXML XML,						--XML blob that contains _type_
		parentTag VARCHAR(128),					--parentTag of the XML blob
		entityName NVARCHAR(200),				--entity name in XML
		entityId VARCHAR(100),					--entity ID in XML (It is in varchar because there are some entities that fill GUID as id)
		idFound INT DEFAULT 0,					--flag to tell whether we have got the ID or not (Reason we have a separate flag is for those entities that come with wrong name and some ID, we need to populate error message. So cannot just rely on entityId alone)
		fieldName VARCHAR(64),					--field name of the entity id in .x (like clientId, applicationId, mediaAgentId, roleId, etc.)
		isCustomEntity INT DEFAULT 0			--how the entity comes in input XML. If it is custom entity, then we need to populate it back in the same way.
	)
	-- If user has view at commcell level, he can see everything
	IF @userHasCapability=1
	BEGIN
		EXECUTE EntityNameToIdConverterTableFormat @i_xml
		SET @o_xml =
		(	SELECT E.severity as '@severity', E.id as '@id'
			, case when E.jobId_h>0 OR E.jobId_l>0 then (POWER(CONVERT(bigint, 2), 32) * E.jobId_h + E.jobId_l) else NULL end as '@jobId'
			, E.timeSource as '@timeSource', E.subsystem '@subsystem', E.type as'@type', E.ack as '@acknowledge'
			, E.messageId as '@eventCode'
			, CONVERT(NVARCHAR(128),(CASE WHEN (E.messageId & POWER(2,17)) <> 0 THEN	(E.messageId / (POWER(2,18)) & 0xFFFF)
									ELSE (E.messageId / (POWER(2,24)) & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(E.messageId & 0x7FFF)) '@eventCodeString'
			, (SELECT E.clientID as '@clientId', E.client as '@clientName' for XML PATH ('clientEntity'), TYPE)
			, ENTITY.originalXML.query('/')
			FROM evMsg E WITH (READUNCOMMITTED) INNER JOIN #entityTable ENTITY ON ENTITY.entityId = E.entityId AND ENTITY._type_ = E.entityType
			FOR XML PATH ('events')
			, ROOT ('App_GetEventsForEntityResp')
		)
		-- Incase xml is emtpy, then assign emtpy response.
		IF @o_xml is null
		BEGIN
			SET @o_xml = '<App_GetEventsForEntityResp/>'
		END
	END
	ELSE
	BEGIN
		SET @o_xml = '<App_GetEventsForEntityResp><error errorCode="-1" errorMessage="User does not have permission"/></App_GetEventsForEntityResp>'
	END
	IF OBJECT_ID('tempdb.dbo.#entityTable') IS NOT NULL
		DROP TABLE #entityTable
	SELECT @o_xml
SET NOCOUNT OFF
GO
--Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetEventsForEntity')
	delete from GxQscripts where name = 'AppGetEventsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEventsForEntity')
	delete from GXDBVersions where aliasname = 'AppGetEventsForEntity'
GO

insert into GXDBVersions values(2, 'AppGetEventsForEntity',  '00010001000200010000', 'AppGetEventsForEntity', '00010001000200010000')
GO

