

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/05/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEntityServerList.sp,v $ $Id: AppGetEntityServerList.sp,v 1.3.12.3 2018/03/27 09:05:00 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityServerList <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityServerList')
	drop procedure AppGetEntityServerList
IF EXISTS (select * from GxQscripts where name='AppGetEntityServerList')
	delete from GxQscripts where name = 'AppGetEntityServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityServerList')
	delete from GXDBVersions where aliasname = 'AppGetEntityServerList'
GO
print '... Creating Procedure: AppGetEntityServerList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetEntityServerList
  @i_cloudIdList VARCHAR(255)
AS
  DECLARE @o_serverName NVARCHAR(255)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_cloudId INT
  DECLARE @o_fastHostName NVARCHAR(255)
  DECLARE @o_fastBasePort INT
  DECLARE @o_version VARCHAR(1024)
  DECLARE @o_engineName VARCHAR(1024)
  DECLARE @o_flags VARCHAR(1024)
BEGIN
	SET NOCOUNT ON
DECLARE @FastServers TABLE (	  serverName	NVARCHAR(MAX)
								, clientId		INT
								, clientName	NVARCHAR(MAX)
								, cloudId		INT
								, hostName	NVARCHAR(MAX)
								, baseport	INT
								, version		VARCHAR(1024)
								, engineName	VARCHAR(1024)
								, serverType	INT DEFAULT 3 --App::CloudServerType_SearchEngine
							  )
	DECLARE @t_ServerList	TABLE( attrVal NVARCHAR(1024),
							   attrName NVARCHAR(1024),
							   clientId INT)
	INSERT INTO @t_ServerList
	SELECT DISTINCT CLP.attrVal , CLP.attrName, CLP.componentNameId
	FROM APP_ClientProp AS CLP (NOLOCK)
	INNER JOIN APP_Client C (NOLOCK) ON C.id = CLP.componentnameId
	WHERE ( ( CLP.attrName = 'FAST_QPS_URL' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_hostname' AND CLP.modified = 0 )
			OR ( CLP.attrName = 'FAST_baseport' AND CLP.modified = 0 )
		)
AND  (C.status & 0x00002) = 0
		AND EXISTS ( SELECT componentnameId
				 FROM app_clientprop  (NOLOCK)
				 WHERE ( attrname = 'Content Index Server' OR attrname in ('PackageStateForId 257', 'PackageStateForId 261','PackageStateForId 260') )
					AND attrVal = '1'
					AND componentnameId = CLP.componentnameId)
	IF EXISTS (SELECT 1 FROM @t_ServerList)
	BEGIN
		INSERT INTO @t_ServerList
		SELECT DISTINCT CP.stringVal, 'FAST_Version', CLP.componentNameId
		FROM APP_ComponentProp CP (NOLOCK)
			INNER JOIN APP_ClientProp AS CLP (NOLOCK) ON CP.componentId = CLP.attrVal AND CLP.attrName = 'CLOUD_ID'
			INNER JOIN 	@t_ServerList ON CLP.componentNameId = clientId
WHERE (  CP.componentType = 2 AND CP.propertyTypeId = 1014 AND CP.modified = 0 	)
		INSERT INTO @t_ServerList
		SELECT CP.stringVal,'UNITY_NAME',CP.id * -1
FROM ( select componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1023 ) UNITY_SERVER
			INNER JOIN APP_ComponentProp CP (NOLOCK) ON UNITY_SERVER.componentId = CP.id
		INSERT @FastServers	(serverName, clientId, clientName, cloudId, hostName, baseport, version, engineName)
		SELECT [FAST_QPS_URL] AS serverName ,
			   clientId,
			   clientName,
			   cloudId,
			   [FAST_hostname] AS hostName,
			   [FAST_baseport] AS baseport,
			   [FAST_Version] AS version,
			   (SELECT ISNULL(StringVal, '')  FROM APP_ComponentProp (NOLOCK)
						WHERE id = cloudId )AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId, dbo.APP_Client.net_hostname AS clientName, CAST(dbo.APP_ClientProp.attrVal AS INT) AS cloudId
			FROM @t_ServerList AS SL LEFT OUTER JOIN
			dbo.APP_Client (NOLOCK) ON dbo.APP_Client.id = Sl.clientId LEFT OUTER JOIN
			dbo.APP_ClientProp (NOLOCK) ON dbo.APP_ClientProp.componentNameId = SL.clientId AND dbo.app_clientprop.attrName = 'CLOUD_ID'
			WHERE SL.clientId > 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[FAST_hostname],[FAST_baseport], [FAST_Version] )
		) AS P
		UNION ALL
		SELECT [FAST_QPS_URL] AS serverName ,
			   0 AS clientId,
			   [UNITY_NAME] AS clientName,
			   -(clientId) AS cloudId,
			   '' AS hostName,
			   0 AS baseport,
			   '4.3' AS version,
			   '' AS engineName
		FROM (
			select SL.attrName AS attName, SL.attrVal AS attVal , SL.clientId AS clientId
			FROM @t_ServerList SL
			WHERE SL.clientId <= 0
			) AS FastServerList
		PIVOT ( MAX( attVal ) FOR attName IN ( [FAST_QPS_URL],[UNITY_NAME])
		) AS Q
	END
	SELECT  serverName + RM.contextName AS serverName
			, T.clientId
			, clientName
			, T.cloudId
			, hostName
			, baseport
			, RM.roleTypeVersion AS Version
			, engineName
			, M.Flags
	FROM @FastServers T
			INNER JOIN DM2SearchEngineCloudMapping M  WITH (NOLOCK) ON T.cloudId = M.DestCloudId AND M.SharingType =2 AND M.flags  <> 2
			INNER JOIN DM2SearchServerCoreInfo S  WITH (NOLOCK) ON S.cloudId = M.DestCloudId
			INNER JOIN DM2CloudCoreRole R  WITH (NOLOCK) ON R.CloudId = S.CloudId
			INNER JOIN DM2CloudRoleMaster RM  WITH (NOLOCK) ON R.roleId = RM.RoleType AND RM.flags=1
	WHERE M.SrcCloudId IN (SELECT _id FROM dbo.SplitIDs(@i_cloudIdList))
	ORDER BY engineName
	SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityServerList')
	delete from GxQscripts where name = 'AppGetEntityServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityServerList')
	delete from GXDBVersions where aliasname = 'AppGetEntityServerList'
GO

insert into GXDBVersions values(2, 'AppGetEntityServerList',  '00010003001200030000', 'AppGetEntityServerList', '00010003001200030000')
GO

