

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityPropData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityPropData <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityPropData')
	drop procedure AppGetEntityPropData
IF EXISTS (select * from GxQscripts where name='AppGetEntityPropData')
	delete from GxQscripts where name = 'AppGetEntityPropData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityPropData')
	delete from GXDBVersions where aliasname = 'AppGetEntityPropData'
GO
print '... Creating Procedure: AppGetEntityPropData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityPropData
-- INPUT PARAMS
  @localeId integer,
  @entityId integer,
  @entityType integer,
  @propertyName varchar(MAX)
AS
-- OUT PARAMS
  DECLARE @password varchar(1024)=''
  DECLARE @errorCode integer=0
  DECLARE @errorstring nvarchar(MAX)=N''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--CLIENT_ENTITY = 3,
--APPTYPE_ENTITY = 4,
--INSTANCE_ENTITY = 5,
--BACKUPSET_ENTITY = 6,
--SUBCLIENT_ENTITY = 7,
IF @entityType <> 0 AND @entityId <> 0
BEGIN
	IF  (@entityType = 5)
		SET @entityId = (SELECT TOP 1 clientId FROM APP_APPLICATION WHERE instance = @entityId)
	ELSE IF  (@entityType = 6)
		SET @entityId = (SELECT TOP 1 clientId FROM APP_APPLICATION WHERE backupset = @entityId)
	ELSE IF  (@entityType = 7)
		SET @entityId = (SELECT TOP 1 clientId FROM APP_APPLICATION WHERE id = @entityId)
	SET @entityType = 3
END
ELSE
BEGIN
SET @errorcode = (2233 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	GOTO SP_END
END
IF (@entityType = 3) --EntityType_CLIENT_ENTITY
BEGIN
	IF @propertyName = 'DATA SECURITY PASSWORD'
	BEGIN
		-- IF PROPERTY NOT PRESENT OR DISABLED, NO VALIDATION REQUIRED RETURN SUCCESS
		-- Reading the encrypted Enable Data Security attributeValue and converting back to 0 and 1 respectively
		IF ISNULL((SELECT CASE attrVal
WHEN 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'  THEN 1
	                                                                  ELSE 0
END FROM APP_CLIENTPROP WHERE componentNameId = @entityId AND (attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807') AND modified = 0),0) = 0
		BEGIN
			SET @errorcode = 0
			GOTO SP_END
		END
		--IF data is not passed from command line, let users know that the client is locked and input is invalid or not provided.
		IF( @entityId = 0)
		BEGIN
SET @errorcode = (2234 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO SP_END
		END
		SET @password = (SELECT attrVal FROM APP_CLIENTPROP WHERE componentNameId = @entityId AND (attrName = @propertyName) AND modified = 0)
		IF  @password IS NULL OR  @password=''
		BEGIN
SET @errorcode = (2233 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
	END
END
SP_END:
IF @errorCode <> 0
BEGIN
	SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorcode, 0,2)
END
SELECT @password,@errorCode,@errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityPropData')
	delete from GxQscripts where name = 'AppGetEntityPropData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityPropData')
	delete from GXDBVersions where aliasname = 'AppGetEntityPropData'
GO

insert into GXDBVersions values(2, 'AppGetEntityPropData',  '00000000000000000000', 'AppGetEntityPropData', '00000000000000000000')
GO

