

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityIdByName.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEntityIdByName.sp,v $ $Id: AppGetEntityIdByName.sp,v 1.1.2.5 2018/03/22 01:47:38 jiechen Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 11/30/2015
-- Description:	returns id of the entity with name provided
-- Parameters : i_entityTypeId - type of the entity. One of the values specified in enum EntityType in
--                               vaultcx/Source/Common/XmlMessage/CvEntities.x
--              i_entityName   - name of the entitity which id should be retrieved
--              i_userId       - user id
--              o_xmlResponse  - output value. App::IdName xml message
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityIdByName <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityIdByName')
	drop procedure AppGetEntityIdByName
IF EXISTS (select * from GxQscripts where name='AppGetEntityIdByName')
	delete from GxQscripts where name = 'AppGetEntityIdByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityIdByName')
	delete from GXDBVersions where aliasname = 'AppGetEntityIdByName'
GO
print '... Creating Procedure: AppGetEntityIdByName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityIdByName
  @i_entityTypeId INT,
  @i_entityName NVARCHAR(1024),
  @i_userId INT,
  @o_xmlResponse XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET @o_xmlResponse =
(
	SELECT  (SELECT CASE @i_entityTypeId WHEN   3 /* CLIENT_ENTITY          */ THEN (SELECT id FROM APP_Client WHERE name = @i_entityName)
										 WHEN   9 /* LIBRARY_ENTITY         */ THEN (SELECT LibraryId FROM MMLibrary WHERE AliasName = @i_entityName)
										 WHEN  17 /* STORAGE_POLICY_ENTITY  */ THEN (SELECT id FROM archGroup WHERE name = @i_entityName)
									     WHEN  28 /* CLIENT_GROUP_ENTITY    */ THEN (SELECT id FROM APP_ClientGroup WHERE name = @i_entityName)
										 WHEN  35 /* SCHEDULE_POLICY_ENTITY */ THEN (SELECT taskId FROM TM_Task WHERE taskName = @i_entityName)
										 WHEN  65 /* SUBCLIENT_POLICY_ENTITY*/ THEN (SELECT BSN.id FROM APP_BackupSetName BSN INNER JOIN APP_Application APP ON BSN.id = APP.backupSet AND APP.appTypeId = 1030 WHERE BSN.name = @i_entityName)
										 WHEN  69 /* TASK_ENTITY		    */ THEN (SELECT taskId FROM TM_Task WHERE taskName = @i_entityName)
										 WHEN 158 /* PLAN_ENTITY		    */ THEN (SELECT id FROM App_Plan WHERE name = @i_entityName AND ownerId = @i_userId)
					ELSE 0 END) AS '@id',
			@i_entityName		AS '@name'
	FOR XML PATH('App_IdName')
)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityIdByName')
	delete from GxQscripts where name = 'AppGetEntityIdByName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityIdByName')
	delete from GXDBVersions where aliasname = 'AppGetEntityIdByName'
GO

insert into GXDBVersions values(2, 'AppGetEntityIdByName',  '00010001000200050000', 'AppGetEntityIdByName', '00010001000200050000')
GO

