

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityExtendedProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEntityExtendedProp.sp,v $ $Id: AppGetEntityExtendedProp.sp,v 1.7.194.1 2017/05/08 11:41:57 jswaminathan Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppGetEntityExtendedProp()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Bhavyan		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityExtendedProp <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityExtendedProp')
	drop procedure AppGetEntityExtendedProp
IF EXISTS (select * from GxQscripts where name='AppGetEntityExtendedProp')
	delete from GxQscripts where name = 'AppGetEntityExtendedProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityExtendedProp')
	delete from GXDBVersions where aliasname = 'AppGetEntityExtendedProp'
GO
print '... Creating Procedure: AppGetEntityExtendedProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityExtendedProp
  @i_entityFilter XML ,
  @header XML OUTPUT ,
  @data XML OUTPUT
AS
  DECLARE @o_header XML
  DECLARE @o_data XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
IF @i_entityFilter IS NULL
BEGIN
	RETURN
END
DECLARE @i_entityType INT = ISNULL((SELECT ref.value('@entityType', 'INT') FROM @i_entityFilter.nodes ('App_ExtendedSummaryReq') R(ref)),0)
IF @i_entityType = 0
BEGIN
	RETURN
END
IF (@i_entityType = 28) -- client group entity
BEGIN
	DECLARE @clientGroupId INT = ISNULL((SELECT ref.value('@clientGroupId', 'INT') FROM @i_entityFilter.nodes ('App_ExtendedSummaryReq/entity') R(ref)),0)
	IF @clientGroupId = 0
	BEGIN
		RETURN
	END
	DECLARE @outTable TABLE (clientGroupId int NULL DEFAULT 0, header XML, data XML)
	INSERT INTO @outTable (header, data)
	EXEC GetClientExtendedProperties '<App_ExtendedSummaryReq entityType="3"><entity /></App_ExtendedSummaryReq>', -- always execute it for client
		@o_header = @header OUTPUT,
		@o_data = @data OUTPUT
	UPDATE @outTable
	SET clientGroupId = @clientGroupId
	SET @data = (SELECT data.query('(/data/Client[@name = sql:column("C.name")])')
				 FROM @outTable T INNER JOIN APP_ClientGroupAssoc CG ON T.clientGroupId = CG.clientGroupId
								 INNER JOIN APP_Client C ON C.id = CG.clientId
				 FOR XML PATH(''),ROOT('data'))
	SELECT @header,@data
END
ELSE
BEGIN
	DECLARE @entityName varchar(max) = ISNULL((SELECT entityName FROM App_Entitydetails WHERE entityType = @i_entityType),'')
	IF @entityName IS NULL OR LEN(@entityName) = 0
	BEGIN
	--	PRINT 'INVALID EntityType passed'
		RETURN
	END
	DECLARE @entitySPName VARCHAR(MAX) = 'Get' + @entityName + 'ExtendedProperties'
	--PRINT @entitySpName
	IF OBJECT_ID(@entitySPName) <> 0
	BEGIN
		DECLARE @entitySPSql nvarchar(max) = N'EXEC ' + @entitySPName + ' ''' + CAST (@i_entityFilter AS NVARCHAR(MAX)) +  ''' ,NULL, NULL'
	--	PRINT @entitySPSql
		EXEC sp_executeSql @entitySPSql
	END
END
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityExtendedProp')
	delete from GxQscripts where name = 'AppGetEntityExtendedProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityExtendedProp')
	delete from GXDBVersions where aliasname = 'AppGetEntityExtendedProp'
GO

insert into GXDBVersions values(2, 'AppGetEntityExtendedProp',  '00010007019400010000', 'AppGetEntityExtendedProp', '00010007019400010000')
GO

