

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityClientAssoc.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEntityClientAssoc.sp,v $ $Id: AppGetEntityClientAssoc.sp,v 1.5.34.15 2020/09/25 11:00:56 csingh Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetEntityClientAssoc   - Get Entity client association details
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEntityClientAssoc')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEntityClientAssoc <<<'
	drop procedure AppGetEntityClientAssoc
END
IF EXISTS (select * from GxQscripts where name='AppGetEntityClientAssoc')
	delete from GxQscripts where name = 'AppGetEntityClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetEntityClientAssoc'
GO
print '... Creating Procedure: AppGetEntityClientAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityClientAssoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_archGroupId integer,
  @i_localeId integer=0,
  @i_userId integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @o_XMLStr XML
DECLARE @appIdList TABLE (t_appId INT, t_clientId INT, t_appTypeId INT, t_instanceId INT, t_bkpSetId INT)
DECLARE @entityList TABLE (t_entityId INT, t_entityName VARCHAR(512), t_enabled INT)
DECLARE @entityLocaleList TABLE (t_entityId INT, t_entityLocaleMsgId INT, t_entityName VARCHAR(512))
DECLARE @contentAnalyzerList TABLE (t_clientId INT, t_clientName VARCHAR(512), t_enabled INT)
DECLARE @SYSTEM_DEFINED_ENTITY INT = 2
--localized entityName
INSERT INTO @entityLocaleList (t_entityId, t_entityLocaleMsgId, t_entityName)
SELECT EntityID, CASE
WHEN Name ='ssn' THEN (2445 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Person' THEN (2446 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Organization' THEN (2447 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Location' THEN (2448 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Date' THEN (2449 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Time' THEN (2450 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Money' THEN (2451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Percentageisbn' THEN (2452 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='CreditCard' THEN (2453 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Email' THEN (2454 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Phone' THEN (2455 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='ipAddress' THEN (2456 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='BankRouting' THEN (2863 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='ITIN' THEN (2864 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='USDL' THEN (2865 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='Hostname' THEN (1785 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='FinanceTags' THEN (3221 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='FinlandHetu' THEN (3382 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='FranceINSEE' THEN (3383 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='GermanyPK' THEN (3384 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='GermanySteuerID' THEN (3385 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='GermanyVSNR' THEN (3386 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='GreeceAFM' THEN (3387 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='GreeceTautotita' THEN (3388 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='UKDL' THEN (3389 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='UKNHS' THEN (3390 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN Name ='UKNINO' THEN (3391 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					 END,
				Name
FROM EntityAnnotator WITH (NOLOCK)
where Enabled = 1 AND (Attribute & @SYSTEM_DEFINED_ENTITY) =  @SYSTEM_DEFINED_ENTITY AND EntityType IN (2, 3)
-- get data classfication containers for the user
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- adding tenant security
-- check if user belongs to a company
DECLARE @organizationId int = 0
DECLARE @DEFAULT_CUSTOM_CONTAINER_GUID nvarchar(40) = '22CD8879-B2FD-4A63-8096-B515FC13502D' -- default custom entity
DECLARE @custom_container_guid nvarchar(40) = @DEFAULT_CUSTOM_CONTAINER_GUID
DECLARE @dm2container_temp table(
    comment nvarchar(max),
    containerGuid nvarchar(40),
    containerId int,
    containerName nvarchar(max),
    containerType   int
)
SELECT @organizationId = dbo.AppGetOrganizationForUser(@i_userId)
IF @organizationId <> 0 AND EXISTS(SELECT 1 FROM UMDSProviders WHERE serviceType = 5) -- UMDS_PROVIDER_ORGANIZATIONS
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL
        DROP TABLE #UserHasPermissionOnEntity_temp
    CREATE TABLE #UserHasPermissionOnEntity_temp(entityId int)
EXEC dbo.sec_getNonIdaObjectsForThisUser @i_userId, 9517, 0, '#UserHasPermissionOnEntity_temp'
    SELECT TOP 1 @custom_container_guid = containerGuid FROM DM2Container DC INNER JOIN #UserHasPermissionOnEntity_temp UTEMP ON DC.containerId = UTEMP.entityId
    IF @custom_container_guid = @DEFAULT_CUSTOM_CONTAINER_GUID -- in case no custom container exists for the tenant yet, avoid showing global custom container entities
        SET @custom_container_guid = ''
END
-- get containers where user have permissions
INSERT INTO @dm2container_temp
SELECT comment, containerGuid, containerId, containerName, containerType
FROM DM2Container
WHERE containerType IN (9516, 9520) OR (containerType = 9517 and @custom_container_guid = CAST(containerGuid AS NVARCHAR(256)))
-- drop the custom parent container if no custom entity exists for the user
IF @custom_container_guid = ''
DELETE FROM @dm2container_temp WHERE containerGuid = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70' AND containerType=9520
INSERT INTO @entityLocaleList (t_entityId, t_entityLocaleMsgId, t_entityName)
SELECT EntityID,null, Name
FROM EntityAnnotator EA WITH (NOLOCK) INNER JOIN DM2DocTags DT WITH (NOLOCK) ON EA.EntityType IN (2, 3) AND CAST(EA.EntityID AS nvarchar(40)) = DT.TagValue WHERE CAST(containerGuid as NVARCHAR(40))=@custom_container_guid
--subclient lists
INSERT INTO @appIdList (t_appId , t_clientId , t_appTypeId , t_instanceId , t_bkpSetId )
SELECT DISTINCT  AP.id, AP.clientId, AP.appTypeId, instance, backupSet
FROM APP_Application AP WITH (NOLOCK)
	 INNER JOIN EntitySelection ER  WITH (NOLOCK) ON AP.id = ER.subClientId
WHERE dataArchGrpID = @i_archGroupId AND ER.Enabled = 1
AND (AP.subclientstatus & 0x20000) = 0
--USE LOCALIZED ENTITY NAME
INSERT INTO @entityList (t_entityId , t_entityName , t_enabled )
SELECT EntityID , ISNULL(dbo.fn_EvFormatEventMsgText(0, @i_localeId, t_entityLocaleMsgId, 0,2),L.t_entityName) , 0
FROM EntityAnnotator EA
	INNER JOIN @entityLocaleList L ON EA.EntityID = L.t_entityId
where EA.Enabled = 1
--entity selected
UPDATE @entityList
SET t_enabled = 1
FROM EntitySelection ER  WITH (NOLOCK)
		INNER JOIN @entityList T ON ER.EntityID = T.t_entityId
		INNER JOIN @appIdList A ON ER.SubclientID = A.t_appId
where ER.Enabled = 1
--entity extraction configured
DECLARE @isEEConfigured INT  = 0
IF EXISTS (SELECT * FROM @entityList where t_enabled = 1 )
SET @isEEConfigured = 1
--get all CA lists
INSERT INTO @contentAnalyzerList (t_clientId , t_clientName, t_enabled )
SELECT C.ID, C.name, 0
FROM simInstalledPackages S WITH (NOLOCK)
INNER JOIN APP_Client C WITH (NOLOCK) ON S.ClientId = C.id
WHERE S.simPackageID IN ( 729, 1108)
--CA client enabled
UPDATE @contentAnalyzerList
SET t_enabled = 1
FROM EntityProcessor EP
	INNER JOIN EntitySelection ES ON EP.EntityRulerId = ES.EntityRulerId
	INNER JOIN APP_Application AP ON ES.SubclientID = AP.id
WHERE  EP.ExtractingClientID = t_clientId AND AP.dataArchGrpID = @i_archGroupId
 SET @o_XMLStr = ISNULL (
							(SELECT
									(SELECT
										@isEEConfigured	AS '@isConfigured',
										(SELECT
											@i_archGroupId	AS '@archGroupId',
											A.t_clientId		AS '@clientId',
											A.t_appTypeId	AS '@appTypeId',
											A.t_instanceId	AS '@instanceId',
											A.t_bkpSetId	AS '@backupSetId',
											A.t_appId	AS '@subClientId'
											FROM @appIdList A
											FOR XML PATH('appList'), TYPE
										),
										(SELECT
											CA.t_enabled	AS '@enabled',
											(select
												CA.t_clientId		AS '@clientId',
												CA.t_clientName	AS '@clientName'
											 FOR XML PATH('eeClient'), TYPE
											 )
											FROM @contentAnalyzerList CA
											FOR XML PATH('extractingClientList'), TYPE
										),
										(SELECT
											EA.t_entityId AS '@entityId',
											EA.t_entityName AS '@entityName',
											EA.t_enabled AS '@enabled'
											FROM @entityList EA
											FOR XML PATH('entities'), TYPE
									)FOR XML PATH('EvGui_EntityExtraction'), TYPE
								)
							), '<EvGui_EntityExtraction/>')
SELECT @o_XMLStr
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityClientAssoc')
	delete from GxQscripts where name = 'AppGetEntityClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetEntityClientAssoc'
GO

insert into GXDBVersions values(2, 'AppGetEntityClientAssoc',  '00010005003400150000', 'AppGetEntityClientAssoc', '00010005003400150000')
GO

