

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityCapabilityXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityCapabilityXML <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityCapabilityXML')
	drop procedure AppGetEntityCapabilityXML
IF EXISTS (select * from GxQscripts where name='AppGetEntityCapabilityXML')
	delete from GxQscripts where name = 'AppGetEntityCapabilityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityCapabilityXML')
	delete from GXDBVersions where aliasname = 'AppGetEntityCapabilityXML'
GO
print '... Creating Procedure: AppGetEntityCapabilityXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityCapabilityXML
  @type INT,
  @id INT,
  @XMLText XML OUTPUT
AS
DECLARE @individualCapabilities AS BIGINT
DECLARE @inheritedCapabilities AS BIGINT
DECLARE @individualTbl TABLE
(
	individualCap BIGINT
)
DECLARE @inheritedTbl TABLE
(
	inheritedCap BIGINT
)
if(dbo.isNewSecurity()=0)
BEGIN
SET @individualCapabilities = ISNULL((SELECT DISTINCT TOP 1 (capabilities)				--TOP 1 has been added to be on the safer side, anyhow all the owners will have the same capability on the entity
							  FROM UMUserandGroupEntityAssociation
							  WHERE entityType = @type AND objectId = @id AND ownerUserId <> 0),0)
SET @inheritedCapabilities = ISNULL((SELECT CAST(value AS BIGINT)
								    FROM GXGlobalParam with (nolock)
								    WHERE name = 'SystemOwnerCapibilities'),0)
--For client item, get the capabilities of client group also
IF @type = 2009
	SET @inheritedCapabilities |= ISNULL((SELECT dbo.bitwiseor(UGEA.capabilities )
										  FROM APP_ClientGroupAssoc CGA with (nolock) INNER JOIN UMUserandGroupEntityAssociation UGEA with (nolock)
										  ON UGEA.objectId = CGA.clientGroupId
WHERE CGA.clientId = @id AND UGEA.entityType = 2572 AND UGEA.userId = 0),0)
INSERT INTO @individualTbl
 SELECT id
 FROM UMCapability with (nolock)
 WHERE @individualCapabilities & CAST(POWER(2.0,id-1) AS BIGINT)  = CAST(POWER(2.0,id-1) AS BIGINT)
INSERT INTO @inheritedTbl
 SELECT id
 FROM UMCapability with (nolock)
 WHERE @inheritedCapabilities & CAST(POWER(2.0,id-1) AS BIGINT)  = CAST(POWER(2.0,id-1) AS BIGINT)
END
ELSE
BEGIN
	INSERT INTO @individualTbl
	SELECT DISTINCT dbo.sec_permissionToCapability(permissionId)
    FROM dbo.sec_getOwnerPermissions(dbo.sec_ObjectTypetoEntityType(@type),@id)
	where  dbo.sec_permissionToCapability(permissionId) IS NOT NULL
IF(@type<>2009)
		INSERT INTO @inheritedTbl
		SELECT DISTINCT  dbo.sec_permissionToCapability(permissionId)
FROM dbo.sec_getOwnerPermissions(1,2)
	ELSE
		INSERT INTO @inheritedTbl
		SELECT DISTINCT  dbo.sec_permissionToCapability(permissionId)
FROM dbo.sec_getOwnerPermissions(1,2)
		UNION
		SELECT DISTINCT dbo.sec_permissionToCapability(permissionId)
FROM APP_ClientGroupAssoc CGA with (nolock) CROSS APPLY dbo.sec_getOwnerPermissions(28,CGA.clientGroupId)
										  	  WHERE CGA.clientId = @id
		 AND dbo.sec_permissionToCapability(permissionId) IS NOT NULL
END
SET @xmlText = (SELECT(SELECT DISTINCT inheritedCap AS '@val'
			   FROM @inheritedTbl
			   FOR XML PATH('inheritedCapabilities'),TYPE),
			   (SELECT DISTINCT individualCap AS '@val'
			   FROM @individualTbl
			   FOR XML PATH ('individualCapabilities'),TYPE)
			  FOR XML PATH (''),TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityCapabilityXML')
	delete from GxQscripts where name = 'AppGetEntityCapabilityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityCapabilityXML')
	delete from GXDBVersions where aliasname = 'AppGetEntityCapabilityXML'
GO

insert into GXDBVersions values(2, 'AppGetEntityCapabilityXML',  '00000000000000000000', 'AppGetEntityCapabilityXML', '00000000000000000000')
GO

