

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityAuditNotes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEntityAuditNotes <<<'

IF EXISTS (select * from sysobjects where name='AppGetEntityAuditNotes')
	drop procedure AppGetEntityAuditNotes
IF EXISTS (select * from GxQscripts where name='AppGetEntityAuditNotes')
	delete from GxQscripts where name = 'AppGetEntityAuditNotes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityAuditNotes')
	delete from GXDBVersions where aliasname = 'AppGetEntityAuditNotes'
GO
print '... Creating Procedure: AppGetEntityAuditNotes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntityAuditNotes
  @entityType INT,
  @entityId INT
AS
DECLARE @xmlQuery XML
IF object_id('tempdb.dbo.#OpTableTmp') is not null DROP TABLE #OpTableTmp
create table #OpTableTmp( opid int, severity int)
INSERT INTO #OpTableTmp
SELECT o.id, e.severity
	FROM evMsg e WITH (NOLOCK)
	INNER JOIN EvGuiAuditOperation o WITH (NOLOCK)
	ON e.id = o.evMsgId AND e.type = 2 AND e.messageId = 1409286622 AND o.entityType = @entityType AND o.EntityId = @entityId
SET @xmlQuery = (
SELECT
o.severity/3 + 1 as '@severity',
ep.data as '@notes',
e.userID as 'user/@userId',
u.login as 'user/@userName',
e.timeServer as 'date/@time'
	FROM evMsg e WITH (NOLOCK)
	INNER JOIN EvGuiAuditParameter p WITH (NOLOCK)
	ON e.id = p.evMsgId AND e.type = 2 AND e.messageId = 1426064727
	INNER JOIN #OpTableTmp o
	ON p.opId = o.opid
	INNER JOIN evParam ep WITH (NOLOCK)
	ON e.id = ep.evMsgId
	INNER JOIN UMUsers u WITH (NOLOCK)
	ON e.userID = u.id
	order by e.timeServer desc, e.severity
for xml path('entityAuditList'))
DROP TABLE #OpTableTmp
SELECT @xmlQuery
FOR XML PATH ('App_GetEntityAuditResp')

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityAuditNotes')
	delete from GxQscripts where name = 'AppGetEntityAuditNotes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityAuditNotes')
	delete from GXDBVersions where aliasname = 'AppGetEntityAuditNotes'
GO

insert into GXDBVersions values(2, 'AppGetEntityAuditNotes',  '00000000000000000000', 'AppGetEntityAuditNotes', '00000000000000000000')
GO

